#!/usr/local/bin/perl
eval "exec /usr/local/bin/perl -S $0 $*"
    if $running_under_some_shell;
			# this emulates #! processing on NIH machines.
			# (remove #! line above if indigestible)

eval '$'.$1.'$2;' while $ARGV[0] =~ /^([A-Za-z_]+=)(.*)/ && shift;
			# process any FOO=bar switches

# Converts an nmrview 2d NOE file into X-PLOR digestible format.
# It is assumed that the proton frequencies have been read into store1 
# in X-PLOR before the restraints file is read in.
# peak type 2= explicit assignment
#
# Author: Michael Nilges, EMBL
# modified by Kristy Downing (Oxford) for NMRView instead of XEASY and translated into Perl
#
$[ = 1;			# set array base to 1
$, = ' ';		# set output field separator
$\ = "\n";		# set output record separator

$fn = $ARGV;

while (<>) {
    chop;	# strip record separator
    @Fld = split(' ', $_, 9999);

    if (($Fld[1] eq '#') || ($Fld[1] eq '!') || ($Fld[1] eq 'label') || ($Fld[1] =~ /\D1/ )
         || ($Fld[1] =~ /\mat/) || ($Fld[1] =~ /\{/)) {
	;
    }
   elsif ($#Fld == 0) {
	;
    }
    else {
	$peaktype = 1;
	$peak = $Fld[1];
	$w1 = $Fld[3];
	$w1label = $Fld[2];
	$w1error = $Fld[5];
	$w2label = $Fld[8];
	$w2 = $Fld[9];
	$w2error = $Fld[11];
	$volume = $Fld[15];
	#print $peak, ' ', $w1label, ' ', $w1, ' ', $w1error, ' ', $w2label,

	  ' ', $w2, ' ', $w2error,' ',$volume;
	if (($Fld[2] =~ /H/) || ($Fld[8] =~ /H/)) {
	    $peaktype = 2;
	    $index1 = index($Fld[2], '.');
	    $index2 = index($Fld[8], '.');
	    $firstres = substr($Fld[2], 1, $index1 - 1);
	    $secondres = substr($Fld[8], 1, $index2 - 1);
	    $firstat = substr($Fld[2], $index1 + 1, length($Fld[2]));
	    $secondat = substr($Fld[8], $index2 + 1, length($Fld[8]));
	}

	if ($volume == 0) {
	    $dist = 6.0;
	    $errp = 0.0;
	    $errm = 6.0;
	}
	else {
	    $dist = 6.0;
	    $errp = 0.1;
	    $errm = 0.1;
	}

	if ($peaktype == 1) {
	    print 'assi ( attr store1 < ', $w1 + $w1error / 2,

	      ' and attr store1 > ', $w1 - $w1error / 2, ' )';
	    print '     ( attr store1 < ', $w2 + $w2error / 2,

	      ' and attr store1 > ', $w2 - $w2error / 2, ' ) ';
	    print ' ', $dist, $errm, $errp, ' peak ', $Fld[1], ' volume ',

	      $volume, ' ppm1 ', $w1, ' ppm2 ', $w2;
	}
	if ($peaktype == 2) {
	    print 'assi (resid ', $firstres, ' and name ', $firstat,

	      ' ) (resid ', $secondres, ' and name ', $secondat, ' )';
	    print ' ', $dist, $errm, $errp, ' peak ', $Fld[1], ' volume ',

	      $volume, ' ppm1 ', $w1, 'ppm2', $w2, 'weight ' . 0.99;
	}
    }
}

