"""
replaces the module call of run.cns in all protocol headers
"""
__author__   = "$Author: linge $"
__revision__ = "$Revision: 1.1.1.1 $"
__date__     = "$Date: 1999/09/02 13:35:16 $"


ariaDirectory = '/home/linge/aria'
tmpDirectory = '/EMBL/scrap/linge'

runCnsCall = """@RUN:run.cns(
iniseed=$iniseed;init_t=$init_t;final1_t=$final1_t;final2_t=$final2_t;
tempstep=$tempstep;tadfactor=$tadfactor;InitioSteps=$InitioSteps;
RefineSteps=$RefineSteps;cool1_Steps=$cool1_Steps;cool2_Steps=$cool2_Steps;
fbeta=$fbeta;mass=$mass;fileroot=$fileroot;
template=$template;structure=$structure;
Ini_count_0=$Ini_count_0;Structures_0=$Structures_0;
KeepStruct_0=$KeepStruct_0;AmbigCutoff_0=$AmbigCutoff_0;
DistCutoff_0=$DistCutoff_0;MaxN_0=$MaxN_0;ViolToler_0=$ViolToler_0;
ViolRatio_0=$ViolRatio_0;AssignStruct_0=$AssignStruct_0;
Ini_count_1=$Ini_count_1;Structures_1=$Structures_1;
KeepStruct_1=$KeepStruct_1;AmbigCutoff_1=$AmbigCutoff_1;
DistCutoff_1=$DistCutoff_1;MaxN_1=$MaxN_1;ViolToler_1=$ViolToler_1;
ViolRatio_1=$ViolRatio_1;AssignStruct_1=$AssignStruct_1;
Ini_count_2=$Ini_count_2;Structures_2=$Structures_2;
KeepStruct_2=$KeepStruct_2;AmbigCutoff_2=$AmbigCutoff_2;
DistCutoff_2=$DistCutoff_2;MaxN_2=$MaxN_2;ViolToler_2=$ViolToler_2;
ViolRatio_2=$ViolRatio_2;AssignStruct_2=$AssignStruct_2;
Ini_count_3=$Ini_count_3;Structures_3=$Structures_3;
KeepStruct_3=$KeepStruct_3;AmbigCutoff_3=$AmbigCutoff_3;
DistCutoff_3=$DistCutoff_3;MaxN_3=$MaxN_3;ViolToler_3=$ViolToler_3;
ViolRatio_3=$ViolRatio_3;AssignStruct_3=$AssignStruct_3;
Ini_count_4=$Ini_count_4;Structures_4=$Structures_4;
KeepStruct_4=$KeepStruct_4;AmbigCutoff_4=$AmbigCutoff_4;
DistCutoff_4=$DistCutoff_4;MaxN_4=$MaxN_4;ViolToler_4=$ViolToler_4;
ViolRatio_4=$ViolRatio_4;AssignStruct_4=$AssignStruct_4;
Ini_count_5=$Ini_count_5;Structures_5=$Structures_5;
KeepStruct_5=$KeepStruct_5;AmbigCutoff_5=$AmbigCutoff_5;
DistCutoff_5=$DistCutoff_5;MaxN_5=$MaxN_5;ViolToler_5=$ViolToler_5;
ViolRatio_5=$ViolRatio_5;AssignStruct_5=$AssignStruct_5;
Ini_count_6=$Ini_count_6;Structures_6=$Structures_6;
KeepStruct_6=$KeepStruct_6;AmbigCutoff_6=$AmbigCutoff_6;
DistCutoff_6=$DistCutoff_6;MaxN_6=$MaxN_6;ViolToler_6=$ViolToler_6;
ViolRatio_6=$ViolRatio_6;AssignStruct_6=$AssignStruct_6;
Ini_count_7=$Ini_count_7;Structures_7=$Structures_7;
KeepStruct_7=$KeepStruct_7;AmbigCutoff_7=$AmbigCutoff_7;
DistCutoff_7=$DistCutoff_7;MaxN_7=$MaxN_7;ViolToler_7=$ViolToler_7;
ViolRatio_7=$ViolRatio_7;AssignStruct_7=$AssignStruct_7;
Ini_count_8=$Ini_count_8;Structures_8=$Structures_8;
KeepStruct_8=$KeepStruct_8;AmbigCutoff_8=$AmbigCutoff_8;
DistCutoff_8=$DistCutoff_8;MaxN_8=$MaxN_8;ViolToler_8=$ViolToler_8;
ViolRatio_8=$ViolRatio_8;AssignStruct_8=$AssignStruct_8;
nspectra=$nspectra;aspectrum_1=$aspectrum_1;aspectrum_2=$aspectrum_2;
aspectrum_3=$aspectrum_3;aspectrum_4=$aspectrum_4;aspectrum_5=$aspectrum_5;
peaklist_1=$peaklist_1;qshifts_1=$qshifts_1;shifts_1=$shifts_1;
qcalib_1=$qcalib_1;qerrset_1=$qerrset_1;offset_1=$offset_1;
err0_1=$err0_1;err1_1=$err1_1;err2_1=$err2_1;err3_1=$err3_1;
qexclude_1=$qexclude_1;restraintfile_1=$restraintfile_1;listfile_1=$listfile_1;
peaklist_2=$peaklist_2;qshifts_2=$qshifts_2;shifts_2=$shifts_2;
qcalib_2=$qcalib_2;qerrset_2=$qerrset_2;offset_2=$offset_2;
err0_2=$err0_2;err1_2=$err1_2;err2_2=$err2_2;err3_2=$err3_2;
qexclude_2=$qexclude_2;restraintfile_2=$restraintfile_2;listfile_2=$listfile_2;
peaklist_3=$peaklist_3;qshifts_3=$qshifts_3;shifts_3=$shifts_3;
qcalib_3=$qcalib_3;qerrset_3=$qerrset_3;offset_3=$offset_3;
err0_3=$err0_3;err1_3=$err1_3;err2_3=$err2_3;err3_3=$err3_3;
qexclude_3=$qexclude_3;restraintfile_3=$restraintfile_3;listfile_3=$listfile_3;
peaklist_4=$peaklist_4;qshifts_4=$qshifts_4;shifts_4=$shifts_4;
qcalib_4=$qcalib_4;qerrset_4=$qerrset_4;offset_4=$offset_4;
err0_4=$err0_4;err1_4=$err1_4;err2_4=$err2_4;err3_4=$err3_4;
qexclude_4=$qexclude_4;restraintfile_4=$restraintfile_4;listfile_4=$listfile_4;
peaklist_5=$peaklist_5;qshifts_5=$qshifts_5;shifts_5=$shifts_5;
qcalib_5=$qcalib_5;qerrset_5=$qerrset_5;offset_5=$offset_5;
err0_5=$err0_5;err1_5=$err1_5;err2_5=$err2_5;err3_5=$err3_5;
qexclude_5=$qexclude_5;restraintfile_5=$restraintfile_5;listfile_5=$listfile_5;
countspec=$countspec;xplortodiana=$xplortodiana;
prot_top=$prot_top;prot_link=$prot_link;prot_par=$prot_par;
par_nonbonded=$par_nonbonded;pdb_or_sequence=$pdb_or_sequence;prot_coor_1=$prot_coor_1;
prot_segid_1=$prot_segid_1;ss_bridge=$ss_bridge;
ss_i_resid_1=$ss_i_resid_1;ss_i_segid_1=$ss_i_segid_1;
ss_j_resid_1=$ss_j_resid_1;ss_j_segid_1=$ss_j_segid_1;
ss_i_resid_2=$ss_i_resid_2;ss_i_segid_2=$ss_i_segid_2;
ss_j_resid_2=$ss_j_resid_2;ss_j_segid_2=$ss_j_segid_2;
ss_i_resid_3=$ss_i_resid_3;ss_i_segid_3=$ss_i_segid_3;
ss_j_resid_3=$ss_j_resid_3;ss_j_segid_3=$ss_j_segid_3;
ss_i_resid_4=$ss_i_resid_4;ss_i_segid_4=$ss_i_segid_4;
ss_j_resid_4=$ss_j_resid_4;ss_j_segid_4=$ss_j_segid_4;
ss_i_resid_5=$ss_i_resid_5;ss_i_segid_5=$ss_i_segid_5;
ss_j_resid_5=$ss_j_resid_5;ss_j_segid_5=$ss_j_segid_5;
ss_ambigunambig=$ss_ambigunambig;
hisd_resid_1=$hisd_resid_1;hisd_resid_2=$hisd_resid_2;hisd_resid_3=$hisd_resid_3;
hisd_resid_4=$hisd_resid_4;hisd_resid_5=$hisd_resid_5;hisd_resid_6=$hisd_resid_6;
hisd_resid_7=$hisd_resid_7;hisd_resid_8=$hisd_resid_8;hisd_resid_9=$hisd_resid_9;
hisd_resid_10=$hisd_resid_10;
hise_resid_1=$hise_resid_1;hise_resid_2=$hise_resid_2;hise_resid_3=$hise_resid_3;
hise_resid_4=$hise_resid_4;hise_resid_5=$hise_resid_5;hise_resid_6=$hise_resid_6;
hise_resid_7=$hise_resid_7;hise_resid_8=$hise_resid_8;hise_resid_9=$hise_resid_9;
hise_resid_10=$hise_resid_10;
repel_radius=$repel_radius;repel_rcons=$repel_rcons;
repel_rexpo=$repel_rexpo;repel_irexp=$repel_irexp;
firstwater=$firstwater;waterrefine=$waterrefine;pmrefine_on=$pmrefine_on;
dihedrals_on=$dihedrals_on;hbonds_on=$hbonds_on;
hbondscsi_on=$hbondscsi_on;dihedralscsi_on=$dihedralscsi_on;
c1_on=$c1_on;
c1_karplusa=$c1_karplusa;c1_karplusb=$c1_karplusb;
c1_karplusc=$c1_karplusc;c1_karplusd=$c1_karplusd;
c1_hot=$c1_hot;c1_cool1=$c1_cool1;c1_cool2=$c1_cool2;
c2_on=$c2_on;
c2_karplusa=$c2_karplusa;c2_karplusb=$c2_karplusb;
c2_karplusc=$c2_karplusc;c2_karplusd=$c2_karplusd;
c2_hot=$c2_hot;c2_cool1=$c2_cool1;c2_cool2=$c2_cool2;
c3_on=$c3_on;
c3_karplusa=$c3_karplusa;c3_karplusb=$c3_karplusb;
c3_karplusc=$c3_karplusc;c3_karplusd=$c3_karplusd;
c3_hot=$c3_hot;c3_cool1=$c3_cool1;c3_cool2=$c3_cool2;
c4_on=$c4_on;
c4_karplusa=$c4_karplusa;c4_karplusb=$c4_karplusb;
c4_karplusc=$c4_karplusc;c4_karplusd=$c4_karplusd;
c4_hot=$c4_hot;c4_cool1=$c4_cool1;c4_cool2=$c4_cool2;
c5_on=$c5_on;
c5_karplusa=$c5_karplusa;c5_karplusb=$c5_karplusb;
c5_karplusc=$c5_karplusc;c5_karplusd=$c5_karplusd;
c5_hot=$c5_hot;c5_cool1=$c5_cool1;c5_cool2=$c5_cool2;
rdc1_choice=$rdc1_choice;rdc1_firstIt=$rdc1_firstIt;
rdc1_hot=$rdc1_hot;rdc1_cool1=$rdc1_cool1;
rdc1_cool2=$rdc1_cool2;rdc1_r=$rdc1_r;rdc1_d=$rdc1_d;
rdc2_choice=$rdc2_choice;rdc2_firstIt=$rdc2_firstIt;
rdc2_hot=$rdc2_hot;rdc2_cool1=$rdc2_cool1;
rdc2_cool2=$rdc2_cool2;rdc2_r=$rdc2_r;rdc2_d=$rdc2_d;
rdc3_choice=$rdc3_choice;rdc3_firstIt=$rdc3_firstIt;
rdc3_hot=$rdc3_hot;rdc3_cool1=$rdc3_cool1;
rdc3_cool2=$rdc3_cool2;rdc3_r=$rdc3_r;rdc3_d=$rdc3_d;
rdc4_choice=$rdc4_choice;rdc4_firstIt=$rdc4_firstIt;
rdc4_hot=$rdc4_hot;rdc4_cool1=$rdc4_cool1;
rdc4_cool2=$rdc4_cool2;rdc4_r=$rdc4_r;rdc4_d=$rdc4_d;
rdc5_choice=$rdc5_choice;rdc5_firstIt=$rdc5_firstIt;
rdc5_hot=$rdc5_hot;rdc5_cool1=$rdc5_cool1;
rdc5_cool2=$rdc5_cool2;rdc5_r=$rdc5_r;rdc5_d=$rdc5_d;
rfree_on=$rfree_on;rfree_oneset=$rfree_oneset;
rfree_method=$rfree_method;rfree_percent=$rfree_percent;
rfree_signal1=$rfree_signal1;rfree_signal2=$rfree_signal2;
rfree_putative1=$rfree_putative1;rfree_putative2=$rfree_putative2;
rfree_noise1=$rfree_noise1;rfree_noise2=$rfree_noise2;
)"""

###############################################################################
# Don't change anything below this line:

import glob, os, re, shutil, string, sys

#check temporary directory:
if not os.path.exists(tmpDirectory):
    print 'temporary directory', tmpDirectory, 'does not exist.'
    print 'program aborted.'
    sys.exit()

whereToSearch = os.path.join(ariaDirectory, 'protocols/*.*')
print whereToSearch
allFiles = glob.glob(whereToSearch)

runCns = re.compile('@RUN:run\.cns\(.*?\)', re.DOTALL)

print 'updating:'
for eachFile in allFiles:
    #get the content of the file:
    fileHandle = open(eachFile)
    bigString = string.join(fileHandle.readlines(), '')
    fileHandle.close()

    #backup of the old file:
#    print '  backup: copied', os.path.split(eachFile)[1], 'to', tmpDirectory
    shutil.copyfile(eachFile, os.path.join(tmpDirectory, os.path.split(eachFile)[1]))
    
    #replace method call and write the new file:
    fileHandle = open(eachFile, 'w')
    if runCns.search(bigString):
        print eachFile
        bigString = runCns.sub(runCnsCall, bigString)
    else:
        print '       ', eachFile, '<- no run.cns call'
    fileHandle.write(bigString)
    fileHandle.close()
