"""
ParsePath.py

some procedures for file and directory names

"""
__author__   = "$Author: linge $"
__revision__ = "$Revision $"
__date__     = "$Date $"

import os, string

def GetTail(path):
    """
    parse the tail (directory or file) out of an absolute path
    usage: dir = GetTail(fullpath)
    e.g. '/home/linge/il4/' will be ' il4'
    if path is empty, an empty string is returned
    if path is root ('/'), root is returned
    if path is None, None is returned
    """
    if not path: return None
    if string.strip(path) == '/':  
	return '/'              # for root
    if (path[-1] == '/'):
	path = path [:-1]       # get rid of trailing slashes
    pathlist = os.path.split(path)
    return pathlist[1]


def DelTrailSlash(path):
    """gets rid of trailing slahes, if there are any"""
    if ((path[-1] == '/') and (string.strip(path) != '/')):
        path = path [:-1]
    return path


def TooLong(path):
    if len(path) > 78:
        print 'WARNING: the following path is too long:'
        print path
    
