"""
CnsAnalysis.py
"""
__author__   = "$Author: anonymous $"
__revision__ = "$Revision $"
__date__     = "$Date $"

import os, time
from Aria.Main import ParsePath

def Analysis(runDir, ariaDir, protocolsDir, newItDir, tempTrashDir, currit, queueDic,\
             fileRoot, procheckRun="no", procheckDir=""):
    """
    a method to call all the CNS analysis scripts

    added some protocols from Alexandre Bonvin 25-6-2001
    """
    print 'starting analysis scripts for', newItDir
    queueList = queueDic.keys()

    #get the runPlusNumber as string (e.g. 'run12'):
    runPlusNumber = ParsePath.GetTail(runDir)
            
    #1. calculating average structure (wellordered.inp):
    print '  calculating average structure'

    jobString = """cd %s
    setenv ARIA %s
    setenv CURRIT %s
    setenv NEWIT %s
    setenv PREVIT %s
    setenv RUN %s
    setenv SPECTRUM %s
    setenv TEMPTRASH %s
    %s < %s > %s
            """ % (tempTrashDir,\
                   ariaDir,\
                   '8',\
                   newItDir,\
                   newItDir,\
                   runDir,\
                   '',\
                   tempTrashDir,\
                   queueDic[queueList[0]][0],\
                   runDir + '/protocols/wellordered.inp',\
                   newItDir + '/analysis/wellordered.out')
    jobFN = os.path.join(tempTrashDir, fileRoot + '_' + runPlusNumber + '_wellordered.job')
    jobStream = open(jobFN, 'w')
    jobStream.write(jobString)
    jobStream.close()
    #start the queue with the proper command and job file:
##    whatToDo = queueList[0] + ' ' + ParsePath.GetTail(jobFN) + ' &' #use the full jobFN instead 14-06-2001 Jens
    whatToDo = queueList[0] + ' ' + ParsePath.GetTail(jobFN) + ' &'
    print '    queue command:\n   ', whatToDo
    os.chdir(tempTrashDir)
    os.system(whatToDo)

    #waiting:
    print '  waiting for the average structure...'
    while 1:
        if os.path.exists(newItDir + '/analysis/' + fileRoot + '_ave.pdb'):
            break
        time.sleep(5)

    time.sleep(3) #wait for slow networks
    
    #2. all the other analysis scripts:
    print '  running analysis scripts:'
    toDoList = [['minimizing the average structure', 'minimize.inp'],\
                ['calculating the rmsd to the average structure', 'rmsave.inp'],\
                ['calculating ensemble rmsd as function of ensemble size', 'ensemble_rmsd.inp'],\
                ['calculating pairwise rmsd matrix', 'rmsd.inp'],\
                ['analyzing geometry', 'print_geom.inp'],\
                ['analyzing NOEs', 'print_noe.inp'],\
                ['analyzing dihedrals', 'print_dih.inp'],\
                ['analyzing couplings', 'print_coup.inp'],\
                ['calculating circular order parameters', 'cop.inp'],\
                ['calculating energies', 'energy.inp']]
    
## changed the floating assignment setup, can't use ana_seqp.inp any more:
##                ['analyzing the floating assignments', 'ana_swap.inp'],\

 
    for eachPro in toDoList:
        queueIndex = 0
        while 1:
            queueList = queueDic.keys()
            eachQueue = queueList[queueIndex]
            #1. if empty, take it directly:
            if queueDic[eachQueue][1] > len(queueDic[eachQueue][2]):
                break
            #2. if fileNames exist, check if the file already exists:
            else:
                breakOut = 0
                for eachF in queueDic[eachQueue][2]:
                    if os.path.exists(eachF):
                        queueDic[eachQueue][2].remove(eachF)
                        breakOut = 1
                if breakOut: break
            if queueIndex == (len(queueList) - 1):
                queueIndex = 0
            else:
                queueIndex = queueIndex + 1
            time.sleep(1)
        time.sleep(10) #just to make sure that all the files are there.

        print '   ', eachPro[0]
        inputFN = runDir + '/protocols/' + eachPro[1]
        outputFN = newItDir + '/analysis/' + eachPro[1][:-4] + '.out'
        jobFN = os.path.join(tempTrashDir, fileRoot  + '_' + runPlusNumber + '_' +\
                              eachPro[1][:-4] + '.job')
        jobString = """cd %s
setenv ARIA %s
setenv CURRIT %s
setenv NEWIT %s
setenv PREVIT %s
setenv RUN %s
setenv SPECTRUM %s
setenv TEMPTRASH %s
%s < %s > %s
""" % (tempTrashDir,\
       ariaDir,\
       '8',\
       newItDir,\
       newItDir,\
       runDir,\
       '',\
       tempTrashDir,\
       queueDic[eachQueue][0],\
       inputFN,\
       outputFN)
        jobStream = open(jobFN, 'w')
        jobStream.write(jobString)
        jobStream.close()
        #start the queue with the proper command and job file:
        whatToDo = eachQueue + ' ' + ParsePath.GetTail(jobFN) + ' &'
        print '      queue command:\n     ', whatToDo
        os.chdir(tempTrashDir)
        os.system(whatToDo)

        #move to next queue (after the last one, start from 0 again):
        #we submit a job every 10 seconds, thus on a slow machine, there
        #might be problems with too many jobs running!!!
        #(we should add filenames to queueDic instead...)
        
        if queueIndex == (len(queueList) - 1):
            queueIndex = 0
            time.sleep(10)
        else:
            queueIndex = queueIndex + 1

    #waiting:
    print '  waiting for the NOE analysis file...'
    noeFN = newItDir + '/analysis/noe.disp'
    while 1:
        if os.path.exists(noeFN):
            break
        time.sleep(5)

    time.sleep(20) #wait for slow networks

    anaNoeFiles = "/bin/cp " + runDir + "/protocols/*_noe_viol* " + newItDir + "/analysis/"
    os.system(anaNoeFiles)
    anaDir =  newItDir + "/analysis/"
    print '    checking all distance restraints violations in', anaDir
    print '        check ana_dist_viol_all.out for a listing' 
    os.chdir(anaDir)
    anaNoeViol = "./ana_noe_viol.csh print_dist_all.out >ana_dist_viol_all.out"
    os.system(anaNoeViol)
    print '    checking all NOE violations in', anaDir
    print '        check ana_noe_viol_all.out for a listing' 
    os.chdir(anaDir)
    anaNoeViol = "./ana_noe_viol.csh print_noe_all.out >ana_noe_viol_all.out"
    os.system(anaNoeViol)
    print '    checking unambiguous NOE violations in', anaDir
    print '        check ana_noe_viol_unambig.out for a listing' 
    os.chdir(anaDir)
    anaNoeViol = "./ana_noe_viol.csh print_noe_unambig.out >ana_noe_viol_unambig.out"
    os.system(anaNoeViol)
    print '    checking ambiguous NOE violations in', anaDir
    print '        check ana_noe_viol_ambig.out for a listing' 
    os.chdir(anaDir)
    anaNoeViol = "./ana_noe_viol.csh print_noe_ambig.out >ana_noe_viol_ambig.out"
    os.system(anaNoeViol)
    print '    checking hbonds violations in', anaDir
    print '        check ana_hbond_viol.out for a listing' 
    os.chdir(anaDir)
    anaNoeViol = "./ana_noe_viol.csh print_dist_hbond.out >ana_hbond_viol.out"
    os.system(anaNoeViol)

    #waiting:
    print '  waiting for the dihedral restraints analysis file...'
    while 1:
        if os.path.exists(newItDir + '/analysis/dihedrals.disp'):
            break
        time.sleep(5)

    time.sleep(20) #wait for slow networks

    anaDihedFiles = "/bin/cp " + runDir + "/protocols/*_dihed_viol* " + newItDir + "/analysis/"
    os.system(anaDihedFiles)
    print '    checking dihedral angle restraints violations in', anaDir
    print '        check ana_dihed_viol.out for a listing' 
    os.chdir(anaDir)
    anaDihedViol = "./ana_dihed_viol.csh print_dih.out >ana_dihed_viol.out"
    os.system(anaDihedViol)

    if procheckRun == "yes":
        pcheckDir = newItDir + '/analysis/pcheck'
        print '    settinp up procheck analysis in ', pcheckDir
        pdir = 1
        if os.path.exists(pcheckDir): pdir = 0
        if pdir: os.mkdir(pcheckDir)
        os.chdir(pcheckDir)
        pcheckFiles = "ls -al ../*[0-9].pdb |/usr/bin/gawk '{print $9}' > " + fileRoot + "_" + runPlusNumber + ".lis"
        os.system(pcheckFiles)
        pcheckRun = procheckDir + ' ' + fileRoot + '_' + runPlusNumber + '.lis'
	print pcheckRun
        os.system(pcheckRun)
     
 

