"""
a module for sorting ARIA .pdb files regarding energy
"""
__author__   = "$Author: anonymous $"
__revision__ = "$Revision: 2.6 $"
__date__     = "$Date: 2001/09/08 19:12:03 $"

import glob,  string, sys
from Aria.Main import ParsePath
from Aria.ThirdParty import TextFile

###############################################################################
def WriteFileList(directory, outDir='', howMany=100000, message=1, fileNam=1,\
                  fileCns=1, filesort='totener'):
    """
    reads all PDB files in the given directory
    INPUT:   directory=the directory to look for the .pdb files
             outDir=the directory to write the file.list
             howMany=howMany structures to write in file.list
             message=toggle for printing a message (1=on, 0=off)
             fileNam=toggle for printing file.nam (1=on, 0=off)
    writes the file file.list in given directory
    also writes a file called file.nam for MolMol which contains
    a list of all the pdb files

    totener   file sorting regarding total energy (total energy from CNS)
    restener  explicitly adds the energy terms (within Python)
    """
    if outDir == '':
        outDir = directory
    if message == 1:
        print '    creating file.list in', outDir
    if message == 1 and fileNam == 1:
        print '    creating file.nam in', outDir
    if message == 1 and fileCns == 1:
        print '    creating file.cns in', outDir

    #get a list of all the pdb files:
    pdbFiles = glob.glob(directory + '/*.pdb')
    if len(pdbFiles) == 0:
        if fileNam == 1:
            print '    no pdb files found => file.list and file.nam not created'
        else:
            print '    no pdb files found => file.list not created'
        return

    #parse the energies from the pdb files:
    energiesAndFiles = {}  #key: energy, value: list of filename(s)
    for x in pdbFiles:  #loop over all the pdb files in given directory
	for line in TextFile.TextFile(x):
	    if line[0:16] == 'REMARK energies:':
		lineList = string.split(line)
##                 #get the overall energy:
##                 overallEnergy = lineList[2]
## 		   #get rid of the comma:
##                 overallEnergy = overallEnergy[:-1]
## 	           overallEnergy = string.atof(overallEnergy)

 	        if filesort == 'restener':
                    #get the NOE restraint energy:
                    noeEnergy = lineList[9]
                    #get the cdih restraint energy:
                    cdihEnergy = lineList[10]
                    #get the coup restraint energy:
                    coupEnergy = lineList[11]
                    #get the sani restraint energy:
                    saniEnergy = lineList[12]
                    #get the vean restraint energy:
                    veanEnergy = lineList[13]
		    #get rid of the comma:
                    noeEnergy = noeEnergy[:-1]
                    cdihEnergy = cdihEnergy[:-1]
                    coupEnergy = coupEnergy[:-1]
                    saniEnergy = saniEnergy[:-1]
 		    overallEnergy = string.atof(noeEnergy)
 		    overallEnergy = overallEnergy + string.atof(cdihEnergy)
 		    overallenergy = overallEnergy + string.atof(coupEnergy)
 		    overallEnergy = overallEnergy + string.atof(saniEnergy)
 		    overallEnergy = overallEnergy + string.atof(veanEnergy)
                else :
                    #get the overall energy:
                    overallEnergy = lineList[2]
 		    #get rid of the comma:
                    overallEnergy = overallEnergy[:-1]
 		    overallEnergy = string.atof(overallEnergy)

                #define a dictionary, use a list for the files:
                if energiesAndFiles.has_key(overallEnergy):
                    energiesAndFiles[overallEnergy].append(ParsePath.GetTail(x))
                else:
                    energiesAndFiles[overallEnergy] = [ParsePath.GetTail(x), ]
		break

    #create a sorted list which contains the energies:
    energies = energiesAndFiles.keys()
    energies.sort()      #numerically sorted because of string.atof() above

    #open file.list , file.nam and file.cns filehandles:
    try:
        fileListHandle = open (outDir + '/file.list', 'w')
    except IOError:
        print "couldn't create file.list in directory", outDir
#        Messages.StopAria()
    if fileNam == 1:
        try:
            namHandle = open (outDir + '/file.nam', 'w')
        except IOError:
            print "couldn't create file.nam in directory", outDir
#            Messages.StopAria()
    else:
        namHandle = None
    cnsHandle = None  # by default
    if fileCns == 1:
        try:
            cnsHandle = open (outDir + '/file.cns', 'w')
        except IOError:
            print "couldn't create file.cns in directory", outDir
#            Messages.StopAria()
    else:
        cnsHandle = None
        
    #write the header of the file.cns file:
    startCnsFile="""module(filenames;)
set message off echo off end
evaluate ($count = 1)
while ($count le 100) loop main
   evaluate (&filenames.bestfile_$count = "")
   evaluate ($count = $count + 1)
end loop main
set message on echo on end
"""
    cnsHandle.write(startCnsFile)

    #output - files sorted regarding energy:
    zzz = 0
    for value in energies[:min(howMany, len(energies))]:
        xxx = 0
        while xxx < len(energiesAndFiles[value]):
            fileListHandle.write('"PREVIT:' + str(energiesAndFiles[value][xxx]) +\
                                 '"  { ' + str(value) + ' }\n')
            if fileNam == 1:
                namHandle.write(str(energiesAndFiles[value][xxx]) + '\n')
            if fileCns == 1:
                cnsHandle.write('evaluate (&filenames.bestfile_' +\
                                str(zzz+1) + '="PREVIT:' +\
                                str(energiesAndFiles[value][xxx]) +\
                                '")\n')
            xxx = xxx + 1
            zzz = zzz + 1
    cnsHandle.write('\n\n') #important for CNS!!!
    for yyy in range(100-zzz):
## commented out the next two lines because I added while ($count le 100) loop main in the header anyway (JL, 13-12-2001):
##         cnsHandle.write('evaluate (&filenames.bestfile_' + str(yyy+zzz+1) +\
##                         '="")\n')              
        pass
    
    #close the file handles:
    fileListHandle.close()
    if fileNam == 1:
        namHandle.write('\n\n')
        namHandle.close()
    if fileCns == 1:
        cnsHandle.write('\n\n')
        cnsHandle.close()
