"""
InputFileParser.py

procedures for parsing new.html and run.cns
"""
__author__   = "$Author: anonymous $"
__revision__ = "$Revision $"
__date__     = "$Date $"

import re, string
from Aria.Main import ParsePath
from Aria.ThirdParty import TextFile

def ParseNewHtml(directory = '.'):
    """
    parse new.html, reads all lines between the '<!-- ARIA -->\n' and
    defines the specified variables.
    INPUT:  directory where to search for new.html
    OUTPUT: a dictionary with the variable names as keywords
    """
    print 'reading parameters from the file', directory + '/new.html'
    newhtml = TextFile.TextFile(directory + '/new.html', 'r')
    print '  setting some variables:'
    variablesdic = {}
    readornot=0  #if 1: define variables below, otherwise not
    brTag = re.compile('<BR>')
    for line in newhtml.readlines():
	if line[-14:] == '<!-- ARIA -->\n':
	    readornot = readornot + 1
	    continue
	if readornot == 1:
	    line = brTag.sub('', line)    #get rid of the <BR> tag
	    linelist = string.split(line, '=')
            variablesdic[linelist[0]] = ParsePath.DelTrailSlash(string.strip(linelist[1]))
    for eachword in variablesdic.keys():
	print '  ' + eachword + ' set to: ' + variablesdic[eachword]
    return variablesdic


def ParseRunCns():
    """
    parses out all variables of run.cns (starting with {===>}) and returns an
    associative array (variablename:value)
    in addition, defines some variables and adds them to dictionary
    Version: 17.7.98 Jens Linge, EMBL
    """
    runcns = TextFile.TextFile('run.cns', 'r')
    variablevalue = {}
    arrow = re.compile('{===>}')
    doublequotation = re.compile('"')
    endarrow = re.compile('{<===}')
    equalsign = re.compile('=')
    pro = re.compile('_pro')
    semicolon = re.compile(';')
    #the normal assignment statements are finished within only 1 line
    #the assignment statement for the ss bridges contains several lines
    assigns = 0    #0 for the normal case, 1 for several assignments
    dodictionary = 0 #0 does nothing, 1 for writing to dictionary
    for line in runcns:
	if equalsign.search(line):  #get arrows, assignments, comments, ...
	    if arrow.match(line):
		if semicolon.search(line):
		    dodictionary = 1   #normal assignment found
		else:  #no assignment in this line, therefore:
		    assigns = 1   #this means: 'several assignments'
	    elif endarrow.match(line):
		assigns = 0   #this means: end of 'several assignments'
	    else:
		if semicolon.search(line):
		    dodictionary = 1
	if dodictionary == 1:
	    #write to dictionary:
	    line = line[6:]                      #get rid of {===>}
	    line = semicolon.sub('', line)       #get rid of ;
	    line = doublequotation.sub('', line) #get rid of "
	    kkk, vvv = equalsign.split(line)     #split uses the =
	    kkk = pro.sub(' ', kkk)              #get rid of '_pro'
	    kkk = string.strip(kkk)
	    vvv = vvv[:-1]                       #get rid of linebreaks
	    vvv = semicolon.sub('', vvv)         #get rid of ;
	    vvv = string.strip(vvv)              #get rid of whitespace
	    variablevalue[kkk] = vvv #creates dictionary
      	dodictionary = 0    #set to default again

	
    #set some directory names:
    variablevalue['begindir'] = variablevalue['run_dir'] + '/begin'
    variablevalue['datadir'] = variablevalue['run_dir'] + '/data'
    variablevalue['protocolsdir'] = variablevalue['run_dir'] + '/protocols'
    variablevalue['sequencedir'] = variablevalue['datadir'] + '/sequence'
    variablevalue['structuresdir'] = variablevalue['run_dir'] + '/structures'
    variablevalue['toppardir'] = variablevalue['run_dir'] + '/toppar'

    #for the full path of the template and psf files:
## in aria1.1 don't need template filename in run.cns any more:
    variablevalue['templatefile'] = variablevalue['begindir'] + '/' + \
				    variablevalue['fileroot'] + '_template.pdb'
    
    variablevalue['psffile'] = variablevalue['begindir'] + '/' + \
			       variablevalue['structure']

    ## new for aria1.1, ini_count is always 1:
    variablevalue['ini_count_0'] = '1'
    variablevalue['ini_count_1'] = '1'
    variablevalue['ini_count_2'] = '1'
    variablevalue['ini_count_3'] = '1'
    variablevalue['ini_count_4'] = '1'
    variablevalue['ini_count_5'] = '1'
    variablevalue['ini_count_6'] = '1'
    variablevalue['ini_count_7'] = '1'
    variablevalue['ini_count_8'] = '1'

    ## set nspectra correctly for aria1.1:
    variablevalue['nspectra'] = '0'
    if string.strip(variablevalue['aspectrum_1']) != '':
        variablevalue['nspectra'] = '1'
    if string.strip(variablevalue['aspectrum_2']) != '':
        variablevalue['nspectra'] = '2'
    if string.strip(variablevalue['aspectrum_3']) != '':
        variablevalue['nspectra'] = '3'
    if string.strip(variablevalue['aspectrum_4']) != '':
        variablevalue['nspectra'] = '4'
    if string.strip(variablevalue['aspectrum_5']) != '':
        variablevalue['nspectra'] = '5'

    #regular end:
    runcns.close()
    return variablevalue

