"""
testing code for the conversion of aria files to STAR format

If you want to use the Python modules Csi2Aria and Talos2Aria,
please have a look at the example code below.

If you want to use it as it is, please change the input filenames
and the output directories and start this file with the Python interpreter.


Jens Linge - linge@pasteur.fr
Jurgen F. Doreleijers - jurgen@yola.bmrb.wisc.edu
23-08-2001
"""

import os, string, sys

# INPUT:
runDir          = '/home/linge/werner1.0/run1/'
sequenceFN      = os.path.join(runDir, 'data/sequence/werner.seq' )
projectName     = 'werner1.0'  #take value from run.cns file
spectrumList    = ['15N',]  #which spectra - look up names in run.cns file

# OUTPUT:
tmpDir          = '/tmp'


###############################################################################
# don't change anything below this line (except which test you want to run:-)

# some more filenames - no need to change them:
noeListFN       = os.path.join(runDir, 'structures/it8/merged.list')
bmrbPpmFN_base  = os.path.join(tmpDir, 'bmrb_test_ppm' )
bmrbNoeFN       = os.path.join(tmpDir, 'bmrb_test_noe.str' )

###############################################################################
from Aria.DataIO import NoeList, PpmList, SequenceList, BMRB
from Aria.DataIO.BMRB import BmrbCmdParser, DistanceRestraintList

#1. reading the sequence:
import SequenceList

if ( 1 ):
    print "Testing PpmList stuff"
    SL = SequenceList.SequenceList()
    SL.ReadSeq(os.path.join(runDir,sequenceFN))
    # print SL.aalist

    for eachSpectrum in spectrumList:
        bmrbPpmFN   = bmrbPpmFN_base + '_' + eachSpectrum + '.str'
        PL          = PpmList.PpmList()
        PL.ReadChem(os.path.join(runDir, 'data', eachSpectrum,
                                                 eachSpectrum + '.ppm')) 
        PL.AddSequence(SL.aalist)
        PL.WriteBioMagResBank( bmrbPpmFN )

#2. testing the BMRB conversion of the NOEs:
if ( 1 ):
    print "Testing NOEList stuff"
    NL = NoeList.NoeList()
    NL.ReadList( noeListFN )
    #NL.ReadTbl( noeTblFN )
    print NL

    DRL = DistanceRestraintList()
    DRL.AbsorbNoeList( NL )

    SL = SequenceList.SequenceList()
    SL.ReadSeq(os.path.join(runDir,sequenceFN))
##    print SL.aalist
    DRL.StereoGroupListCreate( SL.aalist )
    
    DRL.WriteStar( bmrbNoeFN )
    
    # Reformat the STAR file if program is available/executable
    #_formatSTAR( BCP.outputFileName )
    #JFD: leave out for now


