      program dbdb
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          08-SEP-1988
c
c
      implicit none
c  global variables
      include 'coord.inc'
      logical READ_COORDS, NEXT_FILE_OPEN
      real DIHEDRAL
      integer ATOM_NUMBER, ATOM_PLACE
c  local variables
      logical error
      character*80 pdbfile, outfile
      integer u_out, u_pdb, u_db
      integer i, j, k, a1, a2, a3, a4
      real noe(11), dihed(3), jcoup(3), class(11), err(11)
      character*4 name
      real e_vdw
c
c  begin
c
      u_out = 5
      write(u_out,'(a)')
     2 'XBASE  (version 1.0, 21-MAR-1989)             M. Nilges'
      write(u_out,'(a)')
     2 'Generation of STEREOSEARCH database from crystal structures'
      write(u_out,'(a)')
     2 'No warranty expressed or implied'
      write(u_out,'(a)') ' '
c
c  output file
      if (.not. NEXT_FILE_OPEN('Database file:      ', outfile, 
     2            u_db, 'WRITE', 'UNFORMATTED')) goto 9999
c
c
      e_vdw = 0.0
c
c  loop over coordinate files
c
      do while (NEXT_FILE_OPEN('PDB file (<CR> to quit):     ', pdbfile,
     2            u_pdb, 'READ', 'FORMATTED'))
c
      if (.not. READ_COORDS(u_pdb)) goto 9999
c
      do i=FIRSTRES, LASTRES
c
        name = RESNAME(ATOM_NUMBER(i,'CA  '))
        if ( (name .eq. 'GLY ') .or. (name .eq. 'THR ')
     2    .or. (name .eq. 'ALA ') .or. (name .eq. 'VAL ')
     3    .or. (name .eq. 'ILE ') ) goto 8888
c        
        a1 = ATOM_NUMBER(i, 'HA  ')
        a2 = ATOM_NUMBER(i, 'HB1 ')
        if ((a1 .gt. 0) .and. (a2 .gt. 0)) then
          call noedist_5(a1,a2, noe(3), class(3), err(3))
        else
          noe(3) = 999.99
          class(3) = 999.99
        end if
c
        a1 = ATOM_NUMBER(i, 'HA  ')
        a2 = ATOM_NUMBER(i, 'HB2 ')
        if ((a1 .gt. 0) .and. (a2 .gt. 0)) then
          call noedist_5(a1,a2, noe(4), class(4), err(4))
        else
          noe(4) = 999.99
          class(4) = 999.99
        end if
c
        a1 = ATOM_NUMBER(i, 'HN  ')
        a2 = ATOM_NUMBER(i, 'HB1 ')
        if ((a1 .gt. 0) .and. (a2 .gt. 0)) then
          call noedist_5(a1,a2, noe(5), class(5), err(5))
        else
          noe(5) = 999.99
          class(5) = 999.99
        end if
c
        a1 = ATOM_NUMBER(i, 'HN  ')
        a2 = ATOM_NUMBER(i, 'HB2 ')
        if ((a1 .gt. 0) .and. (a2 .gt. 0)) then
          call noedist_5(a1,a2, noe(6), class(6), err(6))
        else
          noe(6) = 999.99
          class(6) = 999.99
        end if
c
        a1 = ATOM_NUMBER(i, 'HB1  ')
        a2 = ATOM_NUMBER(i+1, 'HN  ')
        if ((a1 .gt. 0) .and. (a2 .gt. 0)) then
          call noedist_5(a1,a2, noe(7), class(7), err(7))
        else
          noe(7) = 999.99
          class(7) = 999.99
        end if
c
        a1 = ATOM_NUMBER(i, 'HB2 ')
        a2 = ATOM_NUMBER(i+1, 'HN  ')
        if ((a1 .gt. 0) .and. (a2 .gt. 0)) then
          call noedist_5(a1,a2, noe(8), class(8), err(8))
        else
          noe(8) = 999.99
          class(8) = 999.99
        end if
c
        a1 = ATOM_NUMBER(i, 'HA  ')
        a2 = ATOM_NUMBER(i+1, 'HN  ')
        if ((a1 .gt. 0) .and. (a2 .gt. 0)) then
          call noedist_5(a1,a2, noe(10), class(10), err(10))
        else
          noe(10) = 999.99
          class(10) = 999.99
        end if
c
        a1 = ATOM_NUMBER(i, 'HN  ')
        a2 = ATOM_NUMBER(i+1, 'HN  ')
        if ((a1 .gt. 0) .and. (a2 .gt. 0)) then
          call noedist_5(a1,a2, noe(11), class(11), err(11))
        else
          noe(11) = 999.99
          class(11) = 999.99
        end if
c
        a1 = ATOM_NUMBER(i, 'HA  ')
        a2 = ATOM_NUMBER(i, 'HN  ')
        if ((a1 .gt. 0) .and. (a2 .gt. 0)) then
          call noedist_5(a1,a2, noe(9), class(9), err(9))
        else
          noe(9) = 999.99
          class(9) = 999.99
        end if
c
        a1 = ATOM_NUMBER(i-1, 'HA  ')
        a2 = ATOM_NUMBER(i, 'HN  ')
        if ((a1 .gt. 0) .and. (a2 .gt. 0)) then
          call noedist_5(a1,a2, noe(1), class(1), err(1))
        else
          noe(1) = 999.99
          class(1) = 999.99
        end if
c
        a1 = ATOM_NUMBER(i-1, 'HN  ')
        a2 = ATOM_NUMBER(i, 'HN  ')
        if ((a1 .gt. 0) .and. (a2 .gt. 0)) then
          call noedist_5(a1,a2, noe(2), class(2), err(2))
        else
          noe(2) = 999.99
          class(2) = 999.99
        end if
c
        a1 = ATOM_PLACE(i-1, 1)
        a2 = ATOM_PLACE(i, 2)
        a3 = ATOM_PLACE(i, 3)
        a4 = ATOM_PLACE(i, 1)
        if ((a1.gt.0).and.(a2.gt.0).and.(a3.gt.0).and.(a4.gt.0)) then
          dihed(1)=DIHEDRAL(a1, a2, a3, a4)
        else 
          dihed(1) = 999.99
        end if
c
        a1 = ATOM_PLACE(i, 2)
        a2 = ATOM_PLACE(i, 3)
        a3 = ATOM_PLACE(i, 1)
        a4 = ATOM_PLACE(i+1, 2)
        if ((a1.gt.0).and.(a2.gt.0).and.(a3.gt.0).and.(a4.gt.0)) then
          dihed(2)=DIHEDRAL(a1, a2, a3, a4)
        else 
          dihed(2) = 999.99
        end if
c
        a1 = ATOM_PLACE(i, 2)
        a2 = ATOM_PLACE(i, 3)
        a3 = ATOM_PLACE(i, 4)
        a4 = ATOM_PLACE(i, 5)
        if ((a1.gt.0).and.(a2.gt.0).and.(a3.gt.0).and.(a4.gt.0)) then
          dihed(3)=DIHEDRAL(a1, a2, a3, a4)
        else 
          dihed(3) = 999.99
        end if
c
c
c
        call KARPLUS(dihed, jcoup)
c
c
c
        call write_db(u_db, e_vdw, noe, jcoup, dihed, .FALSE.)
c
c
 8888 end do
c
      call vclose(u_pdb, 'KEEP', error)
c
      end do
c  end loop over coordinate files
c
c
 9999 stop
      end
      logical function READ_COORDS(unit)
c  Reads a pdb coordinate file, removes all non 'ATOM' records,
c  stores a few title lines residues if there are 'insertions' or 
c  'deletions' in the structure. It therefore has to assume that 
c  the residues are in correct order.
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          
c   26-AUG-1988  written
c      OKT-1988  renumbering
c      NOV-1988  titles, occupancy and bfactor included
c
c
      implicit none
c  global variables
      include 'COORD.inc'
c  input / output
      integer unit
c  local variables
      integer i, nline, len, number_of_res
      character*80 line
      character*4 atom, restyp, resnum, oldresnum
      character*1 segment
      real xx, yy, zz, occ, bfac
      logical eof
c
c  begin
c
      READ_COORDS = .true.
c
c  initialize coordinate arrays
      do i=1, MAXAT
        ATID(i) = 'UNDE'
        RESID(i) = -1
        RESNAME(i) = 'UNDE'
        SEGID(i) = 'X'
        XYZ(1,i) = 9999.0
        XYZ(2,i) = 9999.0
        XYZ(3,i) = 9999.0
        OCCUPANCY(i) = 1.0
        BFACTOR(i) = 0.0
      end do        
c
      NTITLE = 0
      NATOM = 0
      FIRSTRES = 999
      LASTRES = 0
      oldresnum = '    '       
      number_of_res = 0
      nline = 0
      eof = .false.
      do while ((NATOM .le. MAXAT) .and. (.not. eof))
        read(unit, '(a)', end=900, err=800) line
        nline = nline + 1
        call UPPERCASE(line)
        if (line(1:4) .eq. 'ATOM') then
          read(line,'(12x,a4,1x,a4,a1,1x,a4,3x,3f8.3,2f6.2)',
     2         end=800,err=800)
     2      atom,restyp,segment,resnum,xx,yy,zz,occ,bfac
          len = 4
          call TRIML(atom,len)
          len = 4
          call TRIML(restyp,len)
          NATOM = NATOM + 1
          if (resnum .ne. oldresnum) then
            number_of_res = number_of_res + 1
            oldresnum = resnum
          end if
          if (NATOM .gt. MAXAT) then
            write(6,*) 'Maximum number of atoms exceeded'
            eof = .true.
            READ_COORDS = .false.
          else
            ATID(NATOM) = atom
            RESID(NATOM) = number_of_res
            RESNAME(NATOM) = restyp
            SEGID(NATOM) = segment
            XYZ(1,NATOM) = xx
            XYZ(2,NATOM) = yy
            XYZ(3,NATOM) = zz
            OCCUPANCY(NATOM) = occ
            BFACTOR(NATOM) = bfac
            if (number_of_res .lt. FIRSTRES) FIRSTRES = number_of_res
            if (number_of_res .gt. LASTRES)  LASTRES = number_of_res
          end if
        elseif (line(1:3) .eq. 'END') then
          eof = .true.
        elseif (line(1:4) .eq. 'REMA') then
          if (NTITLE .le. MAXTITLE) then
            NTITLE = NTITLE + 1
            TITLES(NTITLE) = line
          end if
        end if
        goto 1000
  800   write(6,*) 'Error reading coordinate file at line', nline
        eof = .true.
        READ_COORDS = .false.
        goto 1000
  900   eof = .true.
 1000 end do
c
      end




      logical function WRITE_COORDS(unit)
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          26-AUG-1988
c
c
      implicit none
c  global variables
      include 'coord.inc'
c  input / output
      integer unit
c  local variables
      integer iatom, i
c
c  begin
c
      WRITE_COORDS = .true.
      do i=1, NTITLE
        write(unit, '(a)') TITLES(i)
      end do
      iatom = 1
      do while (iatom .le. NATOM)
        write(unit, '(a4, i7, x,a4,1x,a4,a,i4,4x,3f8.3,2f6.2)')
     2      'ATOM', iatom, ATID(iatom), RESNAME(iatom), SEGID(iatom),
     3        RESID(iatom), XYZ(1, iatom), XYZ(2, iatom), XYZ(3, iatom),
     4        OCCUPANCY(iatom), BFACTOR(iatom)
        iatom = iatom + 1
 1000 end do
        write(unit, '(a)') 'END'
c
      end
      subroutine subtract(a,b,ba)
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          08-SEP-1988
c
c
      implicit none
c  global variables
c  input / output
      real a(3), b(3), ba(3)
c  local variables
      integer i
c
c  begin
c
      do i = 1,3
        ba(i) = a(i) - b(i) 
      end do
      return
      end
      


      subroutine crossprod3(a,b,axb) 
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          08-SEP-1988
c
c
      implicit none
c  global variables
c  input / output
      real a(3), b(3), axb(3)
c  local variables
c
c  begin
c
      axb(1) = a(2)*b(3) - a(3)*b(2) 
      axb(2) = a(3)*b(1) - a(1)*b(3) 
      axb(3) = a(1)*b(2) - a(2)*b(1) 
      return
      end 
      
      real function dot(a,b)
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          08-SEP-1988
c
c
      implicit none
c  global variables
c  input / output
      real a(3), b(3)
c  local variables
      integer i
      real sum
c
c  begin
c
      sum = 0 
      do i = 1,3
        sum = sum + a(i)*b(i) 
      end do
      dot = sum 
      end 
      
      real function norm(a)
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          08-SEP-1988
c
c
      implicit none
c  global variables
c  input / output
      real a(3)
c  local variables
      integer i
      real sum
c
c  begin
c
      sum = 0 
      do i = 1,3
        sum = sum + a(i)*a(i) 
      end do
      norm = sqrt(sum) 
      end 
      
      
      real function dihedral(ia,ib,ic,id)
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          08-SEP-1988
c
c
      implicit none
c  global variables
      include 'math.inc'
      include 'coord.inc'
      real NORM, DOT
c  input / output
      integer ia, ib, ic, id
c  local variables
      real a(3), b(3), c(3), d(3)
      real ba(3),cb(3),bc(3),cd(3),u(3),v(3)
      real noru, norv, xx
      real dummy
      integer i
c
c  begin
c
c  check if atom numbers are defined
      if ((ia.le.0).or.(ib.le.0).or.(ic.le.0).or.(id.le.0)) then
        dummy = 999.99
      else
        do i=1,3
          a(i) = XYZ(i, ia)
          b(i) = XYZ(i, ib)
          c(i) = XYZ(i, ic)
          d(i) = XYZ(i, id)
        end do
c
c  check if coordinates are defined
        if ((a(1) .ge. 999) .or. (b(1) .ge. 999)
     2     .or. (c(1) .ge. 999) .or. (d(1) .ge. 999)) then
          dummy = 999.99
        else
          call SUBTRACT(a,b,ba) 
          call SUBTRACT(b,c,cb) 
          call SUBTRACT(c,b,bc) 
          call SUBTRACT(d,c,cd) 
          call CROSSPROD3(ba,bc,u) 
          call CROSSPROD3(cb,cd,v) 
          norv = NORM(v) 
          noru = NORM(u) 
          if ((norv .eq. 0) .or. (noru .eq. 0)) then
            dummy = 999.999
          else
            xx = dot(u,v)/(noru*norv) 
            if (xx .gt. 1.0) then 
              xx = 1.0
            elseif (xx .lt. -1.0) then 
              xx = -1.0
            end if
            xx = sqrt(1.0-xx*xx)/xx 
            dummy = 180.0/pi * atan(xx) 
            if (dummy .lt. 0.0) dummy = dummy + 180.0
            if (dot(u,cd) .gt. 0.0) dummy = -dummy 
          end if
        end if
      end if
c
c  map to -180.0 ... +180.0
      if (dummy .lt. 999.0) then
        if (dummy .lt. -180.0) dummy = dummy + 360.0
        if (dummy .gt. +180.0) dummy = dummy - 360.0
      end if
c
      dihedral = dummy 
      end 



      real function dist(x, y)
c  simply calculates the distane between x and y
c
c  Author: Michael Nilges, LCP, NIDDK, NIH              08-SEP-1988
c
      implicit none
c  input/output
      real    x, y
c  local variables
      real xx, yy, zz                ! square of coord differences
c
c  begin
c
      xx = (x(1) - y(1))**2
      yy = (x(2) - y(2))**2
      zz = (x(3) - y(3))**2
      dist = sqrt(xx+yy+zz)
c
      end



      subroutine noedist(ix, iy, dist, class)
c  simply calculates the distane between x and y
c
c  Author: Michael Nilges, LCP, NIDDK, NIH              08-SEP-1988
c
      implicit none
c  global variables
      include 'coord.inc'
c  input/output
      integer    ix, iy
      real dist, class
c  local variables
      real x(3), y(3)
      real xx, yy, zz                ! square of coord differences
      integer i
c
c  begin
c
      do i=1,3
        x(i) = XYZ(i, ix)
        y(i) = XYZ(i, iy)
      end do
      xx = (x(1) - y(1))**2
      yy = (x(2) - y(2))**2
      zz = (x(3) - y(3))**2
      dist = sqrt(xx+yy+zz)
      if     (dist .le. 2.7) then
        class = 2.7
      elseif (dist .le. 3.3) then
        class = 3.3
      elseif (dist .le. 4.0) then
        class = 4.0
      else
        class = 4.5
      end if
c
      return
      end




      subroutine karplus(gdiheds, jcoup)
c  calculates the coupling constant from the dihedrals angle
c
c  Author: Michael Nilges, LCP, NIDDK, NIH              23-aug-1988
c
      implicit none
c  global variables
      include 'math.inc'
c  input/ output
      real gdiheds(3), jcoup(3)
c  local variables
      integer i
      real diheds(3)
c
c  begin
c
      do i=1,3
        diheds(i) = gdiheds(i)
      end do
c  3JHNa
      if (diheds(1) .lt. 999) then
        diheds(1) = (diheds(1)-60) * RADDEG
        jcoup(1) = 6.4*cos(diheds(1))**2
     2          - 1.4*cos(diheds(1)) + 1.9
      else
        jcoup(1) = 999.99
      end if
c  3Jab2 - diheds(2) is psi on input
      if (diheds(3) .lt. 999) then
        diheds(2) = (diheds(3)-120) * RADDEG
        jcoup(2) = 9.5*cos(diheds(2))**2
     2          - 1.6*cos(diheds(2)) + 1.8
c  3Jab3
        diheds(3) = (diheds(3)) * RADDEG
        jcoup(3) = 9.5*cos(diheds(3))**2
     2          - 1.6*cos(diheds(3))       + 1.8
      else
        jcoup(2) = 999.99
        jcoup(3) = 999.99
      end if
c
c  end
      return
      end
      subroutine noedist_5(ix, iy, dist, class, err)
c  simply calculates the distane between x and y
c
c  Author: Michael Nilges, LCP, NIDDK, NIH              08-SEP-1988
c
      implicit none
c  global variables
      include 'coord.inc'
c  input/output
      integer    ix, iy
      real dist, class, err
c  local variables
      real x(3), y(3)
      real xx, yy, zz                ! square of coord differences
      integer i
c
c  begin
c
      do i=1,3
        x(i) = XYZ(i, ix)
        y(i) = XYZ(i, iy)
      end do
      do i=1,3
        if ((x(i) .gt. 999.0) .or. (y(i) .gt. 999.0)) then
          dist = 999.99
          class = 999.99
          err = 999.99
          return       !!! <===== return if coord undefined
        end if
      end do

      xx = (x(1) - y(1))**2
      yy = (x(2) - y(2))**2
      zz = (x(3) - y(3))**2
      dist = sqrt(xx+yy+zz)
c
c  The following distance classes and criteria have been selected 
c    according to the following criteria:
c    Classes are seprated by approximately a factor of 3 in NOE intensity.
c    In class 1 there is one error estimate taking into account spin
c    diffusion effects (the signal is smaller than expected, therefore 
c    the distance in the crystal structure has to be smaller than 2.1 to
c    be classified as very strong) and one emprical to avoid getting 
c    inconsistencies due to deviations from ideality.
c    In class 2 the spin diffusion effect (20%) is smaller, no problem
c    with inconsistencies. 
c    Class 3 and 4: the errors here also try to take spin diffusion
c    into account.
c
      if     (dist .le. 2.1) then
        class = 2.3
        err = 0.2     
      elseif (dist .le. 2.6) then
        class = 2.7
        err = 0.0
      elseif (dist .le. 3.3) then
        class = 3.3
        err = 0.2
      elseif (dist .le. 4.0) then
        class = 4.0
        err = 0.3
      else
        class = 4.9
      end if
c
      return
      end
      subroutine write_db(db_unit,e_vdw, noes, jcoup, jdih, form)
c  this subroutine writes te results of the gridsearch to a file,
c  it creates the database.
c
c  Author: Michael Nilges, LCP, NIDDK, NIH          24-AUG-1988
c
c  global variables
      include 'const.inc'
c  input / output
      integer db_unit        ! data base file unit
      real e_vdw             ! vdw pseudo energy
      real noes(11)          ! sequential and intraresidue noes
      real jcoup(3)          ! coupling constants for phi and chi1
      real jdih(3)           ! dihedral angles
      logical form           ! output file format
c  local variables
      integer i
      real djdih(3)
c
c  begin
c
      do i=1,3
        if (jdih(i) .lt. 0.0) then
          djdih(i) = jdih(i) + 360.0
        else
          djdih(i) = jdih(i)
        end if
      end do
      if (form) then
          write(db_unit,'(18f7.2)') e_vdw, (djdih(i),i=1,3), 
     2                          (jcoup(i),i=1,3), (noes(i),i=1,11)
      else
          write(db_unit) e_vdw, (djdih(i),i=1,3), 
     2                          (jcoup(i),i=1,3), (noes(i),i=1,11)
      end if
      return
      end

