/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Locale;
import java.util.TreeSet;

public class AlienTrimmer {
    static final String VERSION = "0.3.2";
    static final byte B_1 = -1;
    static final byte B0 = 0;
    static final byte B1 = 1;
    static final byte B2 = 2;
    static final byte B3 = 3;
    static final byte B4 = 4;
    static final byte B5 = 5;
    static final byte B6 = 6;
    static final byte B7 = 7;
    static final byte B8 = 8;
    static final byte B9 = 9;
    static final byte B10 = 10;
    static final byte B15 = 15;
    static final char QINF = '!';
    static final long L0 = 0L;
    static final String ALIEN0NAME = "Homopolymers";
    static final String[] ALIEN0 = new String[]{"AAAAAAAAAAAAAAAAAAAA", "CCCCCCCCCCCCCCCCCCCC", "GGGGGGGGGGGGGGGGGGGG", "TTTTTTTTTTTTTTTTTTTT"};
    static final String ALIEN1NAME = "Dimers";
    static final String[] ALIEN1 = new String[]{"ACACACACACACACAC", "AGAGAGAGAGAGAGAG", "ATATATATATATATAT", "CGCGCGCGCGCGCGCG", "CTCTCTCTCTCTCTCT", "GTGTGTGTGTGTGTGT"};
    static final String ALIEN2NAME = "Trimers";
    static final String[] ALIEN2 = new String[]{"AACAACAACAACAACAAC", "AAGAAGAAGAAGAAGAAG", "AATAATAATAATAATAAT", "ACCACCACCACCACCACC", "ACGACGACGACGACGACG", "ACTACTACTACTACTACT", "AGCAGCAGCAGCAGCAGC", "AGGAGGAGGAGGAGGAGG", "AGTAGTAGTAGTAGTAGT", "ATCATCATCATCATCATC", "ATGATGATGATGATGATG", "ATTATTATTATTATTATT", "CCGCCGCCGCCGCCGCCG", "CCTCCTCCTCCTCCTCCT", "CGGCGGCGGCGGCGGCGG", "CGTCGTCGTCGTCGTCGT", "CTGCTGCTGCTGCTGCTG", "CTTCTTCTTCTTCTTCTT", "GGTGGTGGTGGTGGTGGT", "GTTGTTGTTGTTGTTGTT"};
    static final String ALIEN3NAME = "";
    static final String[] ALIEN3 = new String[0];
    static final String ALIEN4NAME = "";
    static final String[] ALIEN4 = new String[0];
    static final String ALIEN5NAME = "";
    static final String[] ALIEN5 = new String[0];
    static final String ALIEN6NAME = "";
    static final String[] ALIEN6 = new String[0];
    static final String ALIEN7NAME = "";
    static final String[] ALIEN7 = new String[0];
    static final String ALIEN8NAME = "";
    static final String[] ALIEN8 = new String[0];
    static final String ALIEN9NAME = "";
    static final String[] ALIEN9 = new String[0];
    static File finfile;
    static File rinfile;
    static File foutfile;
    static File routfile;
    static File soutfile;
    static String falien;
    static String ralien;
    static byte k;
    static byte mismatch;
    static char qmin;
    static short prop;
    static int minLgt;
    static byte verbose;
    static BufferedReader fin;
    static BufferedReader rin;
    static BufferedWriter fout;
    static BufferedWriter rout;
    static BufferedWriter sout;
    static byte paired;
    static BitSet bsfkmer;
    static BitSet bsrkmer;
    static int[] ifkmer;
    static int[] irkmer;
    static long[] lfkmer;
    static long[] lrkmer;
    static String fid1;
    static String fseq;
    static String fid2;
    static String fqsc;
    static String rid1;
    static String rseq;
    static String rid2;
    static String rqsc;
    static byte[] score;
    static byte cpt;
    static byte b;
    static byte bq;
    static byte k_1;
    static byte k2;
    static short i;
    static short j;
    static short x;
    static short lgt;
    static short l;
    static short start0;
    static short start;
    static short end0;
    static short end;
    static short n;
    static short scount;
    static int id;
    static int o;
    static int lfkmerLgt;
    static int lrkmerLgt;
    static int pcpt;
    static int ftcpt;
    static int rtcpt;
    static int frcpt;
    static int rrcpt;
    static long t;
    static long cur;
    static int imsk;
    static int iptn;
    static long lmsk;
    static long lptn;
    static long nptn;
    static long lkm;
    static long lpt;
    static String line;
    static String seq;
    static ArrayList<String> contaminant;
    static TreeSet<Long> lts;
    static StringBuffer sb;

    static void displayOptions() {
        System.out.println("");
        System.out.println(" AlienTrimmer v.0.3.2");
        System.out.println("");
        System.out.println(" USAGE:  java -jar AlienTrimmer.jar  [options]");
        System.out.println("");
        System.out.println(" Fast trimming to filter out alien sequences (e.g. adaptors, primers) in");
        System.out.println(" both 5' and 3' read ends");
        System.out.println("");
        System.out.println(" OPTIONS:");
        System.out.println("  -i  <infile>  [single-ends] FASTQ formatted input file name");
        System.out.println("  -if <infile>  [paired-ends] FASTQ formatted input file name containing");
        System.out.println("                              forward (fwd) reads");
        System.out.println("  -ir <infile>  [paired-ends] FASTQ formatted input file name containing");
        System.out.println("                              reverse (rev) reads");
        System.out.println("  -o  <outfile> [single-ends] output file name");
        System.out.println("  -of <outfile> [paired-ends] output file name for trimmed fwd reads");
        System.out.println("  -or <outfile> [paired-ends] output file name for trimmed rev reads");
        System.out.println("  -os <outfile> [paired-ends] output  file  name for  remaining  trimmed");
        System.out.println("                              single (sgl) reads");
        System.out.println("  -c  [0-9]*    [single-ends] alien sequence  id(s) (see option -d)");
        System.out.println("  -d  [0-9]     displays alien sequences for the specified id:");
        if (ALIEN0.length > 0) {
            System.out.println("                 0: Homopolymers");
        }
        if (ALIEN1.length > 0) {
            System.out.println("                 1: Dimers");
        }
        if (ALIEN2.length > 0) {
            System.out.println("                 2: Trimers");
        }
        if (ALIEN3.length > 0) {
            System.out.println("                 3: ");
        }
        if (ALIEN4.length > 0) {
            System.out.println("                 4: ");
        }
        if (ALIEN5.length > 0) {
            System.out.println("                 5: ");
        }
        if (ALIEN6.length > 0) {
            System.out.println("                 6: ");
        }
        if (ALIEN7.length > 0) {
            System.out.println("                 7: ");
        }
        if (ALIEN8.length > 0) {
            System.out.println("                 8: ");
        }
        if (ALIEN9.length > 0) {
            System.out.println("                 9: ");
        }
        System.out.println("  -c  <infile>  [single-ends] input file  name  containing  user-defined");
        System.out.println("                              alien  sequence(s) (one line per sequence)");
        System.out.println("  -cf [0-9]*    [paired-ends] same as -c for only fwd reads");
        System.out.println("  -cf <infile>  [paired-ends] same as -c for only fwd reads");
        System.out.println("  -cr [0-9]*    [paired-ends] same as -c for only rev reads");
        System.out.println("  -cr <infile>  [paired-ends] same as -c for only rev reads");
        System.out.println("  -k [5-15]     k value for k-mer decomposition;  must lie between 5 and");
        System.out.println("                15 (default: k=10)");
        System.out.println("  -m <int>      allowed mismatch value (default: m=k/2)");
        System.out.println("  -l <int>      minimum read  length to output;  all trimmed reads  with");
        System.out.println("                length below this value are filtered out (default: l=15)");
        System.out.println("  -q <char>     cut-off Phred quality  score character to  trim off low-");
        System.out.println("                quality read ends (default: q=\"!\")");
        System.out.println("  -p [0-100]    minimum   allowed   percentage   of   correctly   called");
        System.out.println("                nucleotides  (i.e.  with Phred  quality score  character");
        System.out.println("                higher than q); all reads with a percentage of correctly");
        System.out.println("                called nucleotide lower than this value are filtered out");
        System.out.println("                (default: p=0)");
        System.out.println("  -v            displays trimming details during the whole process");
        System.out.println("");
        System.out.println(" EXAMPLES:");
        System.out.println(" [single-ends]");
        System.out.println("   AlienTrimmer -i reads.fq -o trim.fq -c 0 -l 30");
        System.out.println("   AlienTrimmer -i reads.fq -c aliens.fa -k 9 -q \"5\" -p 80");
        System.out.println(" [paired-ends]");
        System.out.println("   AlienTrimmer -if fwd.fq -ir rev.fq -c alien.fa -q \"5\" -p 80");
        System.out.println("   AlienTrimmer -if fwd.fq -ir rev.fq -cf alien.fwd.fa -cr alien.rev.fa");
        System.out.println("");
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 2) {
            AlienTrimmer.displayOptions();
            System.exit(0);
        }
        paired = 0;
        finfile = new File("no.file");
        rinfile = new File("no.file");
        foutfile = new File("no.file");
        routfile = new File("no.file");
        soutfile = new File("no.file");
        falien = "no.alien";
        ralien = "no.alien";
        k = (byte)10;
        mismatch = (byte)-1;
        minLgt = 15;
        qmin = (char)33;
        prop = 0;
        verbose = 0;
        o = -1;
        while (++o < stringArray.length) {
            if (stringArray[o].equals("-i")) {
                if ((finfile = new File(stringArray[++o])).exists()) continue;
                System.out.println("  input file does not exists (option -i)");
                System.exit(0);
                continue;
            }
            if (stringArray[o].equals("-if")) {
                if ((finfile = new File(stringArray[++o])).exists()) continue;
                System.out.println("  input file does not exists (option -if)");
                System.exit(0);
                continue;
            }
            if (stringArray[o].equals("-ir")) {
                if (!(rinfile = new File(stringArray[++o])).exists()) {
                    System.out.println("  input file does not exists (option -ir)");
                    System.exit(0);
                }
                paired = 1;
                continue;
            }
            if (stringArray[o].equals("-o")) {
                foutfile = new File(stringArray[++o]);
                continue;
            }
            if (stringArray[o].equals("-of")) {
                foutfile = new File(stringArray[++o]);
                continue;
            }
            if (stringArray[o].equals("-or")) {
                routfile = new File(stringArray[++o]);
                paired = 1;
                continue;
            }
            if (stringArray[o].equals("-os")) {
                soutfile = new File(stringArray[++o]);
                paired = 1;
                continue;
            }
            if (stringArray[o].equals("-c")) {
                falien = stringArray[++o];
                continue;
            }
            if (stringArray[o].equals("-cf")) {
                falien = stringArray[++o];
                continue;
            }
            if (stringArray[o].equals("-cr")) {
                ralien = stringArray[++o];
                paired = 1;
                continue;
            }
            if (stringArray[o].equals("-k")) {
                try {
                    k = Byte.parseByte(stringArray[++o]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("  incorrect K-mer value (option -k)");
                    System.exit(0);
                }
                if (k >= 5 && k <= 15) continue;
                System.out.println("  K-mer should be set between 5 and 15 (option -k)");
                System.exit(1);
                continue;
            }
            if (stringArray[o].equals("-m")) {
                try {
                    mismatch = Byte.parseByte(stringArray[++o]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("  incorrect mismatch value (option -m)");
                    System.exit(0);
                }
                if (mismatch >= 0 && mismatch <= 15) continue;
                System.out.println("  mismatch value should be set between 0 and 15 (option -m)");
                System.exit(1);
                continue;
            }
            if (stringArray[o].equals("-l")) {
                try {
                    minLgt = Integer.parseInt(stringArray[++o]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("  incorrect min read length value (option -l)");
                    System.exit(0);
                }
                if (minLgt >= 0) continue;
                System.out.println("  min read length should be positive (option -l)");
                System.exit(1);
                continue;
            }
            if (stringArray[o].equals("-q")) {
                qmin = stringArray[++o].toCharArray()[0];
                continue;
            }
            if (stringArray[o].equals("-p")) {
                try {
                    prop = (short)Double.parseDouble(stringArray[++o]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("  incorrect percentage value (option -p)");
                    System.exit(0);
                }
                if (prop < 0) {
                    prop = 0;
                }
                if (prop <= 100) continue;
                System.out.println("  percentage should be set between 0 and 100 (option -p)");
                System.exit(1);
                continue;
            }
            if (stringArray[o].equals("-v")) {
                verbose = 1;
                continue;
            }
            if (!stringArray[o].equals("-d")) continue;
            try {
                id = Integer.parseInt(stringArray[++o]);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("  incorrect alien sequence id (option -d)");
                System.exit(1);
            }
            contaminant = new ArrayList();
            switch (id) {
                case 0: {
                    Collections.addAll(contaminant, ALIEN0);
                    break;
                }
                case 1: {
                    Collections.addAll(contaminant, ALIEN1);
                    break;
                }
                case 2: {
                    Collections.addAll(contaminant, ALIEN2);
                    break;
                }
                case 3: {
                    Collections.addAll(contaminant, ALIEN3);
                    break;
                }
                case 4: {
                    Collections.addAll(contaminant, ALIEN4);
                    break;
                }
                case 5: {
                    Collections.addAll(contaminant, ALIEN5);
                    break;
                }
                case 6: {
                    Collections.addAll(contaminant, ALIEN6);
                    break;
                }
                case 7: {
                    Collections.addAll(contaminant, ALIEN7);
                    break;
                }
                case 8: {
                    Collections.addAll(contaminant, ALIEN8);
                    break;
                }
                case 9: {
                    Collections.addAll(contaminant, ALIEN9);
                }
            }
            id = -1;
            while (++id < contaminant.size()) {
                System.out.println(contaminant.get(id));
            }
            System.exit(0);
        }
        if (finfile.toString().equals("no.file")) {
            System.out.println("  no input file");
            System.exit(1);
        }
        if (foutfile.toString().equals("no.file")) {
            foutfile = new File(finfile + ".at.fq");
        }
        if (paired != 0) {
            if (rinfile.toString().equals("no.file")) {
                System.out.println("  no input file (option -ir)");
                System.exit(1);
            }
            if (routfile.toString().equals("no.file")) {
                routfile = new File(rinfile + ".at.fq");
            }
            if (soutfile.toString().equals("no.file")) {
                soutfile = new File(finfile + ".at.sgl.fq");
            }
        }
        if (mismatch < 0) {
            mismatch = k;
            mismatch = (byte)(mismatch + 1);
            mismatch = (byte)(mismatch / 2);
        }
        if (qmin == '!') {
            prop = 0;
        }
        if (verbose != 0) {
            System.out.println("  AlienTrimmer main options: -k " + k + " -l " + minLgt + " -m " + mismatch);
        }
        t = System.currentTimeMillis();
        imsk = 0;
        ++imsk;
        imsk <<= 2 * k;
        --imsk;
        lmsk = 0L;
        ++lmsk;
        lmsk <<= 4 * k;
        --lmsk;
        k_1 = k;
        k_1 = (byte)(k_1 - 1);
        k2 = k;
        k2 = (byte)(k2 * 2);
        mismatch = (byte)(mismatch + 1);
        if (paired == 0) {
            block427: {
                contaminant = new ArrayList();
                if (new File(falien).exists()) {
                    fin = new BufferedReader(new FileReader(new File(falien)));
                    while (true) {
                        try {
                            line = fin.readLine().trim();
                        }
                        catch (NullPointerException nullPointerException) {
                            fin.close();
                            break block427;
                        }
                        if (line.length() == 0 || line.startsWith("#") || line.startsWith("%") || line.startsWith(">")) continue;
                        contaminant.add(line);
                    }
                }
                o = falien.length();
                while (--o >= 0) {
                    try {
                        id = Integer.parseInt("" + falien.charAt(o));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("  incorrect alien sequence id (option -c)");
                        System.exit(0);
                    }
                    switch (id) {
                        case 0: {
                            Collections.addAll(contaminant, ALIEN0);
                            break;
                        }
                        case 1: {
                            Collections.addAll(contaminant, ALIEN1);
                            break;
                        }
                        case 2: {
                            Collections.addAll(contaminant, ALIEN2);
                            break;
                        }
                        case 3: {
                            Collections.addAll(contaminant, ALIEN3);
                            break;
                        }
                        case 4: {
                            Collections.addAll(contaminant, ALIEN4);
                            break;
                        }
                        case 5: {
                            Collections.addAll(contaminant, ALIEN5);
                            break;
                        }
                        case 6: {
                            Collections.addAll(contaminant, ALIEN6);
                            break;
                        }
                        case 7: {
                            Collections.addAll(contaminant, ALIEN7);
                            break;
                        }
                        case 8: {
                            Collections.addAll(contaminant, ALIEN8);
                            break;
                        }
                        case 9: {
                            Collections.addAll(contaminant, ALIEN9);
                        }
                    }
                }
            }
            if (contaminant.size() == 0) {
                System.out.println("  no alien sequence (option -c)");
                System.exit(0);
            }
            if (verbose != 0) {
                System.out.println("  Number of alien sequence(s): " + contaminant.size());
            }
            o = contaminant.size();
            while (--o >= 0) {
                sb = new StringBuffer(contaminant.get(o));
                i = (short)sb.length();
                if (i < k) {
                    contaminant.remove(o);
                    continue;
                }
                block275: while ((i = (short)(i - 1)) >= 0) {
                    switch (sb.charAt(i)) {
                        case 'A': 
                        case 'C': 
                        case 'G': 
                        case 'T': 
                        case 'a': 
                        case 'c': 
                        case 'g': 
                        case 't': {
                            continue block275;
                        }
                        case 'U': 
                        case 'u': {
                            sb.setCharAt(i, 'T');
                            contaminant.set(o, sb.toString());
                            continue block275;
                        }
                        case 'M': 
                        case 'm': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block275;
                        }
                        case 'R': 
                        case 'r': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block275;
                        }
                        case 'W': 
                        case 'w': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block275;
                        }
                        case 'S': 
                        case 's': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block275;
                        }
                        case 'Y': 
                        case 'y': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block275;
                        }
                        case 'K': 
                        case 'k': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block275;
                        }
                        case 'B': 
                        case 'b': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block275;
                        }
                        case 'D': 
                        case 'd': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block275;
                        }
                        case 'H': 
                        case 'h': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block275;
                        }
                        case 'V': 
                        case 'v': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block275;
                        }
                        case 'N': 
                        case 'X': 
                        case 'n': 
                        case 'x': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block275;
                        }
                    }
                    System.out.println("the following alien sequence contains at least one incorrect nucleotide (" + sb.charAt(i) + ") : " + sb.toString());
                    System.exit(1);
                }
            }
            o = contaminant.size();
            while (--o >= 0) {
                seq = contaminant.get(o);
                lgt = (short)seq.length();
                sb = new StringBuffer(lgt);
                while ((lgt = (short)(lgt - 1)) >= 0) {
                    switch (seq.charAt(lgt)) {
                        case 'A': 
                        case 'a': {
                            sb = sb.append('T');
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            sb = sb.append('G');
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            sb = sb.append('C');
                            break;
                        }
                        case 'T': 
                        case 't': {
                            sb = sb.append('A');
                        }
                    }
                }
                contaminant.add(sb.toString());
            }
            bsfkmer = new BitSet(imsk + 1);
            lts = new TreeSet();
            o = contaminant.size();
            while (--o >= 0) {
                seq = contaminant.get(o).toUpperCase();
                lgt = (short)seq.length();
                iptn = 0;
                lptn = 0L;
                j = (short)-1;
                while ((j = (short)(j + 1)) < k_1) {
                    iptn <<= 2;
                    lptn <<= 4;
                    switch (seq.charAt(j)) {
                        case 'A': {
                            lptn |= 1L;
                            break;
                        }
                        case 'C': {
                            iptn |= 1;
                            lptn |= 2L;
                            break;
                        }
                        case 'G': {
                            iptn |= 2;
                            lptn |= 4L;
                            break;
                        }
                        case 'T': {
                            iptn |= 3;
                            lptn |= 8L;
                        }
                    }
                }
                j = (short)(j - 1);
                while ((j = (short)(j + 1)) < lgt) {
                    iptn <<= 2;
                    lptn <<= 4;
                    switch (seq.charAt(j)) {
                        case 'A': {
                            lptn |= 1L;
                            break;
                        }
                        case 'C': {
                            iptn |= 1;
                            lptn |= 2L;
                            break;
                        }
                        case 'G': {
                            iptn |= 2;
                            lptn |= 4L;
                            break;
                        }
                        case 'T': {
                            iptn |= 3;
                            lptn |= 8L;
                        }
                    }
                    bsfkmer.set(iptn &= imsk);
                    lts.add(new Long(lptn &= lmsk));
                }
            }
            lfkmerLgt = o = lts.size();
            lfkmer = new long[o];
            while (--o >= 0) {
                AlienTrimmer.lfkmer[AlienTrimmer.o] = lts.pollLast();
            }
            if (verbose != 0) {
                System.out.println("  Number of k-mers (k=" + k + "): " + lfkmer.length);
                System.out.println("");
            }
            lts = null;
            contaminant = null;
            sb = null;
            fin = new BufferedReader(new FileReader(finfile));
            fout = new BufferedWriter(new FileWriter(foutfile));
            pcpt = 0;
            ftcpt = 0;
            frcpt = 0;
            cpt = 0;
            score = new byte[51];
            block282: while (true) {
                try {
                    line = fin.readLine().trim();
                }
                catch (NullPointerException nullPointerException) {
                    fin.close();
                    break;
                }
                cpt = (byte)(cpt + 1);
                switch (cpt) {
                    case 1: {
                        fid1 = line;
                        continue block282;
                    }
                    case 2: {
                        fseq = line;
                        continue block282;
                    }
                    case 3: {
                        fid2 = line;
                        continue block282;
                    }
                    case 4: {
                        fqsc = line;
                        cpt = 0;
                    }
                }
                if (++pcpt % 1000000 == 0) {
                    Object[] objectArray = new Object[1];
                    cur = (System.currentTimeMillis() - t) / 1000L;
                    objectArray[0] = new Long(cur / 60L);
                    line = "0" + cur % 60L;
                    System.out.println("[" + String.format(Locale.US, "%02d", objectArray) + ":" + line.substring(line.length() - 2) + "]" + String.format(Locale.US, "%,12d", new Integer(pcpt)) + " reads processed:" + String.format(Locale.US, "%,12d", new Integer(ftcpt)) + " trimmed" + String.format(Locale.US, "%,12d", new Integer(frcpt)) + " removed");
                }
                if ((lgt = (short)fseq.length()) < minLgt) {
                    ++frcpt;
                    continue;
                }
                if (lgt >= score.length) {
                    lgt = (short)(lgt + 1);
                    score = new byte[lgt];
                    lgt = (short)(lgt - 1);
                } else {
                    Arrays.fill(score, (byte)0);
                }
                end = lgt;
                start = (short)-1;
                start0 = (short)-1;
                scount = 0;
                iptn = 0;
                i = (short)-1;
                j = (short)-1;
                b = 0;
                bq = 0;
                if (fseq.indexOf(78) != -1 || fseq.indexOf(110) != -1) {
                    lptn = 0L;
                    nptn = 0L;
                    n = 0;
                    while ((j = (short)(j + 1)) < k_1) {
                        iptn <<= 2;
                        lptn <<= 4;
                        nptn <<= 4;
                        switch (fseq.charAt(j)) {
                            case 'A': 
                            case 'a': {
                                lptn |= 1L;
                                nptn |= 1L;
                                break;
                            }
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                lptn |= 2L;
                                nptn |= 2L;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                lptn |= 4L;
                                nptn |= 4L;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                                lptn |= 8L;
                                nptn |= 8L;
                                break;
                            }
                            default: {
                                n = k;
                                nptn |= 0xFL;
                            }
                        }
                        n = (short)(n - 1);
                    }
                    block284: while (j < lgt) {
                        i = (short)(i + 1);
                        score[i] = (byte)(score[i] + b);
                        b = score[i];
                        bq = fqsc.charAt(i) < qmin ? (byte)1 : 0;
                        iptn <<= 2;
                        lptn <<= 4;
                        nptn <<= 4;
                        switch (fseq.charAt(j)) {
                            case 'A': 
                            case 'a': {
                                lptn |= 1L;
                                nptn |= 1L;
                                break;
                            }
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                lptn |= 2L;
                                nptn |= 2L;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                lptn |= 4L;
                                nptn |= 4L;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                                lptn |= 8L;
                                nptn |= 8L;
                                break;
                            }
                            default: {
                                n = k;
                                nptn |= 0xFL;
                            }
                        }
                        n = (short)(n - 1);
                        switch (n < 0 ? 0 : 1) {
                            case 0: {
                                if (!bsfkmer.get(iptn &= imsk)) break;
                                AlienTrimmer.score[AlienTrimmer.i] = b = (byte)(b + 1);
                                short s = i;
                                score[s] = (byte)(score[s] + bq);
                                j = (short)(j + 1);
                                score[j] = (byte)(score[j] - 1);
                                scount = (short)(scount + 2);
                                short s2 = start0 = start0 < 0 ? (short)(2 * i) : start0;
                                start = j >= start0 && scount + k2 >= j ? (start < 0 ? j : (i - start <= mismatch ? j : (start = (short)(start + 1)))) : (start = (short)(start + 1));
                                start = (short)(start - 1);
                                continue block284;
                            }
                            default: {
                                id = Arrays.binarySearch(lfkmer, lptn &= lmsk);
                                ++id;
                                id = -id;
                                --id;
                                o = Arrays.binarySearch(lfkmer, nptn &= lmsk);
                                ++o;
                                o = -o;
                                while (++id < o) {
                                    lkm = lfkmer[id];
                                    lpt = lptn;
                                    if (lkm != (lkm |= lpt)) continue;
                                }
                                if (id == o) break;
                                AlienTrimmer.score[AlienTrimmer.i] = b = (byte)(b + 1);
                                short s = i;
                                score[s] = (byte)(score[s] + bq);
                                j = (short)(j + 1);
                                score[j] = (byte)(score[j] - 1);
                                scount = (short)(scount + 2);
                                short s3 = start0 = start0 < 0 ? (short)(2 * i) : start0;
                                start = j >= start0 && scount + k2 >= j ? (start < 0 ? j : (i - start <= mismatch ? j : (start = (short)(start + 1)))) : (start = (short)(start + 1));
                                start = (short)(start - 1);
                                continue block284;
                            }
                        }
                        AlienTrimmer.score[AlienTrimmer.i] = b < 0 ? (byte)0 : b;
                        b = AlienTrimmer.score[AlienTrimmer.i];
                        j = (short)(j + 1);
                        short s = i;
                        score[s] = (byte)(score[s] + bq);
                        if (score[s] == 0) continue;
                        scount = (short)(scount + 2);
                        start0 = start0 < 0 ? (short)(2 * i) : start0;
                        start = start < i && (x = i) - start <= mismatch && (x = (short)(x + 1)) >= start0 && scount > x ? i : start;
                        end = i;
                    }
                } else {
                    while ((j = (short)(j + 1)) < k_1) {
                        iptn <<= 2;
                        switch (fseq.charAt(j)) {
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                            }
                        }
                    }
                    while (j < lgt) {
                        i = (short)(i + 1);
                        score[i] = (byte)(score[i] + b);
                        b = score[i];
                        bq = fqsc.charAt(i) < qmin ? (byte)1 : 0;
                        iptn <<= 2;
                        switch (fseq.charAt(j)) {
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                            }
                        }
                        if (bsfkmer.get(iptn &= imsk)) {
                            AlienTrimmer.score[AlienTrimmer.i] = b = (byte)(b + 1);
                            short s = i;
                            score[s] = (byte)(score[s] + bq);
                            j = (short)(j + 1);
                            score[j] = (byte)(score[j] - 1);
                            scount = (short)(scount + 2);
                            short s4 = start0 = start0 < 0 ? (short)(2 * i) : start0;
                            start = j >= start0 && scount + k2 >= j ? (start < 0 ? j : (i - start <= mismatch ? j : (start = (short)(start + 1)))) : (start = (short)(start + 1));
                            start = (short)(start - 1);
                            continue;
                        }
                        AlienTrimmer.score[AlienTrimmer.i] = b < 0 ? (byte)0 : b;
                        b = AlienTrimmer.score[AlienTrimmer.i];
                        j = (short)(j + 1);
                        short s = i;
                        score[s] = (byte)(score[s] + bq);
                        if (score[s] == 0) continue;
                        scount = (short)(scount + 2);
                        start0 = start0 < 0 ? (short)(2 * i) : start0;
                        start = start < i && (x = i) - start <= mismatch && (x = (short)(x + 1)) >= start0 && scount > x ? i : start;
                        end = i;
                    }
                }
                while ((i = (short)(i + 1)) < lgt) {
                    short s = i;
                    byte by = (byte)(score[s] + b);
                    score[s] = by;
                    b = by;
                    bq = fqsc.charAt(i) < qmin ? (byte)1 : 0;
                    AlienTrimmer.score[AlienTrimmer.i] = b < 0 ? (byte)0 : b;
                    b = AlienTrimmer.score[AlienTrimmer.i];
                    short s5 = i;
                    score[s5] = (byte)(score[s5] + bq);
                    if (score[s5] == 0) continue;
                    scount = (short)(scount + 2);
                    start0 = start0 < 0 ? (short)(2 * i) : start0;
                    start = start < i && (x = i) - start <= mismatch && (x = (short)(x + 1)) >= start0 && scount > x ? i : start;
                    end = i;
                }
                int n = start = start0 > 0 && start0 >= lgt - start ? -1 : start;
                if (start0 >= 0 && lgt - start - 1 >= minLgt) {
                    end0 = end;
                    end = lgt;
                    i = j = end0;
                    i = (short)(i - k);
                    i = (short)(i + 1);
                    end0 = (short)(end0 + 1);
                    end0 = (short)(end0 * 2);
                    scount = (short)2;
                    end = end > j && end - j <= mismatch && end0 - j >= lgt && scount >= lgt - j ? j : end;
                    start0 = (short)(start0 / 2);
                    o = start0 > start ? start0 : start;
                    while (true) {
                        x = j = (short)(j - 1);
                        if (j < o) break;
                        i = (short)(i - 1);
                        b = score[j];
                        if (b == 0) continue;
                        scount = (short)(scount + 2);
                        end = i >= 0 && b >= 2 && (b = (byte)(b - 1)) == score[x = (short)(x + 1)] && score[i] != 0 ? (end0 - i >= lgt && scount + k2 >= lgt - i ? (end == lgt ? i : (end - j <= mismatch ? i : end)) : end) : end;
                        end = end > j && end - j <= mismatch && end0 - j >= lgt && scount >= lgt - j ? j : end;
                    }
                    end = start < end ? (end = (short)(end - 1)) : start;
                    end = (short)(end + 1);
                } else {
                    end = lgt;
                }
                l = end;
                l = (short)(l - start);
                scount = l = (short)(l - 1);
                if (prop != 0) {
                    i = start;
                    while ((i = (short)(i + 1)) < end) {
                        scount = (short)(scount - (score[i] == 1 ? (short)1 : 0));
                    }
                }
                if (l < minLgt || 100 * scount < prop * l) {
                    ++frcpt;
                } else if (start == -1 && end == lgt) {
                    fout.write(fid1);
                    fout.newLine();
                    fout.write(fseq);
                    fout.newLine();
                    fout.write(fid2);
                    fout.newLine();
                    fout.write(fqsc);
                    fout.newLine();
                } else {
                    ++ftcpt;
                    fout.write(fid1);
                    fout.newLine();
                    start = (short)(start + 1);
                    fout.write(fseq.substring(start, end));
                    fout.newLine();
                    fout.write(fid2);
                    fout.newLine();
                    short s = start;
                    start = (short)(s - 1);
                    fout.write(fqsc.substring(s, end));
                    fout.newLine();
                }
                if (verbose == 0 || start == -1 && end == lgt) continue;
                System.out.println(fid1);
                System.out.println(fseq);
                o = -1;
                while (++o < lgt) {
                    b = score[o];
                    System.out.print(b == 0 ? " " : (b < 10 ? Byte.valueOf(b) : (b == 10 ? "0" : "" + (char)(54 + b))));
                }
                System.out.println("");
                o = -1;
                while (++o <= start) {
                    System.out.print(">");
                }
                --o;
                while (++o < end) {
                    System.out.print(" ");
                }
                --o;
                while (++o < lgt) {
                    System.out.print("<");
                }
                System.out.println("");
                System.out.println("");
            }
            fout.close();
            Object[] objectArray = new Object[1];
            cur = (System.currentTimeMillis() - t) / 1000L;
            objectArray[0] = new Long(cur / 60L);
            line = "0" + cur % 60L;
            System.out.println("[" + String.format(Locale.US, "%02d", objectArray) + ":" + line.substring(line.length() - 2) + "]" + String.format(Locale.US, "%,12d", new Integer(pcpt)) + " reads processed:" + String.format(Locale.US, "%,12d", new Integer(ftcpt)) + " trimmed" + String.format(Locale.US, "%,12d", new Integer(frcpt)) + " removed");
        }
        if (paired != 0) {
            block429: {
                block428: {
                    contaminant = new ArrayList();
                    if (new File(falien).exists()) {
                        fin = new BufferedReader(new FileReader(new File(falien)));
                        while (true) {
                            try {
                                line = fin.readLine().trim();
                            }
                            catch (NullPointerException nullPointerException) {
                                fin.close();
                                break block428;
                            }
                            if (line.length() == 0 || line.startsWith("#") || line.startsWith("%") || line.startsWith(">")) continue;
                            contaminant.add(line);
                        }
                    }
                    o = falien.length();
                    while (--o >= 0) {
                        try {
                            id = Integer.parseInt("" + falien.charAt(o));
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("  incorrect alien sequence id (option -cf)");
                            System.exit(0);
                        }
                        switch (id) {
                            case 0: {
                                Collections.addAll(contaminant, ALIEN0);
                                break;
                            }
                            case 1: {
                                Collections.addAll(contaminant, ALIEN1);
                                break;
                            }
                            case 2: {
                                Collections.addAll(contaminant, ALIEN2);
                                break;
                            }
                            case 3: {
                                Collections.addAll(contaminant, ALIEN3);
                                break;
                            }
                            case 4: {
                                Collections.addAll(contaminant, ALIEN4);
                                break;
                            }
                            case 5: {
                                Collections.addAll(contaminant, ALIEN5);
                                break;
                            }
                            case 6: {
                                Collections.addAll(contaminant, ALIEN6);
                                break;
                            }
                            case 7: {
                                Collections.addAll(contaminant, ALIEN7);
                                break;
                            }
                            case 8: {
                                Collections.addAll(contaminant, ALIEN8);
                                break;
                            }
                            case 9: {
                                Collections.addAll(contaminant, ALIEN9);
                            }
                        }
                    }
                }
                if (contaminant.size() == 0) {
                    System.out.println("  no alien sequence  (option -cf)");
                    System.exit(0);
                }
                if (verbose != 0) {
                    System.out.println("  [fwd] Number of alien sequence(s): " + contaminant.size());
                }
                o = contaminant.size();
                while (--o >= 0) {
                    sb = new StringBuffer(contaminant.get(o));
                    i = (short)sb.length();
                    if (i < k) {
                        contaminant.remove(o);
                        continue;
                    }
                    block298: while ((i = (short)(i - 1)) >= 0) {
                        switch (sb.charAt(i)) {
                            case 'A': 
                            case 'C': 
                            case 'G': 
                            case 'T': 
                            case 'a': 
                            case 'c': 
                            case 'g': 
                            case 't': {
                                continue block298;
                            }
                            case 'U': 
                            case 'u': {
                                sb.setCharAt(i, 'T');
                                contaminant.set(o, sb.toString());
                                continue block298;
                            }
                            case 'M': 
                            case 'm': {
                                contaminant.remove(o);
                                sb.setCharAt(i, 'A');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'C');
                                contaminant.add(sb.toString());
                                o = contaminant.size();
                                i = 0;
                                continue block298;
                            }
                            case 'R': 
                            case 'r': {
                                contaminant.remove(o);
                                sb.setCharAt(i, 'A');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'G');
                                contaminant.add(sb.toString());
                                o = contaminant.size();
                                i = 0;
                                continue block298;
                            }
                            case 'W': 
                            case 'w': {
                                contaminant.remove(o);
                                sb.setCharAt(i, 'A');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'T');
                                contaminant.add(sb.toString());
                                o = contaminant.size();
                                i = 0;
                                continue block298;
                            }
                            case 'S': 
                            case 's': {
                                contaminant.remove(o);
                                sb.setCharAt(i, 'C');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'G');
                                contaminant.add(sb.toString());
                                o = contaminant.size();
                                i = 0;
                                continue block298;
                            }
                            case 'Y': 
                            case 'y': {
                                contaminant.remove(o);
                                sb.setCharAt(i, 'C');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'T');
                                contaminant.add(sb.toString());
                                o = contaminant.size();
                                i = 0;
                                continue block298;
                            }
                            case 'K': 
                            case 'k': {
                                contaminant.remove(o);
                                sb.setCharAt(i, 'G');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'T');
                                contaminant.add(sb.toString());
                                o = contaminant.size();
                                i = 0;
                                continue block298;
                            }
                            case 'B': 
                            case 'b': {
                                contaminant.remove(o);
                                sb.setCharAt(i, 'C');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'G');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'T');
                                contaminant.add(sb.toString());
                                o = contaminant.size();
                                i = 0;
                                continue block298;
                            }
                            case 'D': 
                            case 'd': {
                                contaminant.remove(o);
                                sb.setCharAt(i, 'A');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'G');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'T');
                                contaminant.add(sb.toString());
                                o = contaminant.size();
                                i = 0;
                                continue block298;
                            }
                            case 'H': 
                            case 'h': {
                                contaminant.remove(o);
                                sb.setCharAt(i, 'A');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'C');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'T');
                                contaminant.add(sb.toString());
                                o = contaminant.size();
                                i = 0;
                                continue block298;
                            }
                            case 'V': 
                            case 'v': {
                                contaminant.remove(o);
                                sb.setCharAt(i, 'A');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'C');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'G');
                                contaminant.add(sb.toString());
                                o = contaminant.size();
                                i = 0;
                                continue block298;
                            }
                            case 'N': 
                            case 'X': 
                            case 'n': 
                            case 'x': {
                                contaminant.remove(o);
                                sb.setCharAt(i, 'A');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'C');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'G');
                                contaminant.add(sb.toString());
                                sb.setCharAt(i, 'T');
                                contaminant.add(sb.toString());
                                o = contaminant.size();
                                i = 0;
                                continue block298;
                            }
                        }
                        System.out.println("the following alien sequence contains at least one incorrect nucleotide (" + sb.charAt(i) + ") : " + sb.toString());
                        System.exit(1);
                    }
                }
                o = contaminant.size();
                while (--o >= 0) {
                    seq = contaminant.get(o);
                    lgt = (short)seq.length();
                    sb = new StringBuffer(lgt);
                    while ((lgt = (short)(lgt - 1)) >= 0) {
                        switch (seq.charAt(lgt)) {
                            case 'A': 
                            case 'a': {
                                sb = sb.append('T');
                                break;
                            }
                            case 'C': 
                            case 'c': {
                                sb = sb.append('G');
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                sb = sb.append('C');
                                break;
                            }
                            case 'T': 
                            case 't': {
                                sb = sb.append('A');
                            }
                        }
                    }
                    contaminant.add(sb.toString());
                }
                bsfkmer = new BitSet(imsk + 1);
                lts = new TreeSet();
                o = contaminant.size();
                while (--o >= 0) {
                    seq = contaminant.get(o).toUpperCase();
                    lgt = (short)seq.length();
                    iptn = 0;
                    lptn = 0L;
                    j = (short)-1;
                    while ((j = (short)(j + 1)) < k_1) {
                        iptn <<= 2;
                        lptn <<= 4;
                        switch (seq.charAt(j)) {
                            case 'A': {
                                lptn |= 1L;
                                break;
                            }
                            case 'C': {
                                iptn |= 1;
                                lptn |= 2L;
                                break;
                            }
                            case 'G': {
                                iptn |= 2;
                                lptn |= 4L;
                                break;
                            }
                            case 'T': {
                                iptn |= 3;
                                lptn |= 8L;
                            }
                        }
                    }
                    j = (short)(j - 1);
                    while ((j = (short)(j + 1)) < lgt) {
                        iptn <<= 2;
                        lptn <<= 4;
                        switch (seq.charAt(j)) {
                            case 'A': {
                                lptn |= 1L;
                                break;
                            }
                            case 'C': {
                                iptn |= 1;
                                lptn |= 2L;
                                break;
                            }
                            case 'G': {
                                iptn |= 2;
                                lptn |= 4L;
                                break;
                            }
                            case 'T': {
                                iptn |= 3;
                                lptn |= 8L;
                            }
                        }
                        bsfkmer.set(iptn &= imsk);
                        lts.add(new Long(lptn &= lmsk));
                    }
                }
                lfkmerLgt = o = lts.size();
                lfkmer = new long[o];
                while (--o >= 0) {
                    AlienTrimmer.lfkmer[AlienTrimmer.o] = lts.pollLast();
                }
                if (verbose != 0) {
                    System.out.println("  [fwd] Number of k-mers (k=" + k + "): " + lfkmer.length);
                }
                contaminant = new ArrayList();
                if (ralien.equals("no.alien")) {
                    try {
                        id = Integer.parseInt(ralien);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ralien = falien;
                    }
                }
                if (new File(ralien).exists()) {
                    rin = new BufferedReader(new FileReader(new File(ralien)));
                    while (true) {
                        try {
                            line = rin.readLine().trim();
                        }
                        catch (NullPointerException nullPointerException) {
                            rin.close();
                            break block429;
                        }
                        if (line.length() == 0 || line.startsWith("#") || line.startsWith("%") || line.startsWith(">")) continue;
                        contaminant.add(line);
                    }
                }
                o = ralien.length();
                while (--o >= 0) {
                    try {
                        id = Integer.parseInt("" + ralien.charAt(o));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("  incorrect alien sequence id (option -cr)");
                        System.exit(0);
                    }
                    switch (id) {
                        case 0: {
                            Collections.addAll(contaminant, ALIEN0);
                            break;
                        }
                        case 1: {
                            Collections.addAll(contaminant, ALIEN1);
                            break;
                        }
                        case 2: {
                            Collections.addAll(contaminant, ALIEN2);
                            break;
                        }
                        case 3: {
                            Collections.addAll(contaminant, ALIEN3);
                            break;
                        }
                        case 4: {
                            Collections.addAll(contaminant, ALIEN4);
                            break;
                        }
                        case 5: {
                            Collections.addAll(contaminant, ALIEN5);
                            break;
                        }
                        case 6: {
                            Collections.addAll(contaminant, ALIEN6);
                            break;
                        }
                        case 7: {
                            Collections.addAll(contaminant, ALIEN7);
                            break;
                        }
                        case 8: {
                            Collections.addAll(contaminant, ALIEN8);
                            break;
                        }
                        case 9: {
                            Collections.addAll(contaminant, ALIEN9);
                        }
                    }
                }
            }
            if (contaminant.size() == 0) {
                System.out.println("  no alien sequence (option -cr)");
                System.exit(0);
            }
            if (verbose != 0) {
                System.out.println("  [rev] Number of alien sequence(s): " + contaminant.size());
            }
            o = contaminant.size();
            while (--o >= 0) {
                sb = new StringBuffer(contaminant.get(o));
                i = (short)sb.length();
                if (i < k) {
                    contaminant.remove(o);
                    continue;
                }
                block308: while ((i = (short)(i - 1)) >= 0) {
                    switch (sb.charAt(i)) {
                        case 'A': 
                        case 'C': 
                        case 'G': 
                        case 'T': 
                        case 'a': 
                        case 'c': 
                        case 'g': 
                        case 't': {
                            continue block308;
                        }
                        case 'U': 
                        case 'u': {
                            sb.setCharAt(i, 'T');
                            contaminant.set(o, sb.toString());
                            continue block308;
                        }
                        case 'M': 
                        case 'm': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block308;
                        }
                        case 'R': 
                        case 'r': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block308;
                        }
                        case 'W': 
                        case 'w': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block308;
                        }
                        case 'S': 
                        case 's': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block308;
                        }
                        case 'Y': 
                        case 'y': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block308;
                        }
                        case 'K': 
                        case 'k': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block308;
                        }
                        case 'B': 
                        case 'b': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block308;
                        }
                        case 'D': 
                        case 'd': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block308;
                        }
                        case 'H': 
                        case 'h': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block308;
                        }
                        case 'V': 
                        case 'v': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block308;
                        }
                        case 'N': 
                        case 'X': 
                        case 'n': 
                        case 'x': {
                            contaminant.remove(o);
                            sb.setCharAt(i, 'A');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'C');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'G');
                            contaminant.add(sb.toString());
                            sb.setCharAt(i, 'T');
                            contaminant.add(sb.toString());
                            o = contaminant.size();
                            i = 0;
                            continue block308;
                        }
                    }
                    System.out.println("the following alien sequence contains at least one incorrect nucleotide (" + sb.charAt(i) + ") : " + sb.toString());
                    System.exit(1);
                }
            }
            o = contaminant.size();
            while (--o >= 0) {
                seq = contaminant.get(o);
                lgt = (short)seq.length();
                sb = new StringBuffer(lgt);
                while ((lgt = (short)(lgt - 1)) >= 0) {
                    switch (seq.charAt(lgt)) {
                        case 'A': 
                        case 'a': {
                            sb = sb.append('T');
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            sb = sb.append('G');
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            sb = sb.append('C');
                            break;
                        }
                        case 'T': 
                        case 't': {
                            sb = sb.append('A');
                        }
                    }
                }
                contaminant.add(sb.toString());
            }
            bsrkmer = new BitSet(imsk + 1);
            lts = new TreeSet();
            o = contaminant.size();
            while (--o >= 0) {
                seq = contaminant.get(o).toUpperCase();
                lgt = (short)seq.length();
                iptn = 0;
                lptn = 0L;
                j = (short)-1;
                while ((j = (short)(j + 1)) < k_1) {
                    iptn <<= 2;
                    lptn <<= 4;
                    switch (seq.charAt(j)) {
                        case 'A': {
                            lptn |= 1L;
                            break;
                        }
                        case 'C': {
                            iptn |= 1;
                            lptn |= 2L;
                            break;
                        }
                        case 'G': {
                            iptn |= 2;
                            lptn |= 4L;
                            break;
                        }
                        case 'T': {
                            iptn |= 3;
                            lptn |= 8L;
                        }
                    }
                }
                j = (short)(j - 1);
                while ((j = (short)(j + 1)) < lgt) {
                    iptn <<= 2;
                    lptn <<= 4;
                    switch (seq.charAt(j)) {
                        case 'A': {
                            lptn |= 1L;
                            break;
                        }
                        case 'C': {
                            iptn |= 1;
                            lptn |= 2L;
                            break;
                        }
                        case 'G': {
                            iptn |= 2;
                            lptn |= 4L;
                            break;
                        }
                        case 'T': {
                            iptn |= 3;
                            lptn |= 8L;
                        }
                    }
                    bsrkmer.set(iptn &= imsk);
                    lts.add(new Long(lptn &= lmsk));
                }
            }
            lrkmerLgt = o = lts.size();
            lrkmer = new long[o];
            while (--o >= 0) {
                AlienTrimmer.lrkmer[AlienTrimmer.o] = lts.pollLast();
            }
            if (verbose != 0) {
                System.out.println("  [rev] Number of k-mers (k=" + k + "): " + lrkmer.length);
            }
            lts = null;
            contaminant = null;
            sb = null;
            fin = new BufferedReader(new FileReader(finfile));
            fout = new BufferedWriter(new FileWriter(foutfile));
            rin = new BufferedReader(new FileReader(rinfile));
            rout = new BufferedWriter(new FileWriter(routfile));
            sout = new BufferedWriter(new FileWriter(soutfile));
            pcpt = 0;
            ftcpt = 0;
            rtcpt = 0;
            rtcpt = 0;
            rrcpt = 0;
            cpt = 0;
            score = new byte[51];
            block315: while (true) {
                try {
                    line = fin.readLine().trim();
                }
                catch (NullPointerException nullPointerException) {
                    fin.close();
                    rin.close();
                    break;
                }
                cpt = (byte)(cpt + 1);
                switch (cpt) {
                    case 1: {
                        fid1 = line;
                        break;
                    }
                    case 2: {
                        fseq = line.toUpperCase();
                        break;
                    }
                    case 3: {
                        fid2 = line;
                        break;
                    }
                    case 4: {
                        fqsc = line;
                    }
                }
                try {
                    line = rin.readLine().trim();
                }
                catch (NullPointerException nullPointerException) {
                    fin.close();
                    rin.close();
                    break;
                }
                switch (cpt) {
                    case 1: {
                        rid1 = line;
                        continue block315;
                    }
                    case 2: {
                        rseq = line.toUpperCase();
                        continue block315;
                    }
                    case 3: {
                        rid2 = line;
                        continue block315;
                    }
                    case 4: {
                        rqsc = line;
                        cpt = 0;
                    }
                }
                if (++pcpt % 1000000 == 0) {
                    Object[] objectArray = new Object[1];
                    cur = (System.currentTimeMillis() - t) / 1000L;
                    objectArray[0] = new Long(cur / 60L);
                    line = "0" + cur % 60L;
                    System.out.println("[" + String.format(Locale.US, "%02d", objectArray) + ":" + line.substring(line.length() - 2) + "]" + String.format(Locale.US, "%,12d", new Integer(pcpt)) + " read pairs processed:" + String.format(Locale.US, "%,12d", new Integer(ftcpt + rtcpt)) + " trimmed" + " (fwd:" + String.format(Locale.US, "%,12d", new Integer(ftcpt)) + "  rev:" + String.format(Locale.US, "%,12d", new Integer(rtcpt)) + ")" + String.format(Locale.US, "%,12d", new Integer(frcpt + rrcpt)) + " removed" + " (fwd:" + String.format(Locale.US, "%,12d", new Integer(frcpt)) + "  rev:" + String.format(Locale.US, "%,12d", new Integer(rrcpt)) + ")");
                }
                if ((lgt = (short)fseq.length()) >= score.length) {
                    lgt = (short)(lgt + 1);
                    score = new byte[lgt];
                    lgt = (short)(lgt - 1);
                } else {
                    Arrays.fill(score, (byte)0);
                }
                end = lgt;
                start = (short)-1;
                start0 = (short)-1;
                scount = 0;
                iptn = 0;
                i = (short)-1;
                j = (short)-1;
                b = 0;
                bq = 0;
                if (fseq.indexOf(78) != -1 || fseq.indexOf(110) != -1) {
                    lptn = 0L;
                    nptn = 0L;
                    n = 0;
                    while ((j = (short)(j + 1)) < k_1) {
                        iptn <<= 2;
                        lptn <<= 4;
                        nptn <<= 4;
                        switch (fseq.charAt(j)) {
                            case 'A': 
                            case 'a': {
                                lptn |= 1L;
                                nptn |= 1L;
                                break;
                            }
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                lptn |= 2L;
                                nptn |= 2L;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                lptn |= 4L;
                                nptn |= 4L;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                                lptn |= 8L;
                                nptn |= 8L;
                                break;
                            }
                            default: {
                                n = k;
                                nptn |= 0xFL;
                            }
                        }
                        n = (short)(n - 1);
                    }
                    block317: while (j < lgt) {
                        i = (short)(i + 1);
                        score[i] = (byte)(score[i] + b);
                        b = score[i];
                        bq = fqsc.charAt(i) < qmin ? (byte)1 : 0;
                        iptn <<= 2;
                        lptn <<= 4;
                        nptn <<= 4;
                        switch (fseq.charAt(j)) {
                            case 'A': 
                            case 'a': {
                                lptn |= 1L;
                                nptn |= 1L;
                                break;
                            }
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                lptn |= 2L;
                                nptn |= 2L;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                lptn |= 4L;
                                nptn |= 4L;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                                lptn |= 8L;
                                nptn |= 8L;
                                break;
                            }
                            default: {
                                n = k;
                                nptn |= 0xFL;
                            }
                        }
                        n = (short)(n - 1);
                        switch (n < 0 ? 0 : 1) {
                            case 0: {
                                if (!bsfkmer.get(iptn &= imsk)) break;
                                AlienTrimmer.score[AlienTrimmer.i] = b = (byte)(b + 1);
                                short s = i;
                                score[s] = (byte)(score[s] + bq);
                                j = (short)(j + 1);
                                score[j] = (byte)(score[j] - 1);
                                scount = (short)(scount + 2);
                                short s6 = start0 = start0 < 0 ? (short)(2 * i) : start0;
                                start = j >= start0 && scount + k2 >= j ? (start < 0 ? j : (i - start <= mismatch ? j : (start = (short)(start + 1)))) : (start = (short)(start + 1));
                                start = (short)(start - 1);
                                continue block317;
                            }
                            default: {
                                id = Arrays.binarySearch(lfkmer, lptn &= lmsk);
                                ++id;
                                id = -id;
                                --id;
                                o = Arrays.binarySearch(lfkmer, nptn &= lmsk);
                                ++o;
                                o = -o;
                                while (++id < o) {
                                    lkm = lfkmer[id];
                                    lpt = lptn;
                                    if (lkm != (lkm |= lpt)) continue;
                                }
                                if (id == o) break;
                                AlienTrimmer.score[AlienTrimmer.i] = b = (byte)(b + 1);
                                short s = i;
                                score[s] = (byte)(score[s] + bq);
                                j = (short)(j + 1);
                                score[j] = (byte)(score[j] - 1);
                                scount = (short)(scount + 2);
                                short s7 = start0 = start0 < 0 ? (short)(2 * i) : start0;
                                start = j >= start0 && scount + k2 >= j ? (start < 0 ? j : (i - start <= mismatch ? j : (start = (short)(start + 1)))) : (start = (short)(start + 1));
                                start = (short)(start - 1);
                                continue block317;
                            }
                        }
                        AlienTrimmer.score[AlienTrimmer.i] = b < 0 ? (byte)0 : b;
                        b = AlienTrimmer.score[AlienTrimmer.i];
                        j = (short)(j + 1);
                        short s = i;
                        score[s] = (byte)(score[s] + bq);
                        if (score[s] == 0) continue;
                        scount = (short)(scount + 2);
                        start0 = start0 < 0 ? (short)(2 * i) : start0;
                        start = start < i && (x = i) - start <= mismatch && (x = (short)(x + 1)) >= start0 && scount > x ? i : start;
                        end = i;
                    }
                } else {
                    while ((j = (short)(j + 1)) < k_1) {
                        iptn <<= 2;
                        switch (fseq.charAt(j)) {
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                            }
                        }
                    }
                    while (j < lgt) {
                        i = (short)(i + 1);
                        score[i] = (byte)(score[i] + b);
                        b = score[i];
                        bq = fqsc.charAt(i) < qmin ? (byte)1 : 0;
                        iptn <<= 2;
                        switch (fseq.charAt(j)) {
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                            }
                        }
                        if (bsfkmer.get(iptn &= imsk)) {
                            AlienTrimmer.score[AlienTrimmer.i] = b = (byte)(b + 1);
                            short s = i;
                            score[s] = (byte)(score[s] + bq);
                            j = (short)(j + 1);
                            score[j] = (byte)(score[j] - 1);
                            scount = (short)(scount + 2);
                            short s8 = start0 = start0 < 0 ? (short)(2 * i) : start0;
                            start = j >= start0 && scount + k2 >= j ? (start < 0 ? j : (i - start <= mismatch ? j : (start = (short)(start + 1)))) : (start = (short)(start + 1));
                            start = (short)(start - 1);
                            continue;
                        }
                        AlienTrimmer.score[AlienTrimmer.i] = b < 0 ? (byte)0 : b;
                        b = AlienTrimmer.score[AlienTrimmer.i];
                        j = (short)(j + 1);
                        short s = i;
                        score[s] = (byte)(score[s] + bq);
                        if (score[s] == 0) continue;
                        scount = (short)(scount + 2);
                        start0 = start0 < 0 ? (short)(2 * i) : start0;
                        start = start < i && (x = i) - start <= mismatch && (x = (short)(x + 1)) >= start0 && scount > x ? i : start;
                        end = i;
                    }
                }
                while ((i = (short)(i + 1)) < lgt) {
                    short s = i;
                    byte by = (byte)(score[s] + b);
                    score[s] = by;
                    b = by;
                    bq = fqsc.charAt(i) < qmin ? (byte)1 : 0;
                    AlienTrimmer.score[AlienTrimmer.i] = b < 0 ? (byte)0 : b;
                    b = AlienTrimmer.score[AlienTrimmer.i];
                    short s9 = i;
                    score[s9] = (byte)(score[s9] + bq);
                    if (score[s9] == 0) continue;
                    scount = (short)(scount + 2);
                    start0 = start0 < 0 ? (short)(2 * i) : start0;
                    start = start < i && (x = i) - start <= mismatch && (x = (short)(x + 1)) >= start0 && scount > x ? i : start;
                    end = i;
                }
                int n = start = start0 > 0 && start0 >= lgt - start ? -1 : start;
                if (start0 >= 0 && lgt - start - 1 >= minLgt) {
                    end0 = end;
                    end = lgt;
                    i = j = end0;
                    i = (short)(i - k);
                    i = (short)(i + 1);
                    end0 = (short)(end0 + 1);
                    end0 = (short)(end0 * 2);
                    scount = (short)2;
                    end = end > j && end - j <= mismatch && end0 - j >= lgt && scount >= lgt - j ? j : end;
                    start0 = (short)(start0 / 2);
                    o = start0 > start ? start0 : start;
                    while (true) {
                        x = j = (short)(j - 1);
                        if (j < o) break;
                        i = (short)(i - 1);
                        b = score[j];
                        if (b == 0) continue;
                        scount = (short)(scount + 2);
                        end = i >= 0 && b >= 2 && (b = (byte)(b - 1)) == score[x = (short)(x + 1)] && score[i] != 0 ? (end0 - i >= lgt && scount + k2 >= lgt - i ? (end == lgt ? i : (end - j <= mismatch ? i : end)) : end) : end;
                        end = end > j && end - j <= mismatch && end0 - j >= lgt && scount >= lgt - j ? j : end;
                    }
                    end = start < end ? (end = (short)(end - 1)) : start;
                    end = (short)(end + 1);
                } else {
                    end = lgt;
                }
                if (verbose != 0 && (start != -1 || end != lgt)) {
                    System.out.println(fid1);
                    System.out.println(fseq);
                    o = -1;
                    while (++o < lgt) {
                        b = score[o];
                        System.out.print(b == 0 ? " " : (b < 10 ? Byte.valueOf(b) : (b == 10 ? "0" : "" + (char)(54 + b))));
                    }
                    System.out.println("");
                    o = -1;
                    while (++o <= start) {
                        System.out.print(">");
                    }
                    --o;
                    while (++o < end) {
                        System.out.print(" ");
                    }
                    --o;
                    while (++o < lgt) {
                        System.out.print("<");
                    }
                    System.out.println("");
                    System.out.println("");
                }
                l = end;
                l = (short)(l - start);
                scount = l = (short)(l - 1);
                if (prop != 0) {
                    i = start;
                    while ((i = (short)(i + 1)) < end) {
                        scount = (short)(scount - (score[i] == 1 ? (short)1 : 0));
                    }
                }
                if (l < minLgt || 100 * scount < prop * l) {
                    ++frcpt;
                    fseq = "";
                    fqsc = "";
                } else if (start != -1 || end != lgt) {
                    ++ftcpt;
                    start = (short)(start + 1);
                    fseq = fseq.substring(start, end);
                    short s = start;
                    start = (short)(s - 1);
                    fqsc = fqsc.substring(s, end);
                }
                lgt = (short)rseq.length();
                if (lgt >= score.length) {
                    lgt = (short)(lgt + 1);
                    score = new byte[lgt];
                    lgt = (short)(lgt - 1);
                } else {
                    Arrays.fill(score, (byte)0);
                }
                end = lgt;
                start = (short)-1;
                start0 = (short)-1;
                scount = 0;
                iptn = 0;
                i = (short)-1;
                j = (short)-1;
                b = 0;
                bq = 0;
                if (rseq.indexOf(78) != -1 || rseq.indexOf(110) != -1) {
                    lptn = 0L;
                    nptn = 0L;
                    AlienTrimmer.n = 0;
                    while ((j = (short)(j + 1)) < k_1) {
                        iptn <<= 2;
                        lptn <<= 4;
                        nptn <<= 4;
                        switch (rseq.charAt(j)) {
                            case 'A': 
                            case 'a': {
                                lptn |= 1L;
                                nptn |= 1L;
                                break;
                            }
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                lptn |= 2L;
                                nptn |= 2L;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                lptn |= 4L;
                                nptn |= 4L;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                                lptn |= 8L;
                                nptn |= 8L;
                                break;
                            }
                            default: {
                                AlienTrimmer.n = k;
                                nptn |= 0xFL;
                            }
                        }
                        AlienTrimmer.n = (short)(AlienTrimmer.n - 1);
                    }
                    block329: while (j < lgt) {
                        i = (short)(i + 1);
                        score[i] = (byte)(score[i] + b);
                        b = score[i];
                        bq = rqsc.charAt(i) < qmin ? (byte)1 : 0;
                        iptn <<= 2;
                        lptn <<= 4;
                        nptn <<= 4;
                        switch (rseq.charAt(j)) {
                            case 'A': 
                            case 'a': {
                                lptn |= 1L;
                                nptn |= 1L;
                                break;
                            }
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                lptn |= 2L;
                                nptn |= 2L;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                lptn |= 4L;
                                nptn |= 4L;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                                lptn |= 8L;
                                nptn |= 8L;
                                break;
                            }
                            default: {
                                AlienTrimmer.n = k;
                                nptn |= 0xFL;
                            }
                        }
                        AlienTrimmer.n = (short)(AlienTrimmer.n - 1);
                        switch (AlienTrimmer.n < 0 ? 0 : 1) {
                            case 0: {
                                if (!bsrkmer.get(iptn &= imsk)) break;
                                AlienTrimmer.score[AlienTrimmer.i] = b = (byte)(b + 1);
                                short s = i;
                                score[s] = (byte)(score[s] + bq);
                                j = (short)(j + 1);
                                score[j] = (byte)(score[j] - 1);
                                scount = (short)(scount + 2);
                                short s10 = start0 = start0 < 0 ? (short)(2 * i) : start0;
                                start = j >= start0 && scount + k2 >= j ? (start < 0 ? j : (i - start <= mismatch ? j : (start = (short)(start + 1)))) : (start = (short)(start + 1));
                                start = (short)(start - 1);
                                continue block329;
                            }
                            default: {
                                id = Arrays.binarySearch(lrkmer, lptn &= lmsk);
                                ++id;
                                id = -id;
                                --id;
                                o = Arrays.binarySearch(lrkmer, nptn &= lmsk);
                                ++o;
                                o = -o;
                                while (++id < o) {
                                    lkm = lrkmer[id];
                                    lpt = lptn;
                                    if (lkm != (lkm |= lpt)) continue;
                                }
                                if (id == o) break;
                                AlienTrimmer.score[AlienTrimmer.i] = b = (byte)(b + 1);
                                short s = i;
                                score[s] = (byte)(score[s] + bq);
                                j = (short)(j + 1);
                                score[j] = (byte)(score[j] - 1);
                                scount = (short)(scount + 2);
                                short s11 = start0 = start0 < 0 ? (short)(2 * i) : start0;
                                start = j >= start0 && scount + k2 >= j ? (start < 0 ? j : (i - start <= mismatch ? j : (start = (short)(start + 1)))) : (start = (short)(start + 1));
                                start = (short)(start - 1);
                                continue block329;
                            }
                        }
                        AlienTrimmer.score[AlienTrimmer.i] = b < 0 ? (byte)0 : b;
                        b = AlienTrimmer.score[AlienTrimmer.i];
                        j = (short)(j + 1);
                        short s = i;
                        score[s] = (byte)(score[s] + bq);
                        if (score[s] == 0) continue;
                        scount = (short)(scount + 2);
                        start0 = start0 < 0 ? (short)(2 * i) : start0;
                        start = start < i && (x = i) - start <= mismatch && (x = (short)(x + 1)) >= start0 && scount > x ? i : start;
                        end = i;
                    }
                } else {
                    while ((j = (short)(j + 1)) < k_1) {
                        iptn <<= 2;
                        switch (rseq.charAt(j)) {
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                            }
                        }
                    }
                    while (j < lgt) {
                        i = (short)(i + 1);
                        score[i] = (byte)(score[i] + b);
                        b = score[i];
                        bq = rqsc.charAt(i) < qmin ? (byte)1 : 0;
                        iptn <<= 2;
                        switch (rseq.charAt(j)) {
                            case 'C': 
                            case 'c': {
                                iptn |= 1;
                                break;
                            }
                            case 'G': 
                            case 'g': {
                                iptn |= 2;
                                break;
                            }
                            case 'T': 
                            case 't': {
                                iptn |= 3;
                            }
                        }
                        if (bsrkmer.get(iptn &= imsk)) {
                            AlienTrimmer.score[AlienTrimmer.i] = b = (byte)(b + 1);
                            short s = i;
                            score[s] = (byte)(score[s] + bq);
                            j = (short)(j + 1);
                            score[j] = (byte)(score[j] - 1);
                            scount = (short)(scount + 2);
                            short s12 = start0 = start0 < 0 ? (short)(2 * i) : start0;
                            start = j >= start0 && scount + k2 >= j ? (start < 0 ? j : (i - start <= mismatch ? j : (start = (short)(start + 1)))) : (start = (short)(start + 1));
                            start = (short)(start - 1);
                            continue;
                        }
                        AlienTrimmer.score[AlienTrimmer.i] = b < 0 ? (byte)0 : b;
                        b = AlienTrimmer.score[AlienTrimmer.i];
                        j = (short)(j + 1);
                        short s = i;
                        score[s] = (byte)(score[s] + bq);
                        if (score[s] == 0) continue;
                        scount = (short)(scount + 2);
                        start0 = start0 < 0 ? (short)(2 * i) : start0;
                        start = start < i && (x = i) - start <= mismatch && (x = (short)(x + 1)) >= start0 && scount > x ? i : start;
                        end = i;
                    }
                }
                while ((i = (short)(i + 1)) < lgt) {
                    short s = i;
                    byte by = (byte)(score[s] + b);
                    score[s] = by;
                    b = by;
                    bq = rqsc.charAt(i) < qmin ? (byte)1 : 0;
                    AlienTrimmer.score[AlienTrimmer.i] = b < 0 ? (byte)0 : b;
                    b = AlienTrimmer.score[AlienTrimmer.i];
                    short s13 = i;
                    score[s13] = (byte)(score[s13] + bq);
                    if (score[s13] == 0) continue;
                    scount = (short)(scount + 2);
                    start0 = start0 < 0 ? (short)(2 * i) : start0;
                    start = start < i && (x = i) - start <= mismatch && (x = (short)(x + 1)) >= start0 && scount > x ? i : start;
                    end = i;
                }
                int n2 = start = start0 > 0 && start0 >= lgt - start ? -1 : start;
                if (start0 >= 0 && lgt - start - 1 >= minLgt) {
                    end0 = end;
                    end = lgt;
                    i = j = end0;
                    i = (short)(i - k);
                    i = (short)(i + 1);
                    end0 = (short)(end0 + 1);
                    end0 = (short)(end0 * 2);
                    scount = (short)2;
                    end = end > j && end - j <= mismatch && end0 - j >= lgt && scount >= lgt - j ? j : end;
                    start0 = (short)(start0 / 2);
                    o = start0 > start ? start0 : start;
                    while (true) {
                        x = j = (short)(j - 1);
                        if (j < o) break;
                        i = (short)(i - 1);
                        b = score[j];
                        if (b == 0) continue;
                        scount = (short)(scount + 2);
                        end = i >= 0 && b >= 2 && (b = (byte)(b - 1)) == score[x = (short)(x + 1)] && score[i] != 0 ? (end0 - i >= lgt && scount + k2 >= lgt - i ? (end == lgt ? i : (end - j <= mismatch ? i : end)) : end) : end;
                        end = end > j && end - j <= mismatch && end0 - j >= lgt && scount >= lgt - j ? j : end;
                    }
                    end = start < end ? (end = (short)(end - 1)) : start;
                    end = (short)(end + 1);
                } else {
                    end = lgt;
                }
                if (verbose != 0 && (start != -1 || end != lgt)) {
                    System.out.println(rid1);
                    System.out.println(rseq);
                    o = -1;
                    while (++o < lgt) {
                        b = score[o];
                        System.out.print(b == 0 ? " " : (b < 10 ? Byte.valueOf(b) : (b == 10 ? "0" : "" + (char)(54 + b))));
                    }
                    System.out.println("");
                    o = -1;
                    while (++o <= start) {
                        System.out.print(">");
                    }
                    --o;
                    while (++o < end) {
                        System.out.print(" ");
                    }
                    --o;
                    while (++o < lgt) {
                        System.out.print("<");
                    }
                    System.out.println("");
                    System.out.println("");
                }
                l = end;
                l = (short)(l - start);
                scount = l = (short)(l - 1);
                if (prop != 0) {
                    i = start;
                    while ((i = (short)(i + 1)) < end) {
                        scount = (short)(scount - (score[i] == 1 ? (short)1 : 0));
                    }
                }
                if (l < minLgt || 100 * scount < prop * l) {
                    ++rrcpt;
                    rseq = "";
                    rqsc = "";
                } else if (start != -1 || end != lgt) {
                    ++rtcpt;
                    start = (short)(start + 1);
                    rseq = rseq.substring(start, end);
                    short s = start;
                    start = (short)(s - 1);
                    rqsc = rqsc.substring(s, end);
                }
                if (fseq.length() >= minLgt && rseq.length() >= minLgt) {
                    fout.write(fid1);
                    fout.newLine();
                    fout.write(fseq);
                    fout.newLine();
                    fout.write(fid2);
                    fout.newLine();
                    fout.write(fqsc);
                    fout.newLine();
                    rout.write(rid1);
                    rout.newLine();
                    rout.write(rseq);
                    rout.newLine();
                    rout.write(rid2);
                    rout.newLine();
                    rout.write(rqsc);
                    rout.newLine();
                    continue;
                }
                if (fseq.length() >= minLgt && rseq.length() < minLgt) {
                    sout.write(fid1);
                    sout.newLine();
                    sout.write(fseq);
                    sout.newLine();
                    sout.write(fid2);
                    sout.newLine();
                    sout.write(fqsc);
                    sout.newLine();
                    continue;
                }
                if (fseq.length() >= minLgt || rseq.length() < minLgt) continue;
                sout.write(rid1);
                sout.newLine();
                sout.write(rseq);
                sout.newLine();
                sout.write(rid2);
                sout.newLine();
                sout.write(rqsc);
                sout.newLine();
            }
            fout.close();
            rout.close();
            sout.close();
            Object[] objectArray = new Object[1];
            cur = (System.currentTimeMillis() - t) / 1000L;
            objectArray[0] = new Long(cur / 60L);
            line = "0" + cur % 60L;
            System.out.println("[" + String.format(Locale.US, "%02d", objectArray) + ":" + line.substring(line.length() - 2) + "]" + String.format(Locale.US, "%,12d", new Integer(pcpt)) + " read pairs processed:" + String.format(Locale.US, "%,12d", new Integer(ftcpt + rtcpt)) + " trimmed" + " (fwd:" + String.format(Locale.US, "%,12d", new Integer(ftcpt)) + "  rev:" + String.format(Locale.US, "%,12d", new Integer(rtcpt)) + ")" + String.format(Locale.US, "%,12d", new Integer(frcpt + rrcpt)) + " removed" + " (fwd:" + String.format(Locale.US, "%,12d", new Integer(frcpt)) + "  rev:" + String.format(Locale.US, "%,12d", new Integer(rrcpt)) + ")");
        }
    }
}

