/*
 * Decompiled with CFR 0.152.
 */
package jap;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimumSpaningTree {
    private TreeSet<DissimilarityEntry> dissimilarityTuple;
    private TreeSet<DissimilarityEntry> minimumSpaningTree;
    private Comparator<Object> comparator = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            if (!(object instanceof DissimilarityEntry) || !(object2 instanceof DissimilarityEntry)) {
                throw new ClassCastException();
            }
            if (((DissimilarityEntry)object).distance < ((DissimilarityEntry)object2).distance) {
                return -1;
            }
            if (((DissimilarityEntry)object).distance > ((DissimilarityEntry)object2).distance) {
                return 1;
            }
            if (((DissimilarityEntry)object).label1 < ((DissimilarityEntry)object2).label1) {
                return -1;
            }
            if (((DissimilarityEntry)object).label1 > ((DissimilarityEntry)object2).label1) {
                return 1;
            }
            if (((DissimilarityEntry)object).label2 < ((DissimilarityEntry)object2).label2) {
                return -1;
            }
            if (((DissimilarityEntry)object).label2 > ((DissimilarityEntry)object2).label2) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object, Object object2) {
            if (!(object instanceof DissimilarityEntry) || !(object2 instanceof DissimilarityEntry)) {
                throw new ClassCastException();
            }
            return ((DissimilarityEntry)object).distance == ((DissimilarityEntry)object2).distance && ((DissimilarityEntry)object).label1 == ((DissimilarityEntry)object2).label1 && ((DissimilarityEntry)object).label2 == ((DissimilarityEntry)object2).label2;
        }
    };
    private DissimilarityEntry de;
    private ArrayList<Integer> partition;
    private ArrayList<Integer> partitionName;
    private ArrayList<Integer> bipartition1;
    private ArrayList<Integer> bipartition2;
    private int i;
    private int j;
    private int p;
    private int k;
    private int pi;
    private int pj;

    public MinimumSpaningTree(Matrix matrix) {
        this.dissimilarityTuple = new TreeSet<Object>(this.comparator);
        this.k = Math.min(matrix.getRowDimension(), matrix.getColumnDimension());
        this.i = -1;
        while (++this.i < this.k) {
            this.j = -1;
            while (++this.j < this.k) {
                this.dissimilarityTuple.add(new DissimilarityEntry(this.i, this.j, (matrix.get(this.i, this.j) + matrix.get(this.j, this.i)) / 2.0));
            }
        }
        this.minimumSpaningTree = new TreeSet<Object>(this.comparator);
        this.bipartition1 = new ArrayList(0);
        this.bipartition2 = new ArrayList(0);
        this.partition = new ArrayList(0);
        this.partitionName = new ArrayList(0);
        this.p = -1;
        while (this.minimumSpaningTree.size() < this.k - 1) {
            this.de = this.dissimilarityTuple.first();
            if (!this.partition.contains(this.de.label1) && !this.partition.contains(this.de.label2)) {
                this.partition.add(new Integer(this.de.label1));
                this.partitionName.add(new Integer(++this.p));
                this.partition.add(new Integer(this.de.label2));
                this.partitionName.add(new Integer(this.p));
                this.minimumSpaningTree.add(this.de);
            } else if (this.partition.contains(this.de.label1) && !this.partition.contains(this.de.label2)) {
                this.partition.add(new Integer(this.de.label2));
                this.partitionName.add(this.partitionName.get(this.partition.indexOf(this.de.label1)));
                this.minimumSpaningTree.add(this.de);
            } else if (!this.partition.contains(this.de.label1) && this.partition.contains(this.de.label2)) {
                this.partition.add(new Integer(this.de.label1));
                this.partitionName.add(this.partitionName.get(this.partition.indexOf(this.de.label2)));
                this.minimumSpaningTree.add(this.de);
            } else {
                this.pi = this.partitionName.get(this.partition.indexOf(this.de.label1));
                this.pj = this.partitionName.get(this.partition.indexOf(this.de.label2));
                if (this.pi != this.pj) {
                    if (this.minimumSpaningTree.size() == this.k - 2) {
                        this.i = -1;
                        while (++this.i < this.partitionName.size()) {
                            if (this.partitionName.get(this.i) == this.pi) {
                                this.bipartition1.add(this.partition.get(this.i));
                                continue;
                            }
                            this.bipartition2.add(this.partition.get(this.i));
                        }
                    } else {
                        this.i = -1;
                        while (++this.i < this.partitionName.size()) {
                            if (this.partitionName.get(this.i) != this.pi && this.partitionName.get(this.i) != this.pj) continue;
                            this.partitionName.set(this.i, new Integer(Math.min(this.pi, this.pj)));
                        }
                    }
                    this.minimumSpaningTree.add(this.de);
                }
            }
            this.dissimilarityTuple.remove(this.de);
        }
        this.partition = null;
        this.partitionName = null;
        this.dissimilarityTuple = null;
    }

    public ArrayList<Integer> getFirstBipartition() {
        return this.bipartition1;
    }

    public ArrayList<Integer> getSecondBipartition() {
        return this.bipartition2;
    }

    public TreeSet<DissimilarityEntry> getMinimumSpaningTree() {
        return this.minimumSpaningTree;
    }

    private class DissimilarityEntry {
        public int label1;
        public int label2;
        public double distance;

        public DissimilarityEntry(int n, int n2, double d) {
            this.label1 = n;
            this.label2 = n2;
            this.distance = d;
        }
    }
}

