/*
 * Decompiled with CFR 0.152.
 */
package jap;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticalTest {
    private static int size;
    private static ArrayList<WilcoxonTuple> wt_array;
    private static ArrayList<Double> rank;
    private static ArrayList<Double> distribution;
    private static ArrayList<Double> array_temp;
    private static double n;
    private static double wp;
    private static double wm;
    private static double w;
    private static double pValue;
    private static double r;
    private static double norm;
    private static WilcoxonTuple wt;
    private static double snd_epsilon;
    private static double snd_z;
    private static double snd_p;
    private static double snd_f;
    private static double snd_ff;
    private static int st_plus;
    private static int st_minus;
    private static int st_n;
    private static int st_k;
    private static double st_f;
    private static double st_ff;
    private static double st_p;
    private static final double[] LANCZOS;
    private static double lg_z;
    private static double lg_f;
    private static double lg_ff;
    private static double ig_k;
    private static double ig_f;
    private static double ig_s;
    private static double ig_b;
    private static double ig_c;
    private static double ig_d;
    private static double ig_an;
    private static double k2d_p;
    private static double k2d_cte1;
    private static double k2d_cte2;
    private static double k2d_cte3;
    private static double k2d_f;
    private static double k2d_ff;
    private static double k2d_s;
    private static double k2d_z;
    private static double k2d_epsilon;
    private static int i;
    private static int j;
    private static int b;

    private StatisticalTest() {
    }

    public static double getWilcoxonMatchedPairsSignedRanksPvalue(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        size = Math.min(arrayList.size(), arrayList2.size());
        if (size == 0) {
            return -1.0;
        }
        wt_array = new ArrayList(0);
        n = 0.0;
        i = -1;
        while (++i < size) {
            wt = new WilcoxonTuple(arrayList.get(i), arrayList2.get(i));
            if (StatisticalTest.wt.sign == 0.0) continue;
            wt_array.add(wt);
            n = 1.0;
            break;
        }
        while (++i < size) {
            block20: {
                wt = new WilcoxonTuple(arrayList.get(i), arrayList2.get(i));
                if (StatisticalTest.wt.sign == 0.0) continue;
                if (StatisticalTest.wt.absoluteDifference >= StatisticalTest.wt_array.get((int)((int)(StatisticalTest.n - 1.0))).absoluteDifference) {
                    wt_array.add(wt);
                } else {
                    j = -1;
                    do {
                        int n;
                        ++j;
                        if (!((double)n < StatisticalTest.n)) break block20;
                    } while (!(StatisticalTest.wt.absoluteDifference < StatisticalTest.wt_array.get((int)StatisticalTest.j).absoluteDifference));
                    wt_array.add(j, wt);
                }
            }
            n += 1.0;
        }
        rank = new ArrayList((int)n);
        i = 0;
        while (true) {
            int n;
            ++i;
            if (!((double)n <= StatisticalTest.n)) break;
            rank.add(new Double(i));
        }
        i = -1;
        while (true) {
            int n;
            int n2;
            ++i;
            if (!((double)n2 < StatisticalTest.n)) break;
            wt = wt_array.get(i);
            j = i;
            while ((double)n < StatisticalTest.n && StatisticalTest.wt_array.get((int)(++StatisticalTest.j)).absoluteDifference == StatisticalTest.wt.absoluteDifference) {
            }
            if (--j <= i) continue;
            r = 0.0;
            size = 0;
            b = i - 1;
            while (++b <= j) {
                r += rank.get(b).doubleValue();
                ++size;
            }
            r /= (double)size;
            b = i - 1;
            while (++b <= j) {
                rank.set(b, new Double(r));
            }
            i = j;
        }
        wp = 0.0;
        wm = 0.0;
        i = -1;
        while (true) {
            int n;
            ++i;
            if (!((double)n < StatisticalTest.n)) break;
            if (StatisticalTest.wt_array.get((int)StatisticalTest.i).sign < 0.0) {
                wm += rank.get(i).doubleValue();
                continue;
            }
            wp += rank.get(i).doubleValue();
        }
        pValue = 0.0;
        if (n <= 50.0) {
            distribution = new ArrayList(0);
            distribution.add(new Double(1.0));
            distribution.add(new Double(1.0));
            norm = 2.0;
            b = 1;
            block9: while (true) {
                int n;
                ++b;
                if (!((double)n <= StatisticalTest.n)) break;
                size = b * (b + 1) / 2 + 1;
                norm *= 2.0;
                array_temp = new ArrayList(0);
                i = -1;
                while (++i < distribution.size()) {
                    array_temp.add(distribution.get(i));
                }
                while (++i <= size) {
                    array_temp.add(new Double(0.0));
                    distribution.add(new Double(0.0));
                }
                i = -1;
                while (true) {
                    if (++i >= size) continue block9;
                    distribution.set(i, new Double(array_temp.get(i) + array_temp.get(size - i - 1)));
                }
                break;
            }
            array_temp = null;
            w = Math.min(wm, wp);
            i = -1;
            while (true) {
                int n;
                ++i;
                if (!((double)n <= w)) break;
                pValue += distribution.get(i).doubleValue();
            }
            pValue = 2.0 * pValue / norm;
        } else {
            w = Math.max(wm, wp);
            pValue = StatisticalTest.getStandardNormalDistributionPvalue((w - 0.5 - n * (n + 1.0) / 4.0) / Math.sqrt(n * (n + 1.0) * (2.0 * n + 1.0) / 24.0));
        }
        return pValue;
    }

    public static double getSignTestPvalue(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        size = Math.min(arrayList.size(), arrayList2.size());
        if (size == 0) {
            return -1.0;
        }
        st_plus = 0;
        st_minus = 0;
        i = -1;
        while (++i < size) {
            if (arrayList.get(i) < arrayList2.get(i)) {
                ++st_minus;
                continue;
            }
            if (!(arrayList.get(i) > arrayList2.get(i))) continue;
            ++st_plus;
        }
        if (st_plus == 0 && st_minus == 0) {
            return 1.0;
        }
        st_n = st_plus + st_minus;
        st_k = Math.min(st_plus, st_minus);
        st_p = st_f = 1.0;
        i = 1;
        while (i <= st_k) {
            st_f = st_f * (double)st_n-- / (double)i++;
            st_p += st_f;
        }
        if (!Double.isNaN(st_p /= Math.pow(2.0, st_plus + st_minus - 1)) && !Double.isInfinite(st_p)) {
            return st_p;
        }
        return StatisticalTest.getStandardNormalDistributionPvalue((double)(Math.abs(st_minus - st_plus) - 1) / Math.sqrt(st_plus + st_minus));
    }

    public static double getStandardNormalDistributionPvalue(double d) {
        snd_epsilon = 1.0E-5;
        snd_z = d;
        snd_p = 0.0;
        snd_f = Math.exp(-0.5 * snd_z * snd_z);
        while (snd_z < 5.0 && !Double.isNaN(snd_ff = Math.exp(-0.5 * (snd_z += snd_epsilon) * snd_z)) && !Double.isInfinite(snd_ff)) {
            snd_p += snd_f + snd_ff;
            snd_f = snd_ff;
        }
        return snd_p *= snd_epsilon / Math.sqrt(Math.PI * 2);
    }

    public static double getLnGammaFunction(double d) {
        if (d == 0.0) {
            return -1.0;
        }
        if (d == 1.0) {
            return 0.0;
        }
        lg_z = d;
        lg_ff = (lg_z -= 1.0) + 5.5;
        lg_ff -= (lg_z + 0.5) * Math.log(lg_ff);
        i = -1;
        lg_f = 1.0;
        while (++i < 6) {
            lg_f += LANCZOS[i] / (lg_z += 1.0);
        }
        return Math.log(2.5066282746310007 * lg_f) - lg_ff;
    }

    public static double getIncompleteGammaFunction(double d, double d2) {
        if (d <= 0.0 || d2 < 0.0) {
            return -1.0;
        }
        if (d2 < d + 1.0) {
            ig_k = d;
            ig_s = ig_f = 1.0 / ig_k;
            while (!(Double.isNaN(ig_f *= d2 / (ig_k += 1.0)) || Double.isInfinite(ig_f) || ig_f < 1.0E-9 || ig_f < 0.0)) {
                ig_s += ig_f;
            }
            return ig_s * Math.exp(d * Math.log(d2) - d2 - StatisticalTest.getLnGammaFunction(d));
        }
        ig_b = d2 + 1.0 - d;
        ig_c = Double.MAX_VALUE;
        ig_s = ig_d = 1.0 / ig_b;
        i = 0;
        while (true) {
            ig_an = (double)(++i) * (d - (double)i);
            ig_b += 1.0;
            if (Math.abs(ig_d = ig_an * ig_d + (ig_b += 1.0)) < (double)1.4E-45f) {
                ig_d = Double.MIN_VALUE;
            }
            if (Math.abs(ig_c = ig_an / ig_c + ig_b) < (double)1.4E-45f) {
                ig_c = 1.4E-45f;
            }
            if (Double.isNaN(ig_f = (ig_d = 1.0 / ig_d) * ig_c) || Double.isInfinite(ig_f) || ig_f == 1.0) break;
            ig_s *= ig_f;
        }
        return 1.0 - ig_s * Math.exp(d * Math.log(d2) - d2 - StatisticalTest.getLnGammaFunction(d));
    }

    public static double getKhi2Pvalue(double d, int n) {
        if (d * (double)n == 0.0) {
            return 1.0;
        }
        k2d_p = 1.0 - StatisticalTest.getIncompleteGammaFunction((double)n / 2.0, d / 2.0);
        if (k2d_p > 1.0) {
            System.out.println(d + "(" + n + ")=" + k2d_p);
        }
        return k2d_p;
    }

    public static double getKhi2Pvalue_(double d, int n) {
        if (d == 0.0 || d < 1.0 && n >= 10) {
            return 0.9999999999;
        }
        if (n <= 35) {
            if (n % 2 == 0) {
                k2d_cte1 = d / 2.0;
                k2d_p = k2d_cte2 = Math.exp(-k2d_cte1);
                b = n / 2;
                k2d_f = 1.0;
                i = 0;
                while (++i < b && !Double.isNaN(k2d_ff = (k2d_f *= k2d_cte1) * k2d_cte2 / StatisticalTest.getGammaFunctionValue(i + 1)) && !Double.isInfinite(k2d_ff)) {
                    k2d_p += k2d_ff;
                }
                return k2d_p;
            }
            k2d_cte1 = d / 2.0;
            k2d_cte2 = (double)n / 2.0;
            i = 51;
            k2d_p = 0.0;
            while (--i > 0) {
                if (i % 2 == 0) {
                    k2d_p = (double)(i / 2) * k2d_cte1 / (k2d_cte2 + (double)i + k2d_p);
                    continue;
                }
                k2d_p = -(k2d_cte2 + (double)((i - 1) / 2)) * k2d_cte1 / (k2d_cte2 + (double)i + k2d_p);
            }
            k2d_p = 1.0 - Math.pow(k2d_cte1, k2d_cte2) * Math.exp(-k2d_cte1) / ((k2d_cte2 + k2d_p) * StatisticalTest.getGammaFunctionValue(k2d_cte2));
            if (1.0E-4 < k2d_p && k2d_p < 1.0) {
                return k2d_p;
            }
            k2d_cte2 = (double)n / 2.0;
            k2d_cte1 = Math.pow(2.0, 1.0 + k2d_cte2) * StatisticalTest.getGammaFunctionValue(k2d_cte2);
            k2d_p = 0.0;
            k2d_epsilon = 5.0E-4;
            k2d_z = d;
            k2d_f = Math.pow(k2d_z, k2d_cte2 -= 1.0) / Math.exp(k2d_z / 2.0);
            while (!(Double.isNaN(k2d_s = (3.0 * Math.max(k2d_f, k2d_ff = Math.pow(k2d_z += k2d_epsilon, k2d_cte2) / Math.exp(k2d_z / 2.0)) - Math.min(k2d_f, k2d_ff)) / k2d_cte1) || Double.isInfinite(k2d_s) || k2d_s < 1.0E-6)) {
                k2d_p += k2d_epsilon * k2d_s;
                k2d_f = k2d_ff;
            }
            return k2d_p;
        }
        return 0.5 * StatisticalTest.getStandardNormalDistributionPvalue((Math.pow(d / (double)n, 0.3333333333333333) - 1.0 + 2.0 / (9.0 * (double)n)) / Math.sqrt(2.0 / (9.0 * (double)n)));
    }

    private static double getGammaFunctionValue(double d) {
        switch ((int)(2.0 * d)) {
            case 1: {
                return Math.sqrt(Math.PI);
            }
            case 2: {
                return 1.0;
            }
            case 3: {
                return Math.sqrt(Math.PI) / 2.0;
            }
            case 4: {
                return 1.0;
            }
            case 5: {
                return 0.75 * Math.sqrt(Math.PI);
            }
            case 6: {
                return 2.0;
            }
            case 7: {
                return 1.875 * Math.sqrt(Math.PI);
            }
            case 8: {
                return 6.0;
            }
            case 9: {
                return 6.5625 * Math.sqrt(Math.PI);
            }
            case 10: {
                return 24.0;
            }
            case 11: {
                return 29.53125 * Math.sqrt(Math.PI);
            }
            case 12: {
                return 120.0;
            }
            case 13: {
                return 162.421875 * Math.sqrt(Math.PI);
            }
            case 14: {
                return 720.0;
            }
            case 15: {
                return 1055.7421875 * Math.sqrt(Math.PI);
            }
            case 16: {
                return 5040.0;
            }
            case 17: {
                return 7918.06640625 * Math.sqrt(Math.PI);
            }
            case 18: {
                return 40320.0;
            }
            case 19: {
                return 67303.564453125 * Math.sqrt(Math.PI);
            }
            case 20: {
                return 362880.0;
            }
            case 21: {
                return 639383.8623046875 * Math.sqrt(Math.PI);
            }
            case 22: {
                return 3628800.0;
            }
            case 23: {
                return 6713530.554199219 * Math.sqrt(Math.PI);
            }
            case 24: {
                return 3.99168E7;
            }
            case 25: {
                return 7.720560137329102E7 * Math.sqrt(Math.PI);
            }
            case 26: {
                return 4.790016E8;
            }
            case 27: {
                return 9.650700171661377E8 * Math.sqrt(Math.PI);
            }
            case 28: {
                return 6.2270208E9;
            }
            case 29: {
                return 1.3028445231742859E10 * Math.sqrt(Math.PI);
            }
            case 30: {
                return 8.71782912E10;
            }
            case 31: {
                return 1.8891245586027142E11 * Math.sqrt(Math.PI);
            }
            case 32: {
                return 1.307674368E12;
            }
            case 33: {
                return 2.9281430658342075E12 * Math.sqrt(Math.PI);
            }
            case 34: {
                return 2.0922789888E13;
            }
            case 35: {
                return 4.831436058626442E13 * Math.sqrt(Math.PI);
            }
            case 36: {
                return 3.55687428096E14;
            }
            case 37: {
                return 8.455013102596274E14 * Math.sqrt(Math.PI);
            }
            case 38: {
                return 6.402373705728E15;
            }
            case 39: {
                return 1.5641774239803106E16 * Math.sqrt(Math.PI);
            }
            case 40: {
                return 1.21645100408832E17;
            }
        }
        return -1.0;
    }

    static {
        LANCZOS = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    }

    private static class WilcoxonTuple {
        public double absoluteDifference;
        public double sign;

        public WilcoxonTuple(double d, double d2) {
            this.absoluteDifference = Math.abs(d - d2);
            this.sign = this.absoluteDifference == 0.0 ? 0.0 : (d - d2) / this.absoluteDifference;
        }
    }
}

