
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <err.h>
#include <libgen.h>
#include <stddef.h>
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "compat.h"
#include "xfile.h"

static void usage(const char *);


int main(int argc, char **argv) {
  FILE *ou = stdout;
  const char *sep;
  char *p, *q, *s, *prg, *buf = NULL, *ofile = NULL;
  int i;
  size_t len;
  ptrdiff_t dif;
  uint64_t lig;

  prg = basename(*argv);
  sep = "\n";

  while ((i = getopt(argc, argv, "ho:p")) != -1) {
    switch (i) {
    case 'h':
      usage(prg); return EXIT_SUCCESS;
    case 'o':
      ofile = optarg; break;
    case 'p':
      sep = " /\n"; break;
    default:
      usage(prg); return EXIT_FAILURE; }
  }
  if (argc - optind < 1) {
    usage(prg); return EXIT_FAILURE; }

  if (ofile != NULL && (ou = fopen(ofile, "w")) == NULL)
    err(EXIT_FAILURE, "%s: open failed", ofile);

  for (i = optind; i < argc; i++) {
    const char *ifile = *(argv+i);
    size_t xfer, xinc, xmax;
    ssize_t ssiz, rsiz;
    xfile_t *xf;

    if ((xf = xfile_open(ifile, "r")) == NULL)
      err(EXIT_FAILURE, "%s: open failed", ifile);
    xfile_xfer(&xfer, xf); xinc = xfer; xmax = 10 * xinc;
    if ((buf = malloc(xfer+1)) == NULL)
      err(EXIT_FAILURE, "memory allocation failed");
    *(buf+xfer) = '\0';

    ssiz = rsiz = 0; lig = 0;
    while (/*CONSTCOND*/1) {
      ssiz = xfile_read(xf, buf + rsiz, xfer - (size_t)rsiz);
      if (ssiz < 1) break;

      rsiz += ssiz; p = buf;
      while (/*CONSTCOND*/ 1) {
	q = memchr(p, '\n', (size_t)rsiz);
	if (q == NULL) { break; }
	dif = q - p + 1; s = p; p = q + 1; lig++;
	rsiz -= dif;
	if (lig % 4 != 1) continue;
	len = strcspn(s + 1, sep);
	(void)fprintf(ou, "%.*s\n", (int)len, s+1); }
      if (rsiz == 0) continue;
      (void)memmove(buf, p, (size_t)rsiz);
      if (p != buf) continue;
      if (xfer == xmax)
	errx(EXIT_FAILURE, "%s: line too long", ifile);
      xfer += xinc;
      if ((buf = realloc(buf, xfer+1)) == NULL)
	err(EXIT_FAILURE, "realloc failed");
      *(buf+xfer) = '\0';
    }
    if (xfile_error(xf) != 0)
      err(EXIT_FAILURE, "%s: read failed", ifile);
    if (lig % 4 != 0)
      errx(EXIT_FAILURE, "%s: truncated file", ifile);

    free(buf);
    if (xfile_close(xf) == EOF)
      err(EXIT_FAILURE, "%s: close failed", ifile);
  }

  if (ofile != NULL && fclose(ou) == EOF)
    err(EXIT_FAILURE, "%s: close failed", ofile);

  return EXIT_SUCCESS; }


static void usage(const char *nam) {
  FILE *f = stderr;

  (void)fprintf(f, "usage: %s [options] <file> [...]\n", nam);
  (void)fprintf(f, "\noptions:\n");
  (void)fprintf(f, "  -h        ... Print this message and exit.\n");
  (void)fprintf(f, "  -o <file> ... Save output to file <file>.\n");
  (void)fprintf(f, "  -p        ... Do not extract pair member information.\n");

  return; }
