/* xfile.h - XFILE file functions */

#ifndef PTOOLS_SRC_XFILE_H
#define PTOOLS_SRC_XFILE_H

#include <sys/stat.h>

#include <stdio.h>
#include <zlib.h>

typedef enum {
  COMPRESS_UNKNOWN, COMPRESS_GZIP, COMPRESS_NONE } compress_t;

typedef struct {
  compress_t typ;
  union { FILE *fd; gzFile gd; } des;
  size_t xfer;
} xfile_t;

xfile_t *xfile_open(const char *, const char *);
int      xfile_close(xfile_t *);

void     xfile_xfer(size_t *, xfile_t *);
int      xfile_size(off_t *, xfile_t *);

ssize_t  xfile_read(xfile_t *, void *, size_t);
off_t    xfile_seek(xfile_t *, off_t, int);
char    *xfile_gets(char *, int, xfile_t *);

int      xfile_eof(xfile_t *);
int      xfile_error(xfile_t *);

#endif /* PTOOLS_SRC_XFILE_H */
