#! /bin/sh

# Command line
../src/fqconvert -h 2>/dev/null || exit 1
../src/fqconvert -l  >/dev/null || exit 1

# Default
../src/fqconvert $srcdir/sample.fq >/dev/null 2>&1 || exit 1

# Detect only (-d)
../src/fqconvert -d $srcdir/sample.fq >_output.fq 2>/dev/null || exit 1
cmp -s /dev/null _output.fq || exit 1

# Check scoring detection
cat $srcdir/sample.fq | tr 'B-h' '!-I' >_sample.fq || exit 1
../src/fqconvert -d _sample.fq 2>_output.fmt || exit 1
grep -q 'Sanger' _output.fmt || exit 1
cat $srcdir/sample.fq | tr '^' ';' >_sample.fq || exit 1
../src/fqconvert -d _sample.fq 2>_output.fmt || exit 1
grep -q 'Solexa' _output.fmt || exit 1
cat $srcdir/sample.fq | tr '^' '@' >_sample.fq || exit 1
../src/fqconvert -d _sample.fq 2>_output.fmt || exit 1
grep -q 'Illumina1.3+' _output.fmt || exit 1
cat $srcdir/sample.fq >_sample.fq || exit 1
../src/fqconvert -d _sample.fq 2>_output.fmt || exit 1
grep -q 'Illumina1.5+' _output.fmt || exit 1
cat $srcdir/sample.fq | tr '^' 'i' >_sample.fq || exit 1
../src/fqconvert -d _sample.fq 2>_output.fmt || exit 1
grep -q 'Illumina1.7+' _output.fmt || exit 1
cat $srcdir/sample.fq | tr 'BC-h' 'J!-I' >_sample.fq || exit 1
../src/fqconvert -d _sample.fq 2>_output.fmt || exit 1
grep -q 'Illumina1.8+' _output.fmt || exit 1
cat $srcdir/sample.fq | tr 'BC-h' 'N!-I' >_sample.fq || exit 1
../src/fqconvert -d _sample.fq 2>_output.fmt || exit 1
grep -q 'Torrent3.0+' _output.fmt || exit 1

# Convert
../src/fqconvert -o _sanger.fq $srcdir/sample.fq 2>/dev/null || exit 1
cmp -s $srcdir/sample.fq _sanger.fq && exit 1
../src/fqconvert -o _sanger2.fq _sanger.fq 2>/dev/null || exit 1
cmp -s _sanger.fq _sanger2.fq || exit 1

# Cleanup
rm -f _*.fq _*.fmt

exit 0
