#! /bin/sh

## Check for builtin zlib support and gzip(1) tool
grep -q '^#define HAVE_LIBZ 1$' ../src/config.h || exit 77
which gzip >/dev/null 2>&1 || exit 77

## Inits
gzip -c $srcdir/sample.fq >_sample.fq.gz || exit 1

## fqconvert
../src/fqconvert -o _default.out $srcdir/sample.fq || exit 1
../src/fqconvert -o _gzpress.out _sample.fq.gz || exit 1
cmp -s _default.out _gzpress.out || exit 1

## fqextract
../src/fqextract -o _default.out $srcdir/sample.fq || exit 1
../src/fqextract -o _gzpress.out _sample.fq.gz || exit 1
cmp -s _default.out _gzpress.out || exit 1

## fqseqname
../src/fqseqname -o _default.out $srcdir/sample.fq || exit 1
../src/fqseqname -o _gzpress.out _sample.fq.gz || exit 1
cmp -s _default.out _gzpress.out || exit 1

## Cleanup
rm -f _*.gz _*.out

exit 0
