
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <err.h>
#include <libgen.h>
#ifdef HAVE_STDINT_H
# include <stdint.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef USE_BSDMD5
# ifdef HAVE_MD5_H
#  include <md5.h>
# endif
# ifdef HAVE_BSD_MD5_H
#  include <bsd/md5.h>
# endif
#endif

#ifdef USE_SSLMD5
# ifdef HAVE_OPENSSL_MD5_H
#  include <openssl/md5.h>
# endif
# define MD5Init MD5_Init
# define MD5Update MD5_Update
# define MD5Final MD5_Final
#endif

#include "compat.h"
#include "fastq.h"


static void usage(char *);


int main(int argc, char **argv) {
  FILE *in1, *in2, *ou;
  char *p, *prg, *ifile1, *ifile2, *ofile;
  int i;
  size_t s, len1, len2;
  fqseq_t seq1, seq2;
  MD5_CTX md5;

  unsigned char xx[16];
  uint64_t val;

  /* Inits */
  prg = basename(*argv);
  ofile = NULL; ou = stdout;
  in1 = in2 = NULL;

  /* Command line */
  while ((i = getopt(argc, argv, "ho:")) != -1) {
    switch (i) {
    case 'h':
      usage(prg); return EXIT_SUCCESS;
    case 'o':
      ofile = optarg; break;
    default:
      usage(prg); return EXIT_FAILURE; }
  }
  if (argc - optind < 1 || argc - optind > 2) {
    usage(prg); return EXIT_FAILURE; }

  fastq_init(&seq1);
  fastq_init(&seq2);

  /* Process sequence files */
  ifile1 = *(argv+optind);
  ifile2 = (argc - optind == 2) ? *(argv+optind+1) : NULL;
  if (ifile1 != NULL && (in1 = fopen(ifile1, "r")) == NULL)
    err(EXIT_FAILURE, "%s: open failed", ifile1);
  if (ifile2 != NULL && (in2 = fopen(ifile2, "r")) == NULL)
    err(EXIT_FAILURE, "%s: open failed", ifile2);
  if (ofile != NULL && (ou = fopen(ofile, "w")) == NULL)
    err(EXIT_FAILURE, "%s: open failed", ofile);

  while (/*CONSTCOND*/ 1) {

    if (ifile1 != NULL) { fastq_read(in1, &seq1); }
    if (ifile2 != NULL) { fastq_read(in2, &seq2); }
    if (feof(in1) != 0) break;

    val = 0;
    MD5Init(&md5);
    if (ifile1 != NULL) {
      p = seq1.squa; while (*p) { val += *p; p++; }
      len1 = strlen(seq1.sseq);
      MD5Update(&md5, (unsigned char *)seq1.sseq, (unsigned int)len1); }
    if (ifile2 != NULL) {
      p = seq2.squa; while (*p) { val += *p; p++; }
      len2 = strlen(seq2.sseq);
      MD5Update(&md5, (unsigned char *)seq2.sseq, (unsigned int)len2); }
    MD5Final(xx, &md5);

    for (s = 0; s < __arraycount(xx); s++) { (void)fprintf(ou, "%02x", xx[s]); }
    if (fprintf(ou, "\t%"PRIu64"\t%s\n", val, seq1.snam) < 0) {
      const char *out = (ofile != NULL) ? ofile : "stdout";
      err(EXIT_FAILURE, "%s: output failed", out); }

  }

  if (ofile != NULL && fclose(ou) == EOF)
    err(EXIT_FAILURE, "%s: close failed", ofile);
  if (ifile2 != NULL && fclose(in2) == EOF)
    err(EXIT_FAILURE, "%s: close failed", ifile2);
  if (ifile1 != NULL && fclose(in1) == EOF)
    err(EXIT_FAILURE, "%s: close failed", ifile1);

  fastq_fini(&seq2);
  fastq_fini(&seq1);

  return EXIT_SUCCESS; }


static void usage(char *prg) {
  FILE *f = stderr;

  (void)fprintf(f, "usage: %s [options] <file> [<file>]\n", prg);
  (void)fprintf(f, "\noptions:\n");
  (void)fprintf(f, "  -h        ... Print this message and exit.\n");
  (void)fprintf(f, "  -o <file> ... Save output to <file>.\n");

  return; }
