
#include <err.h>
#include <stdlib.h>
#include <string.h>

#include "fqlist.h"


static int fqent_compare(const void *a, const void *b) {
  const fqent_t *fa = a, *fb = b;
  ssize_t dif;

  dif = fa->num - fb->num;
  if (dif != 0) { return dif; }

  dif = fa->nlen - fb->nlen;
  if (dif != 0) { return dif; }

  dif = strncmp(fa->nam, fb->nam, fa->nlen);

  return dif; }


void fqlist_init(fqlist_t *lst) {

  lst->num = 0; lst->lst = NULL;

  return; }

void fqlist_fini(fqlist_t *lst) {
  fqent_t *cur;

  cur = lst->lst;
  while (lst->num--) {
    free(cur->buf); cur++; }

  free(lst->lst);

  return; }

void fqlist_sort(fqlist_t *lst) {
  fqent_t *ent = lst->lst;

  qsort(ent, lst->num, sizeof(*ent), fqent_compare);

  return; }

void fqlist_dump(fqlist_t *lst) {
  size_t num;
  fqent_t *ent;

  num = lst->num; ent = lst->lst;
  while (num) {
    warnx("%zu %s %zu", ent - lst->lst, ent->nam, ent->nlen);
    ent++; num--; }

  return; }


void fqlist_add(fqlist_t *lst, fqent_t *ent) {
  size_t len;
  fqent_t *new, *old;

  /* Realloc if needed */
  if (lst->num % 10 == 0) {
    old = lst->lst; len = lst->num + 10;
    new = realloc(old, len * sizeof(*old));
    lst->lst = new; }

  new = lst->lst + lst->num;
  new->buf = ent->buf; new->num = ent->num;
  new->nam = ent->nam; new->nlen = ent->nlen;
  lst->num++;

  return; }


int fqlist_chk(fqlist_t *lst, fqent_t *ent) {
  int i = -1, beg, mid, end;
  fqent_t *cur;

  beg = 0; end = lst->num - 1;
  while (beg <= end) {
    mid = (beg + end) / 2;

    cur = lst->lst + mid;
    i = fqent_compare(ent, cur);

    if (i == 0) { break; }
    if (i < 0) { end = mid - 1; }
    if (i > 0) { beg = mid + 1; }

  }

  return i != 0; }
