
#include <err.h>
#include <libgen.h>
#include <stdio.h>
#include <stdlib.h>

#include "fastq.h"

int main(int argc, char **argv) {
  FILE *in;
  char *prg, *inf;
  fqseq_t seq;

  /* Inits */
  prg = basename(*argv);

  /* Command line */
  if (argc != 2) {
    errx(EXIT_FAILURE, "usage: %s <file>", prg); }
  inf = *(argv+1);

  if ((in = fopen(inf, "r")) == NULL)
    err(EXIT_FAILURE, "%s: open failed", inf);
  fastq_init(&seq);
  while (/*CONSTCOND*/1) {
    if (feof(in) != 0) break;
    if (fastq_read(in, &seq) < 0)
      errx(EXIT_FAILURE, "%s: read failed", inf); }
  fastq_fini(&seq);
  if (fclose(in) == EOF)
    err(EXIT_FAILURE, "%s: close failed", inf);

  return 0; }
