#! /bin/sh

## Tweak path for underlying fqseqname call
PATH=../src:$PATH; export PATH

# Command line
../src/fqseqpair -h 2>/dev/null || exit 1

# Input files
ln -nsf $srcdir/sample.fq _sample1.fq || exit 1
sed 's,/1,/2,' $srcdir/sample.fq >_sample2.fq || exit 1

# Default
../src/fqseqpair _sample1.fq _sample2.fq >/dev/null 2>&1 || exit 1

# Output file (-o)
../src/fqseqpair _sample1.fq _sample2.fq >_stdout.lst || exit 1
../src/fqseqpair -o _outfile.lst _sample1.fq _sample2.fq || exit 1
cmp -s _stdout.lst _outfile.lst || exit 1

# Only pairs
../src/fqseqname -p -o _sample.ref _sample1.fq || exit 1
sort -o _sample.ref _sample.ref || exit 1
../src/fqseqpair -o _sample.lst _sample1.fq _sample2.fq || exit 1
cmp -s _sample.ref _sample.lst || exit 1

# No pairs
../src/fqseqpair -o _sample.lst _sample1.fq /dev/null || exit 1
test -s _sample && exit 1
../src/fqseqpair -o _sample.lst /dev/null _sample2.fq || exit 1
test -s _sample && exit 1

# Cleanup
rm -f _*.fq _*.lst _*.ref

exit 0
