#! /bin/sh

# Command line
../src/fqstats -h 2>/dev/null || exit 1

# Default
../src/fqstats $srcdir/sample.fq >/dev/null 2>&1 || exit 1

# Stat values
../src/fqstats $srcdir/sample.fq >_values.out || exit 1
grep -q ' 100 sequences' _values.out || exit 1
grep -q ' 6900 bases' _values.out || exit 1
../src/fqstats /dev/null >_nodata.out || exit 1
grep -q ' 0 sequences' _nodata.out || exit 1
grep -q ' 0 bases' _nodata.out || exit 1

# Output file
../src/fqstats $srcdir/sample.fq >_stdout.out || exit 1
../src/fqstats -o _outfile.out $srcdir/sample.fq || exit 1
cmp -s _stdout.out _outfile.out || exit 1

# Cleanup
rm -f _*.out

exit 0
