/* locus.c - Entry names functions */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif

#include "error.h"
#include "index.h"
#include "locus.h"

#define LOCSUF "idx"


/* Search in entry names indexes */
indix_t locus_search(char *dbase, char *name) {
  char *p, *file;
  size_t len;
  indix_t res;

  p = index_dir();
  len = strlen(p) + 1 + strlen(dbase) + 1 + strlen(LOCSUF);
  if ((file = (char *)malloc(len+1)) == NULL)
    error_fatal("memory", NULL);
  (void)sprintf(file, "%s/%s.%s", p, dbase, LOCSUF);
  
  res = index_search(file, name);

  free(file);

  return res; }


/* Merge locus indexes with existing file */
int locus_merge(char *dbase, long nb, indix_t *ind) {
  int i;
  char *file;
  size_t len;

  len = strlen(dbase) + 1 + strlen(LOCSUF);
  if ((file = (char *)malloc(len+1)) == NULL)
    error_fatal("memory", NULL);
  (void)sprintf(file, "%s.%s", dbase, LOCSUF);

  i = index_merge(file, nb, ind);

  free(file);

  return i; }
