/* index.h - Golden indexes functions */

#ifndef __INDEX_H_
#define __INDEX_H_

#include "entry.h"


/* Index files suffixes */
#define LOCSUF "idx"
#define ACCSUF "acx"
#define LSTSUF "dbx"
#define VIRSUF "vix"

/* Index structure definition */
typedef struct {
  char name[NAMLEN+1];
  int  filenb;
  off_t offset; } indix_t;

typedef struct {
  char *name, *dbase;
  int filenb;
  off_t offset; } result_t;

/* Functions prototypes */
int index_merge(char *file, long nb, indix_t *ind);
result_t *index_search(char *file, char *name);
char *index_dir(void);
char *index_file(const char *dir, const char *dbase, const char *suf);

#endif /* __INDEX_H_ */

