/* index.h - Golden indexes functions */

#ifndef __INDEX_H_
#define __INDEX_H_

#include <inttypes.h>

#include "entry.h"


/* Index files suffixes */
#define LOCSUF "idx"
#define ACCSUF "acx"
#define LSTSUF "dbx"
#define VIRSUF "vix"

/* Index structure definition */
typedef struct {
  char name[NAMLEN+1];
  uint32_t filenb;
  uint64_t offset; } indix_t;

typedef struct {
  char *name, *dbase;
  int filenb;
  off_t offset; } result_t;

/* Functions prototypes */
int index_merge(char *, long, indix_t *);
result_t *index_search(char *, char *);
const char *index_dir(void);
char *index_file(const char *, const char *, const char *);

#endif /* __INDEX_H_ */

