/* ==================================================== */
/*	Copyright (c) Atelier de BioInformatique	*/
/*	Dec. 92 					*/
/* 	File: cov_fasta.h				*/
/*	History:					*/
/*	History:					*/
/*	15/08/92 : <Gloup> first version ->libfasta	*/
/*	00/08/95 : <Gloup> modified version for hitgen	*/
/* ==================================================== */

#ifndef _H_cov_fasta

#define _H_cov_fasta

#ifndef _H_Gtypes
#include "Gtypes.h"
#endif

/* ==================================================== */
/* Constantes						*/
/* ==================================================== */

#define FASTA_NAMLEN  32  	/* max length of seq. name	 */
#define FASTA_COMLEN  256 	/* max length of seq. comment	 */

#define FASTA_CHAR_PER_LINE 50	/* # of chars per line in output */

/* ==================================================== */
/* Macros						*/
/* ==================================================== */

#ifndef NEW
#define NEW(typ)		(typ*)malloc(sizeof(typ)) 
#define NEWN(typ, dim) 		(typ*)malloc((unsigned long)(dim) * sizeof(typ))
#define REALLOC(typ, ptr, dim)	(typ*)realloc((void *) (ptr), (unsigned long)(dim) * sizeof(typ))
#define FREE(ptr)		free((Ptr) ptr)
#endif

/* ==================================================== */
/* Structures de donnees				*/
/* ==================================================== */

typedef struct {			/* -- Sequence ---------------- */
	Bool	ok;			    /* error flag			*/
	Int32	length,			/* longueur			*/
			bufsize;		/* size of current seq buffer	*/
	char    name[FASTA_NAMLEN],	/* nom 				*/
		comment[FASTA_COMLEN],	/* commentaire			*/
		*seq,				/* sequence			*/
		*cover;
} FastaSequence, *FastaSequencePtr;

/* ==================================================== */
/*  Prototypes (generated by mkproto)			*/
/* ==================================================== */

					/* libfasta.c 	*/

Int32 		 CountAlpha 	    P(( char *buf ));
char  		 *StrcpyAlpha 	    P(( char *s1 , char *s2 ));
char  		 *NextSpace 	    P(( char *buffer ));
char  		 *GetFastaName 	    P(( char *buffer ));
char 		 *GetFastaComment   P(( char *buffer ));

FastaSequencePtr FreeFastaSequence  P(( FastaSequencePtr seq ));
FastaSequencePtr NewFastaSequence   P(( void ));

Bool		 ReadFastaSequence  P(( FILE *streamin, FastaSequencePtr seq ));
void 		 WriteFastaSequence P(( FILE *streamou, FastaSequencePtr seq , Int32 char_per_line ));

#endif
