## Pasteur PaintBlast package derived from Alessandro Guffanti one.

package IPaintBlast;

use strict;
use GD;

sub drawimage {
    my $file = shift;
    my $nb = shift;

    my $res = 0;
    my $qname = "Query"; my $qlen = 0;
    my $seqid = ""; my $len = 0;

    my %seqs = ();
    my @seqlist = ();

    ## Parse blast file
    open(IN,"< $file") || die("Can't open file $file");
    while(<IN>) {
	
	## Check for Blast result start
	if (/^T?BLAST[NX]?/) { $res++; next; }
	
	## Next if not wanted result
	next if ($res != $nb);

	## Get query name & length
	if (/^Query=\s+\S+\|(\S*)\|/) { $qname = $1; next; }
	if (/\((\d+),?(\d*) letters\)/) { $qlen = $1.$2; next; }
	
	## Get match sequence id & len
	if (/^>(\w*)\|(\w*)\|(\w*) /) {
	    $seqid = "$1&$2&$3";
	    next if (grep(/$seqid/,@seqlist) != ());
	    push(@seqlist,$seqid);
	    next; }

	## Get align score
	if (/Score =\s+(\d+(\.\d+)?)/) {
	    push(@{$seqs{$seqid}},$1);
	    push(@{$seqs{$seqid}},0);
	    push(@{$seqs{$seqid}},0);
	    next; }

	## Get query align start & end
	if (/^Query:\s+(\d+)\s+\S+\s+(\d+)$/) {
	    my $stop  = pop(@{$seqs{$seqid}});
	    my $start = pop(@{$seqs{$seqid}});
	    my $beg; my $end;
	    if ($1 < $2) { $beg = $1; $end = $2; }
	    else { $beg = $2; $end = $1; }
	    if ($start == 0 || $beg < $start) {
		push(@{$seqs{$seqid}},$beg); }
	    else {
		push(@{$seqs{$seqid}},$start); }
	    if ($stop == 0 || $end > $stop) {
		push(@{$seqs{$seqid}},$end); }
	    else { 
		push(@{$seqs{$seqid}},$stop); }
	    next; }
	
    }
    close(IN);

    ## Make alignment summary image
    my $imgname = "paintblast$nb.$$.gif";
    my $font = gdMediumBoldFont; my $fonth = $font->height;
    my $seqnb = scalar @seqlist; my $spos = 100;
    my $imgw = 632; my $imgh = (4 + $seqnb + 7) * $fonth;
    my $img = new GD::Image($imgw,$imgh);

    ## Allocate colors
    my $white = $img->colorAllocate(255,255,255);
    my $black = $img->colorAllocate(0,0,0);
    my $red = $img->colorAllocate(255,0,0);
    my $green = $img->colorAllocate(0,205,25);
    my $yellow = $img->colorAllocate(247,174,0);
    my $grey = $img->colorAllocate(130,130,130);
    my $blue = $img->colorAllocate(0,0,255);

    ## Scoring colors intervals (min value key).
    my %colors = ( 0 => $blue, 50 => $grey, 100 => $yellow, 150 => $green,
		   200 => $red );

    ## Interlaced background
    $img->interlaced('true');
    ## Black frame round image
    $img->rectangle(0,0,$imgw-1,$imgh-1,$black);

    ## Draw query
    my $start = 100; my $stop = $imgw - $fonth;
    my $line = $fonth;
    $img->string($font,$fonth,$line,$qname,$red);
    $img->filledRectangle($start,$line,$stop,$line+$fonth/2-1,$red);
    $line += $fonth/2;
    ## Draw query rule
    my $unit = ($stop - $start) / $qlen;
    my $delta = 0;
    for (my $i=1; 1; $i*=10) {
	my $tmp = $qlen/$i;
	if (($tmp/5) > 10) { $delta = $i * 5; next }
	if ($tmp > 10) { $delta = $i; next; }
	last; }
    for (my $i=0; $i*$delta<=$qlen; $i++) {
	my $pos = $i*$delta*$unit;
	$img->line($spos+$pos,$line,$spos+$pos,$line+$fonth/2-1,$red);
	next if ($i%5 != 0);
	$img->string($font,$spos+$pos,$line+$fonth/2,$i*$delta,$black); }
    $line += $fonth * 2.5;

    ## Draw all matched sequences & image map
    print "<MAP NAME=HSPMAP$nb>\n";
    foreach (@seqlist) {
	## Sequence name
	/\S*&(\S*)&(\S*)/; my $id = $1;
	if ($id eq "") { $id = "$2 (ID)"; }
	$img->string($font,$fonth,$line,$id,$black);
	my $seqhref = $_; $seqhref =~ s/&/_/g;
	my $line2 = $line + $fonth * 3/4 - 1;
	print "<AREA SHAPE=RECT COORDS=$fonth,$line,$spos,$line2 HREF=#$seqhref\_$nb>\n";
	## Sequence HSPs (printed in reverse appearance order).
	my @hsp = @{$seqs{$_}};
	while (@hsp != ()) {
	    my $end = pop(@hsp) * $unit + $start;
	    my $begin = pop(@hsp) * $unit + $start;
	    my $score = pop(@hsp);
	    my $color = 0;
	    foreach (sort bynumber keys %colors) {
		if ($score > $_) { $color = $colors{$_}; next; }
		last; }
	    $img->filledRectangle($begin,$line+$fonth/4,
				  $end,$line+$fonth*3/4,$color); }
	$line += $fonth; }
    print "</MAP>\n";
    print "<CENTER>";
    print "<IMG BORDER=0 USEMAP=#HSPMAP$nb SRC=$imgname ISMAP>";
    print "</CENTER>\n";

    ## Draw query
    $line += $fonth;
    for (my $i=0; $i*$delta<=$qlen; $i++) {
	my $pos = $i*$delta*$unit;
	$img->line($spos+$pos,$line+$fonth,$spos+$pos,$line+$fonth*1.5-1,$red);
	next if ($i%5 != 0);
	$img->string($font,$spos+$pos,$line,$i*$delta,$black); }
    $line += $fonth;
    $img->string($font,$fonth,$line,$qname,$red);
    $img->filledRectangle($start,$line+$fonth/2,$stop,$line+$fonth-1,$red);
    $line += $fonth;

    ## Draw color legend
    $line += $fonth;
    $img->string($font,$fonth,$line,"Scoring",$red);
    $img->string($font,$fonth,$line+$fonth,"colors",$red);
    my $nbcol = scalar keys %colors;
    my $lencol = ($stop - $start) / $nbcol;
    my $pos = $start; my $prec = 0;
    foreach (sort bynumber keys %colors) {
	my $color = $colors{$_};
	$img->filledRectangle($pos,$line,$pos+$lencol,$line+$fonth,$color);
	$img->string($font,$pos,$line+$fonth,"S>$_",$black);
	$pos += $lencol; }

    ## Convert image to GIF and save
    my $image = $img->gif;
    open(IMG,"> $imgname");
    print IMG $image;
    close(IMG);

    return $imgname;
}

## Sort by numbers
sub bynumber { $a <=> $b; }

1;
