dnl More m4 definitions for autoconf

dnl Checks for Perl program and set PERL variable to full program path.
dnl AC_PROG_PERL
AC_DEFUN(AC_PROG_PERL,
[AC_PATH_PROG(PERL, perl)
if test -z "$PERL"; then
   AC_MSG_ERROR([perl not found])
fi
])

dnl Check for perl module
dnl AC_CHECK_PERL_MODULE(VARIABLE, MODULE [, VERSION])
AC_DEFUN(AC_CHECK_PERL_MODULE,
[AC_REQUIRE([AC_PROG_PERL])dnl
ac_mod_msg="$2"
if test -n "$3"; then
   ac_mod_msg="$2 v$3"
fi
AC_MSG_CHECKING([$ac_mod_msg perl module])
ac_have_module=no
if test -z "`$PERL -e 'use $2 $3;' 2>&1`"; then
   ac_have_module=yes
fi
$1="$ac_have_module"
AC_MSG_RESULT([$]$1)
])
   