"""
    The Evaluation Class stocke the parameter values and permit to evaluate expression (Ctrl precond format ...) in a protected environement avoidig names colision
"""
import imp
import sys,os
import logging
from Mobyle.MobyleError import *
import Mobyle.ConfigManager


_cfg = Mobyle.ConfigManager.Config()                                                       
e_log = logging.getLogger('mobyle.evaluation')
b_log = logging.getLogger('mobyle.builder')

    

__extra_epydoc_fields__ = [('call', 'Called by','Called by')]




class Evaluation:
    """
    The Evaluation Class stocke the parameter values and permit to evaluate expression (Ctrl precond format ...) in a protected environement avoidig names colision
    """
    def __init__(self):
        try:
            fp , pathname , description = imp.find_module("re")
            self.re = imp.load_module( "re" , fp , pathname , description )
            
        finally:
            if fp:
                fp.close()

        
    def isFill( self ):
        """
        @return: returns True if the Evaluation is already filled, if there isn't any user value in evalution return False.
        @rtype: boolean
        """
        
        for var in self.__dict__.keys():
            if var == "re" or var == "__builtins__":
                continue
            else:
                return True
        return False


    def _2dict_( self ):
        """
        @return: Returns a dictionary containing the attributes creates by L{setVar}
        @rtype: dictionary
        """
        dict = {}
        
        for param in self.__dict__.keys():
            if param == "__builtins__" or param == "vdef" or param == "value" or param == "re" :
                pass
            else:
                dict[ param ] = self.__dict__[ param ]
                
        return dict

    def setVar(self, varName , value):
        """
        Creates an attribute varName with the value value
             
        @param varName: the name of the attribute to create
        @type varName: String
        @param value: the value of the attribute varName
        @type value: any
      
        """
        setattr(self , varName , value)

  

    def getVar(self,varName):
        """
        @param varName: the name of the parameter 
        @type varName: String
        @return: the value of the varName attribute or None if there is no attribute varName  
        """
        try:
            return getattr(self, varName)
        except AttributeError:
            return None
   

          
    def eval(self,expr):
        """
        eval the expr in self namespace. be careful to specify the value and vdef before calling eval.
        @param expr: the expresion to evalute
        @type expr: String
        @return: the expression evaluated in the Evalution namespace
        @todo: evaluer le temps passe a importe re a chaque fois, le faire que si re dans la string a evalue?
        """

        try:
            myEval= eval( expr , vars(self) )
            return myEval
        
        except Exception , err:
            raise EvaluationError , err

                  


    def isDefined(self, varName):
        """
        we decided to fill the evaluation instance with all the parameter of the service.
        if the user provide a value or there is a vdef for the parameter the value is affected
        to the parameter.
        else the parameter will be affected at None
        @return: True if the varName has been defined (not None), False Otherwise
        """
        try:
            if getattr(self, varName) == None:
                return False
            else:
                return True
        except NameError:
            msg = "the variable: "+str(varName)+" is unknown"
            e_log.error(msg)
            raise MobyleError ,msg

                  
if __name__ == '__main__' : 
#l'instance d'evaluation est rempli des la reception du formulaire
#et tous les parametres sont creer
# -si la valeur du parameter est renseignee par le formulaire la variable est cree
# -si la valeur du parametre n'est pas renseigne
#       - si le parametre est obligatoire et sans vdef erreur
#       - si le parametre n'est pas obligatoire et sans vdef la variable est mise a None
    evaluator = Evaluation()
    
    evaluator.setVar('param1', -1)
    evaluator.setVar('param2', None )
    evaluator.setVar('param3', 'tata')
    evaluator.setVar('param4', True)
    evaluator.setVar('param7', 7)
    evaluator.setVar('param8', 3)

    print "param 1"
    evaluator.setVar('value', evaluator.getVar('param1'))
    evaluator.setVar('vdef', None)
    arg = evaluator.eval('("", " -f")[param1 > 0]')
    print "value = ",evaluator.value ," vdef = ",evaluator.vdef
    print '("", " -f")[param1 > 0] = ', arg
    print " ------------------ "

    print "param 2"
    evaluator.setVar('value', evaluator.getVar('param2'))
    evaluator.setVar('vdef', None)
    precond = evaluator.eval( 'param2' )
    print "precond = ",'param2 = ',precond
    print "value = ",evaluator.value ," vdef = ",evaluator.vdef
    if precond:
       arg = evaluator.eval(' ("" , " -p " + str(value))[param2 != None] ')
       print ' ("" , " -p " + str(value))[param2 != None] = ', arg
    print " ------------------ "
    
    print "param 3"
    evaluator.setVar('value', evaluator.getVar('param3'))
    evaluator.setVar('vdef', None)
    precond = evaluator.eval( 'param3' )
    print "precond = ",'param3 ', precond
    print "value = ",evaluator.value ," vdef = ",evaluator.vdef
    if precond:
       arg = evaluator.eval('" -t " + str(value) + " -x "+ str(param1) ')
       print 'param3','" -t " + str(value) + " -x+ str(param1) " = ', arg
    print " ------------------ "

    print "param 4"
    evaluator.setVar('value', evaluator.getVar('param4'))
    evaluator.setVar('vdef', None)
    arg = evaluator.eval( '("-t ", "+t")[value]' )
    print "value = ",evaluator.value ," vdef = ",evaluator.vdef
    print '("-t ", "+t")[value] = ', arg
    print " ------------------ "

    print "param 7"
    evaluator.setVar('value', evaluator.getVar('param7'))
    evaluator.setVar('vdef', None)
    precond = evaluator.eval('param4')
    print "precond",'param4',precond
    print "value = ",evaluator.value ," vdef = ",evaluator.vdef
    if precond:
       arg = evaluator.eval('("-t" ,"")[value != vdef ]')       
       print '("-t" ,"")[value != vdef ] = ', arg
    print " ------------------ "

    print "param 8"
    evaluator.setVar('value', evaluator.getVar('param8'))
    evaluator.setVar('vdef', None)
    precond = evaluator.eval("param2 < 8 or param3 == 'tata'")
    print "value = ",evaluator.value ," vdef = ",evaluator.vdef
    print "precond ", "param2 < 8 or param3 == 'tata' = ",precond
    if precond:
       arg = evaluator.eval('("", "abcd %d" % (value))[value != vdef]')   
       print '("", "abcd %d" % (value))[value != vdef] = ' , arg

