import os ,os.path ,random , string 
#import re
import resource
import md5
import time 
#import datetime
import glob
import logging 
j_log = logging.getLogger('mobyle.job')

import Mobyle.JobState 
import Mobyle.ConfigManager
import Mobyle.Utils

from Mobyle.MobyleError import *


__extra_epydoc_fields__ = [('call', 'Called by','Called by')]



class Job:

    """
    create the environement to run a job
      - working directory creation
    """
 
    
    def __init__(self, service , cfg , session = None , email = None , synchron = False):
        """
        @param service:
        @type service: a {Service} instance
        @param cfg: a config object
        @type cfg: L{ConfigManager.Config} instance
        @param session:
        @type session: a L{Session} instance
        @param email: 
        @type email: a L{Mobyle.Net.Email} instance
        @param synchron: 
        @type synchron: boolean

        """
        self.cfg = cfg
        self.tmpdir = None
        self.jobState = None
        self.service = service
        self.key = self._newKey()
        self.runner = None
        self.session = session
        self.email = email
        self.synchron = synchron
        self.adm = None 
        self.makeEnv()



    def makeEnv( self, uri = None ):
        """
        create the environement to run a job
          - working directory creation
          - fixing permisson
          - creation of the xml file index.xml
        """
        basedir =  self.cfg.results_path() 
        if not os.path.exists( basedir ):
            msg = "directory " + str( basedir ) + " does not exist"
            j_log.error(msg)
            raise MobyleError, msg

        if uri is None:            
            workdir = os.path.join( basedir , self.service.getName() , self.key )
            if os.path.exists( workdir ):
                msg = 'cannot make directory '+ str( workdir )+" : File exists"
                
                j_log.error( msg )
                raise MobyleError , msg

            os.makedirs( workdir , 0755 ) #create parent directory
        try:    
            os.chdir( workdir )
        except OSError, err:
            msg = "unable to change directory to:" + str( err )
            j_log.error( msg )
            raise MobyleError , msg 

        os.umask(0022)
        self.tmpdir = workdir

        resource.setrlimit( resource.RLIMIT_CORE ,(0 , 0) )
        maxFileSize = self.cfg.filelimit()
        resource.setrlimit( resource.RLIMIT_FSIZE ,( maxFileSize , maxFileSize ) )

        self.date = time.localtime()
        
        #create the index.xml in the job temporary directory
        self.jobState = Mobyle.JobState.JobState( uri= workdir )
        
        #be careful the order of setting informations in state is important
        
        if self.service.isService:
       
            self.jobState.createState( "SERVICE" )
        else:
            self.jobState.createState( "PIPELINE" )

        serviceName = self.service.getName()
        jobID = self.getURL()
        
        self.jobState.setName( self.service.getName() )
        self.jobState.setHost( self.cfg.root_url() )
        self.jobState.setID( jobID )
        self.jobState.setDate( self.date )
        self.jobState.setStatus( 0 ) # building
        if self.email is not None:
            self.jobState.setEmail( self.email.To )
        if self.session is not None:
            sessionKey = self.session.getKey()
            self.jobState.setSessionKey( sessionKey )

        self.jobState.commit()
   
        #create the .admin file
        self.adm = Mobyle.Utils.Admin( self.tmpdir )
        self.adm.setDate()
        if self.email is not None:
            self.adm.setEmail( self.email.To )

        try:
            remote_host = os.environ['REMOTE_HOST']
        except KeyError :
            remote_host = "UNKNOWN"
        try:
            ip_addr = os.environ['REMOTE_ADDR']
        except KeyError :
            ip_addr = 'local'
        
        self.adm.setRemote( ip_addr+"\\"+remote_host )

##      attention je suis en train de construire le job
##      via l'instanciation d'un MobyleJob
##      donc le job n'a toujours pas ete ajoute
##      a la session ( fait expilcitement dans CGI pendant le submit value )
##              
        if self.session is not None:
            self.adm.setSession( sessionKey )
##             self.session.updateJobStatus( jobID = jobID  , status = 0 )

        #ajouter la date de soumission de ce job
        #self.session.updateJob( self.getURL() , date = self.date )

        self.adm.setJobName( serviceName )
        self.adm.setJobID( jobID )
        self.adm.setStatus( 0 )
        self.adm.commit()
        
       
    def _newKey(self):
        """
        @return: a unique key which serve to indetify a job
        @rtype: string
        """

        #for PBS/SGE jobname, the first char of tmp dir must begin by a letter
        letter = string.ascii_uppercase[ random.randrange( 0 , 26 ) ]
        #max 15 chars for PBS jobname
        strTime = "%.9f" % time.time()
        strTime = strTime[-9:]
        strPid = "%05d" %os.getpid()
        strPid = strPid.replace( '.' , '' )[ -5 : ]
        return letter + strPid + strTime


    def getKey( self ):
        """
        @return: the unique key of this job
        @rtype: string
        """
        return  self.key

    def getDate( self ):
        """
        @return: the submission date of this job
        @rtype: string
        """
        return  self.date
    

    def getDir(self):
        """
        @return: the absolute path to the directory where the job is executed
        @rtype: string
        """
        
        return self.tmpdir

   
    def getURL(self):
        """
        @return: the URL to the directory where the job is executed
        @rtype: string
        """
        url = Mobyle.JobState.path2url( self.tmpdir )
        return url

    def getService( self ):
        """
        @return: the instance of the service used for this job
        @rtype: Service
        """
        return self.service

    def getEmail( self ):
        """
        @return: the email of the user or None if there is no email
        @rtype: string or None
        """
        return self.email




    def run( self ):
        """
        Run the Job (instanciate a CommandRunner)
        @call: L{MobyleJob.run <MobyleJob>}
        """
        import Mobyle.RunnerFather
        
        if self.jobState is None:
            
            msg = "you must make an environement for the job before running it"
            self._logError( admMsg = "Job.toFile : " + msg ,
                            logMsg = msg ,
                            userMsg = "Mobyle Internal server error"
                            )
            
            raise MobyleError, msg

        self.jobState.update()
        
        self.jobState.setStatus( 1 ) #submitted

        evaluator = self.service.getEvaluator()

        self.runner = Mobyle.RunnerFather.CommandRunner( self , synchron= self.synchron  )

        cmdLine = self.runner.getCmdLine()

        debug = self.cfg.debug( self.service.getName() )

        if debug > 0 and debug < 3:
            self.jobState.setStatus( 4 ) #finished
            self.jobState.commit()
        else:
            if self.email is not None:
                jobExist , msg = self.isExists( self.email.To , cmdLine )
            else:
                jobExist = False
            if jobExist :
                msg = "you have already submitted a similar job" 
                self._logError( admMsg = "Job.run : " + msg ,
                                logMsg = msg ,
                                userMsg = msg
                                )

                raise UserValueError( parameter = None, msg = msg )

            else:
                self.runner.run()
        

    def kill( self ) :
        """@todo: kill the job"""
        raise NotImplementedError , "ToDo"


    def isExists( self, email , cmdLine ):
        """
        @param email:
        @type email: string
        @param cmdLine:
        @type cmdLine: string
        """
        newMd5 = md5.new()
        newMd5.update( email )

        try:
            remote = os.environ[ 'REMOTE_HOST' ]
            if not remote :
                try:
                    remote = os.environ[ 'REMOTE_ADDR' ]
                except KeyError :
                    remote = 'local'
        except KeyError:
            try:
                remote = os.environ[ 'REMOTE_ADDR' ]
            except KeyError:
                remote = 'local'
                
        newMd5.update( remote )
        newMd5.update( cmdLine )
        newDigest = newMd5.hexdigest()
        self.adm.refresh() #est ce utile ?
        self.adm.setMd5( newDigest )
        self.adm.commit()

        #batch.number.name.md5
        mask = os.path.normpath( "%s/ADMINDIR/*.*.%s" %(
            self.cfg.results_path() ,
            self.service.getName()
            )
                                 )
        jobs = glob.glob( mask )
        exist = False
        msg = None
        
        for job in jobs:
            oldAdUtils.Admin( job )
            oldDigest = oldAdm.getMd5()

            if newDigest == oldDigest :
                oldStatus = oldAdm.getStatus() 

                if oldStatus != 'finished':
                    exist = True
                    date = time.strftime( "%x %X" , self.adm.getDate() )
                    now = time.localtime()
                    
                    msg = "a similar job have been already submitted the %s, it's status is %s.\n please wait the results of this job before resubmit it." % (
                        date ,
                        oldStatus
                        )
                    break
                
        return ( exist , msg )



    def _logError( self , admMsg = None , userMsg = None , logMsg = None ):

        if  admMsg :
            self.adm.setStatus( 5 , admMsg )
            self.adm.commit()

        if userMsg :
            self.jobState.setStatus( 5 , userMsg )
            self.jobState.commit()

        if logMsg :
            j_log.error( "%s : %s : %s" %( self.service.getName() ,
                                          self.getKey() ,
                                          logMsg
                                          )
                        )
