"""
manage the information in the index.xml
"""
#import sys
import os,os.path

import Ft.Xml , Ft.Xml.Domlette
from Ft.Xml import EMPTY_NAMESPACE


from time import localtime, strftime
import urllib2 , urlparse
import re
import types
#import md5

import logging
js_log = logging.getLogger('mobyle.jobstate' )

from Mobyle.MobyleError import *
import Mobyle.ConfigManager
#import Mobyle.Pipeline
import Mobyle.Utils
#import Mobyle.Service
import Mobyle.Parser

_cfg = Mobyle.ConfigManager.Config()

_extra_epydoc_fields__ = [('call', 'Called by','Called by')]



"""
G{classtree _abstractState , JobState , ServiceState , PipelineState }
"""



def path2url( dir ):
    """
    translate a directory absolute path in mobyle tree into an url in Mobyle 
    @param dir: the directory to translate this dir should be in Mobyle tree. Doesn't check if the path exist
    @type dir: string
    @return: an url http coresponding to the directory dir
    @rtype: string
    @raise MobyleError: -L{MobyleError}
    """
    cfg_dirs = _cfg.dirs()
    tmpdir = os.path.normpath( cfg_dirs['results_path'] ) #remove the ending slash
    begin = dir.find(tmpdir )
            
    if begin != -1:
        end = begin + len( tmpdir )
        extrapath = dir[end:]
                
        ## if the 2nd argument of os.path.join begin by "/"
        ## it return only the second arg
        for i in range( 0 , len( extrapath )):
            if extrapath[i] == os.path.sep :
                continue
            else:
                break
    else:
        msg = str( dir ) + " is not Mobyle directory compliant "
        js_log.error( msg )
        raise MobyleError , msg
    
    extrapath = os.path.join( cfg_dirs['results_url'] , extrapath[i:] )
    return str( urlparse.urljoin(  cfg_dirs['root_url'] , extrapath ) )



def url2path( url ):
    """
    translate an url ( in Mobyle ) in a dir into Mobyle tree
    @param url: the url to translate this url should be in Mobyle 
    @type url : string
    @return : the absolute path corresponding to url
    @rtype: string
    @raise MobyleError : -L{MobyleError}
    """
    protocol , host , path , a,b,c = urlparse.urlparse( url )
    cfg_dirs = _cfg.dirs()
    if ( protocol + "://"+ host ) != cfg_dirs['root_url'] :
        msg =  "url2path: " + str( url ) + " is not Mobyle url compliant "
        js_log.error( msg )
        raise MobyleError, msg

    tmpurl = cfg_dirs['results_url']
    match = re.search( tmpurl , path)
    if match:
        begin , end = match.span()
        extrapath = path[ end : ]
        if extrapath[0] == os.sep:
            extrapath = extrapath[ 1 : ]

        return os.path.normpath( os.path.join( cfg_dirs['results_path'] , extrapath ))
    else:
        msg = "url2path: " + str( url ) + " is not Mobyle url compliant "
        js_log.error( msg )
        raise MobyleError , msg



def normUri( uri ):
    """
    normalize the uri
      - if the uri is a distant url , return the url of the directory containing the index.xml
      - if the uri is an local url , return the absolute path
      - if the uri is a local path , return the absolute path
    @param uri:
    @type uri: string
    @return: a normalize uri
    @rtype: string
    @raise: MobyleError if the uri is not a path or uri protocol is not http or file
    """
    
    protocol ,host, path, a,b,c = urlparse.urlparse(uri)
    
    if protocol == 'file' or protocol == '':
        path = os.path.abspath( os.path.join( host , path ) )        
    elif protocol == 'http':
        try:
            root_url =  _cfg.root_url()
            
            if root_url[:7] == 'http://':
                root_url = root_url[7:]

        except AttributeError:
            root_url == '_no_host_defined_'

        if host == root_url:
            path = url2path( uri )
        else:            
            path = uri
    else:
        raise MobyleError, "Mobyle doesn't support this protocol: " + str( protocol )

    if path[-10:] == "index.xml":
        path = path[:-10]

    if path[-1] == '/':
        path = path[:-1]
        
    return path
    


def getContentFile( uri ):
    """
    @param uri: the url or a path (absolut or relativ) to a file
    @type uri: string
    @return: the content of the file designing by uri as a string
    @rtype: string
    @raise: MobyleError , if the protocol is not supported
    """

    protocol , host , path , a,b,c = urlparse.urlparse( uri )
    if protocol == '' or protocol == 'file':
        if not os.path.isabs( path ):
            if protocol == 'file':
                path = os.path.abspath( os.path.join( host,path ))
            else:
                path = os.path.abspath( path )
        try:
            fh = open( path , 'r' )
            
        except IOError, err:
            msg = "getContentFile : " + str( err )
            #js_log.error( msg ) # normal la premiere fois ne plus logger
            raise MobyleError ,err
        
    elif protocol == 'http':
        try:
            fh = urllib2.urlopen( uri )
        except urllib2.HTTPError,err:
            msg = str( err )
            js_log.error( msg )
            raise MobyleError , err
    else:
        raise MobyleError, "Mobyle doesn't support " + protocol + " protocol"
    
    content = ''
    l = fh.readline()
    while l:
        content = content + l
        l = fh.readline()

    fh.close()
        
    return content





class _abstractState( object ):
    
    STATUS = Mobyle.Utils.code2status
        
    def __init__(self, uri = None , domTree = None):

         if uri:
            if uri[-10:] == "index.xml":
                uri = uri[:-10]

            if uri[-1] == '/':
                uri = uri[:-1]

            self.uri =  uri #the uri of the directory
            self._MyUri = normUri( uri )
            protocol ,host, path, a,b,c = urlparse.urlparse( self._MyUri )

            if protocol == 'http':
                self._islocal = False
                indexUri = self._MyUri+"/index.xml"
            else:
                if self._MyUri.find( _cfg.results_path() ) == -1:
                    msg = "the "+ str( self._MyUri ) + " is not a Mobyle directory "
                    js_log.error( msg )
                    raise MobyleError, msg

                if not os.path.exists( self._MyUri ):
                    msg = "no such file or directory : "+ str( self._MyUri )
                    js_log.error( msg )
                    raise MobyleError, msg

                if not os.path.isdir( self._MyUri ):
                    msg = self._MyUri + " is not a directory"
                    js_log.error( msg )
                    raise MobyleError , msg

                indexUri = os.path.join( self._MyUri , "index.xml" )
                self._islocal= True

            self.indexName = indexUri


            try:
                tree = getContentFile( indexUri )
                self._parse( tree )
            except MobyleError , err:
                if self._islocal:
                    self._createDocument()
                else:
                    msg = "can't create index file "+str( err )
                    js_log.error( msg )
                    raise MobyleError , msg

         elif domTree:
             self.doc = domTree
             self.root = self.doc.documentElement
         else:
             msg = "you should provide either an uri or a dom tree"
             js_log.error( msg )
             raise MobyleError , msg
    

    def _parse(self, tree = None ):
        """
        parse a xml string or a file containing a xml tree
        """
        if tree is None:
            tree = getContentFile( self._MyUri + "/index.xml" )

        self.doc = Ft.Xml.Domlette.NoExtDtdReader.parseString( tree ) 
        
        self.root = self.doc.documentElement
        

    def update(self):
        """
        update the document the file index.xml
        """
        self._parse()



    def _updateNode(self, node , nodeName , content ):
        """
        replace the content of the text_node child of a node by content. if the node nodeName doesn't exist, it make it
        @param nodeName: the name of the Node to update
        @type nodeName: String
        @param content: the content of the text-node child of nodeName
        @type content: String
        """
        nodes = node.xpath( ".//" + nodeName ) #est ce nessecaire de faire une recherche recursive
        text_node = self.doc.createTextNode( str( content ) )
        if nodes:
            nodes[0].replaceChild( text_node , nodes[0].firstChild )
            
        else:
            newNode = self.doc.createElementNS( EMPTY_NAMESPACE , nodeName )
            newNode.appendChild( text_node )
            node.appendChild( newNode )


    def _addTextNode( self, node , nodeName , content , attr = None):
        """ 
        add a text node named nodeName with content to the node node
        @param node: the node on which the new node will append 
        @type node: node element
        @param nodeName: the name of the new node
        @type nodeName: string
        @param content: the content of the new node
        @type content: string
        """

        newNode = self.doc.createElementNS( EMPTY_NAMESPACE , nodeName )
        if attr:
            for attrName in attr.keys():
                newNode.setAttributeNS( EMPTY_NAMESPACE , attrName , str( attr[ attrName ] ) )
        
        text_node = self.doc.createTextNode( str( content ) )
        newNode.appendChild( text_node )
        node.appendChild( newNode )



    def commit( self ):
        """
        write into the file index.xml in the working directory 
        @todo: peut ecrire dans un xml distant ?? ou juste y lire ??
        si oui a reecrire completement pour tenir compte des adresses distantes
        sinon mettre un test et bloquer toutes tentatives
        """
       
        if self._MyUri.find("http://") != -1:
            raise MobyleError, "can't modify a distant xml"
        else:
            try:
                fh = open( self.indexName , 'w' )
                #fh.write( self.doc.toxml() )
                #the toprettyxml method doesn't work well
                #add \n\t behind each <tag> thus the @ each writing pass
                #the PrettyPrint function in xml.dom.ext work better :)
                
                Ft.Xml.Domlette.PrettyPrint( self.doc , fh )
                fh.close()
            except IOError, err:
                js_log.error( "IOError during write index.xml on disk")
                raise MobyleError ,err






class JobState( object ):
    """
    the JobState Object manage the informations in index.xml file
    G{}
    """
    _refs = {}
    
    def __new__( cls , uri = None ):
        

        state = None
        
        if uri is None:
            uri = os.getcwd()

        if uri[-9:] == "index.xml":
            uri = uri[:-9]

        if uri[-1] == '/':
            uri = uri[:-1]
        MyUri = normUri( uri ) 
        protocol ,host, path, a,b,c = urlparse.urlparse( MyUri )
        if protocol == 'http':
            islocal = False
            indexUri = MyUri + "/index.xml"
        else:
            results_path = _cfg.results_path() 
            if MyUri.find( results_path ) == -1:
                msg = "the "+ str( MyUri ) + " is not a Mobyle directory "
                js_log.error( msg )
                raise MobyleError, msg

            if not os.path.exists( MyUri ):
                msg = "no such directory : " +  str( MyUri )
                js_log.error( msg )
                raise MobyleError, msg

            if not os.path.isdir( MyUri ):
                msg = MyUri + " is not a directory"
                js_log.error( msg )
                raise MobyleError, msg

            indexUri = os.path.join( MyUri , "index.xml" )
            islocal = True
            
        try:
            return cls._refs[ MyUri ]
        except KeyError:
            self = super( JobState , cls ).__new__( cls )
            self.state = state
            self.uri = uri        #uri given by the user
            self._MyUri = MyUri   #path if uri = local url if uri is distant
            self._islocal = islocal
            
            try:
                tree = getContentFile( indexUri )
                doc = Ft.Xml.Domlette.NoExtDtdReader.parseString( tree )
                root = doc.documentElement

                if root.nodeName == "jobState":
                    self.state = ServiceState( domTree = doc )
                elif root.nodeName == "mobyle":
                    self.state = PipelineState( domTree = doc )
                else:
                    msg = "the index.xml file in the directory , %s , is not a Mobyle state " % workdir
                    js_log.error( msg )
                    raise MobyleError , msg

                self.state.uri = self.uri
                self.state._MyUri = self._MyUri
                self.state.indexName = indexUri  
                self.state._islocal = self._islocal
            except MobyleError :
                pass #si il n'existe pas de index.xml
            cls._refs[ MyUri ] = self
            return self



        

    def __getattr__( self , name ):
        if self.state :
            return getattr( self.state , name )
        else:
            msg = "Jobstate instance is empty. you must create a State before"
            raise MobyleError , msg


    def createState( self , flag ):
        if self.state :
            if self.state.isService():
                if flag.upper() == "SERVICE":
                    msg = "Can't create a new ServiceState, a ServiceState alredy exist"
                else:
                    msg = "Can't create a PipelineState, a ServiceState alredy exist"

            else:
                if flag.upper() == "SERVICE":
                    msg = " Can't create a ServiceState, a PipelineState alredy exist "
                else:
                    msg = "Can't create a new PipelineState, a PipelineState alredy exist"
                    
            raise MobyleError , msg

        else:
           
            if flag.upper() == "SERVICE":
                if self._islocal:
                    self.state = ServiceState( uri = self._MyUri )
                else:
                    msg ="can't create a State on a distant Mobyle Server"
                    raise MobyleError , msg
            elif flag.upper() == "PIPELINE":
                if self._islocal:
                    self.state = PipelineState( uri = self._MyUri )
                else:
                    msg ="can't create a State on a distant Mobyle Server"
                    raise MobyleError , msg

            else:
                raise MobyleError 

        
##############################################
#                                            #
#               ServiceState                 #
#                                            #
##############################################


class ServiceState( _abstractState ):
    """
    the JobState Object manage the informations in index.xml file
    """

    
    def isService(self):
        return True

    def isPipeline(self):
        return False
    

    def _createDocument( self ):
        self.doc = Ft.Xml.Domlette.implementation.createDocument( Ft.Xml.EMPTY_NAMESPACE , "jobState" , None )
        #######################################################################
        #
        #            attention pour le moment on met une dtd local estce qu'on passe
        #            en dtd public
        #            
        doctype_path = os.path.normpath( os.path.join( os.environ[ 'MOBYLEHOME'], 'mobyle.dtd' ) )
        self.doc.systemId = 'file://' + doctype_path
        ########################################################################
        self.root = self.doc.documentElement
        pi = self.doc.createProcessingInstruction(
            'xml-stylesheet' ,
            'href="%s/%s/xsl/job.xsl" type="text/xsl"' % ( _cfg.root_url() ,
                                                                _cfg.htdocs_url() )
            )
        self.doc.insertBefore( pi , self.root )


    def getOutputs( self ):
        """
        @return: a list of tuples or None
                  -each tuple is composed with 2 elements a parameter and a list of files
                  -each file is a tuple with the file name and the format if it's known or None 
        @rtype: [ ( parameter , [ (fileName , format or None ) , ...) , ... ]
        @todo : la liste des fichiers pourraient etre considere comme la valeur de ce paramettre
                mais setValue utilise convert?? on ne doit pas convertir une valeur en sortie ?
                que signifie la valeur d'un paramettre de type sequence?
                   - le nom du fichier contenant la sequence
                   - le contenu de celui ci ?
                il faudrait certainemnt avoir un niveau d'abstraction intermediaire entre la valeur
                et comment il est physiquement sur la machine un objet data.
                cet objet nous serait certainement utile pour les workflows 
        """
        self._parse( )
        outputNodes = self.root.xpath( "./data/output")
        res = []
        
        for outputNode in outputNodes:
            for childNode in outputNode.childNodes :            
                if childNode.nodeType == childNode.ELEMENT_NODE and childNode.nodeName == 'parameter':                   
                    parameterNode = childNode
                    break
            
            sParser = Mobyle.Parser.ServiceParser( _cfg )   
            parameter = sParser.parseParameter( parameterNode )
            
            files =[]
            fileNodes = outputNode.xpath( "./file" )
            for fileNode in fileNodes:
                filename = fileNode.xpath( './text()' )[0].data
                size = fileNode.xpath( "./@size")[0].value
                try:
                    fmt = fileNode.xpath( "./@fmt")[0].value
                except IndexError:
                    fmt = None
                files.append( ( str( filename ) , long( size ), str( fmt ) ) )
            
            res.append( ( parameter , files ) )
            
        if res:
            return res
        else:
            return None
            
    def getOutput( self , parameterName ):
        """
        @param parameterName: the name of a parameter which produce result
        @type parameterName: string
        @return: a list containing the results filename. if there isn't any result for this parameter, return None
        @rtype: list of strings or None
        """
        self._parse( )
        fileNodes = self.root.xpath( "./data/output[ parameter/name = '" + parameterName + "' ]/file/text()" )

        files =[]
        for fileNode in fileNodes:
            filename =  str( filenode.firstChild.nodeValue ) 
            size = long( fileNode.xpath( './@size')[0].value )
            try:
                fmt = fileNode.xpath( "./@fmt")[0].value
                fmt = str( fmt )
            except IndexError:
                fmt = None
            files.append( ( filename , size , fmt ) )

        if files:
            return files
        else:
            return None



    def getInputFiles( self ):
        """
        @return: a list of tuples or None
                  -each tuple is composed with 2 elements, a parameter and a list of files
                  -each file is a tuple of 3 elements with the file name , the size and the format if it's known or None 
        @rtype: [ ( parameter , [ (str fileName , int size, str format or None ) , ...) , ... ]
        @todo : la liste des fichiers pourraient etre considere comme la valeur de ce paramettre
                mais setValue utilise convert?? on ne doit pas convertir une valeur en sortie ?
                que signifie la valeur d'un paramettre de type sequence?
                   - le nom du fichier contenant la sequence
                   - le contenu de celui ci ?
                il faudrait certainemnt avoir un niveau d'abstraction intermediaire entre la valeur
                et comment il est physiquement sur la machine un objet data.
                cet objet nous serait certainement utile pour les workflows 
        """
        self._parse( )
        inputNodes = self.root.xpath( "./data/input")
        res = []
        
        for inputNode in inputNodes:
            for childNode in inputNode.childNodes :            
                if childNode.nodeType == childNode.ELEMENT_NODE and childNode.nodeName == 'parameter':                   
                    parameterNode = childNode
                    break
            
            sParser = Mobyle.Parser.ServiceParser( _cfg )   
            parameter = sParser.parseParameter( parameterNode )
            
            if parameter.isInfile():
                files =[]
                fileNodes = inputNode.xpath( "./file" )
                formattedFileNodes = inputNode.xpath( "./formattedFile" )
                fileNodes += formattedFileNodes

                for fileNode in fileNodes:
                    fileName= str( fileNode.xpath('./text()')[0].data )
                    size = long( fileNode.xpath( "./@size")[0].value )
                    try:
                        fmt = fileNode.xpath( "./@fmt")[0].value
                        fmt = str( fmt )
                    except IndexError:
                        fmt = None
                    
                    files.append( ( fileName , size , fmt ) )
                
                res.append( ( parameter , files ) )
                
        if res:
            return res
        else:
            return None
            

    def getInput( self , parameterName ):
        """
        @param parameterName: the name of a parameter which produce result
        @type parameterName: string
        @return: a list containing the filename , the size , and the format of each results. if there isn't any result for this parameter, return None
        @rtype:  ( string fulename , long size , string fmt or None ) , ... ]
        """
        self._parse( )
        fileNodes = self.root.xpath( "./data/input[ parameter/name = '" + parameterName + "' ]/file/text()" )

        files =[]
        for fileNode in fileNodes:
            filename =  str( filenode.firstChild.nodeValue ) 
            size = long( fileNode.xpath( './@size')[0].value )
            try:
                fmt = fileNode.xpath( "./@fmt")[0].value
                fmt = str( fmt )
            except IndexError:
                fmt = None
            files.append( ( filename , size ,  fmt ) )
        if files:
            return files
        else:
            return None



    def mainResult( self ):
        """
        @return: le nom ou un filehandle du fichier principal?
        @todo:Not Yet implemented
        """
        raise NotYetImplementedError 

    
    
        
    def getStatus( self ):
        """
        @return: the status of the job
        @rtype: string
        """
        self._parse()
        try:
            status = self.root.xpath( "./status/value/text()" )[0].data
        except IndexError:
            return ( None , None )
            
        try:
            message = self.root.xpath( "./status/message/text()" )[0].data
        except IndexError:
            return ( str( status ) , None)
            
        return ( str( status ) , str( message ) )

    

    def setStatus( self , status , msg = None ):
        """
        update the node status or if this node doesn't exist, make it
        @param status: the status of the job the accepted values are in L{STATUS}
        @type status: int
        """

        if self.STATUS.has_key( status ):
            newStatus = self.doc.createElementNS( EMPTY_NAMESPACE , 'status' )
            try:
                self._addTextNode( newStatus , 'value', self.STATUS[ status ] )
            except KeyError:
                raise MobyleError, "status code out of range:"+str( status )

            if msg:
                self._addTextNode( newStatus , 'message', msg )
            
            try:
                oldStatus = self.root.xpath( './status' )[0]
            except IndexError:
                self.root.appendChild( newStatus )
            else :
                self.root.replaceChild( newStatus , oldStatus )
        else:
            raise MobyleError, "invalid status :" + str( status )



    def getDir( self ):
        """
        @return: the absolute path to the directory where the job is executed
        @rtype: string
        @raise: MobyleError when the jobID is not local
        """
        if  self._islocal :
            return self._MyUri
        else:
            raise MobyleError, "it's not a local job :" + self._MyUri
    
  
        
    def getID( self ):
        """
        @return: the id of the job 
        @rtype: string
        """
        try:
            self._parse()
            return str( self.root.xpath( "./id/text()" )[0].data ) 
        except IndexError:
            msg = "the element \"id\", doesn't exist"
            js_log.error( msg )
            raise MobyleError , msg


    def setID( self , ID ):
        """
        set the node id or if this node doesn't exist make it
        @param id: the job identifier (the url corresponding to the working directory). 
        @type id: String:
        """
        self._updateNode( self.root , 'id' , ID )

        
    def getSessionKey( self ):
        """
        @return: the key of the session
        @rtype: string
        """
        try:
            self._parse()
            return str( self.root.xpath( "./sessionKey/text()" )[0].data )
        except IndexError:
            return None
    

    def setSessionKey( self , sessionkey ):
        """
        Set the sessionkey of this workflow to sessionkey
        @param sessionkey: the sessionkey of this workflow
        @type sessionkey: string
        """
        self._updateNode( self.root , 'sessionKey' , sessionkey )

        
    def isFinished( self ):
        """ 
        @return: True if the job is finished, false Otherwise
        @rtype: boolean
        """
        status = self.getStatus()[0] #the tree is updated in getStatus
        if status == "finished":
            return True
        else:
            return False


    def getCommandLine( self ):
        """
        @return: the Command line
        @rtype: string
        """
        try:
            self._parse()
            return str( self.root.xpath( "./commandLine/text()" )[0].data )
        except IndexError:
            return None


    def setCommandLine( self , command ):
        """
        update the node command or if this node doesn't exist, make it
        @param command: the command of the job. 
        @type command: String:
        """
        self._updateNode( self.root , 'commandLine' , command )

    
    def getName( self ):
        """
        @return: the name of the job
        @rtype: string
        """
        try:
            self._parse()
            return str( self.root.xpath("./name/text()" )[0].data )
        except IndexError:
            msg = "the element: \"name\" doesn't exist"
            js_log.error( msg )
            raise MobyleError , msg



    def setName( self , name):
        """
        update the node name or if this node doesn't exist make it
        @param name: the name of the service. 
        @type name: String:
        """
        self._updateNode( self.root , 'name' , name )
            

    def getDate( self):
        """
        @return: the date of the job the date format is: "%x %X"
        @rtype: string
        """
        try:
            self._parse()
            return str( self.root.xpath("./date/text()")[0].data )

        except IndexError:
            msg = "the element: \"date\" doesn't exist"
            js_log.error( msg )
            raise MobyleError , msg




    def setDate( self, date= None):
        """
        update the node date or if this node doesn't exist make it
        @param date: the date. 
        @type date: String:
        """
        if date is None:            
            date = strftime( "%x  %X", localtime() )

        if type( date ) == types.StringType :
            date = strptime(  date , "%x  %X")
        else: # I assume the date is a <type 'time.struct_time'>
            date = strftime( "%x  %X", date )

        self._updateNode( self.root , 'date' , date )
        
        
    def getEmail( self):
        """
        @return: the email of the user
        @rtype: string
        """
        try:
            self._parse()
            return str( self.root.xpath("./email/text()" )[0].data )
        except IndexError:
            return None
        
    
    def setEmail( self, email ):
        """
        set the node email or if this node doesn't exist, make it
        @param email: the status of the job. 
        @type email: String:
        """
        self._updateNode( self.root , 'email' , email )

    
    def getStdout( self ):
        """
        we assume that the standart output was redirect in programName.out
        @return: the content of the job stdout as a string
        @rtype: string
        @raise MobyleError: if the job is not finished a L{MobyleError} is raised
        """
        status = self.getStatus()
        if status[0] == "finished" or status[0] == "error" or status[0] == "killed":
            try:
                outName = self.root.xpath( './data/output/parameter[@isstdout = 1] /name/text()' )[0].data
            except IndexError:
                outName = self._MyUri + "/"+ self.getName() + ".out"
            
            return getContentFile( outName )
          
        else:
            raise MobyleError,"the job is not finished"
    

    def getOutputFile( self, fileName ):
        """
        @param fileName:
        @type fileName: String
        @return: the content of a output file as a string
        @rtype: string
        @raise exception: 
        """
        status = self.getStatus()
        if status[0] == "finished" or status[0] == "error" :
            return getContentFile( self._MyUri + "/" + fileName )
        else:
            raise MobyleError, "the job " + self._MyUri + " is not finished"


    def open( self, fileName ):
        """
        return an file object if the file is local or a file like object if the file is distant
        we could apply the same method on this object: read(), readline(), readlines(), close(). (unlike file the file like object doesn't implement an iterator).
        @param fileName: the name of the file (given by getResults).
        @type fileName: string
        @return: a file or file like object
        """
        if self._islocal :
            try:
                fh = open( os.path.join( self._MyUri, fileName ), 'r' )
            except IOError, err:
                raise MobyleError ,err

        else:
            try:
                fh = urllib2.urlopen( self._MyUri +'/'+ fileName )
            except urllib2.HTTPError,err:
                raise MobyleError ,err
        return fh
    

    def getStderr( self ):
        """
        @return: the content of the job stderr as a string
        @rtype: string
        @raise MobyleError: if the job is not finished a L{MobyleError} is raised
        """
        status = self.getStatus()
        
        if status[0] == "finished" or status[0] == "error" or status[0] == "killed":     
            try:
                errname = self._MyUri + "/"+ self.getName() + ".err"
                return getContentFile( errname )
            except KeyError:
                return None
        else:
            raise MobyleError,"the job is not finished"


        

    def setHost( self, host ):
        """
        update the node host or if this node doesn't exist make it
        @param host: the host of the job. 
        @type host: String:
        """
        self._updateNode( self.root , 'host' , host  )



    def setInputDataFile( self , paramName , paramPrompt , paramType , File , fmtProgram = None  , formattedFile = None ):
        """
        if the node result exist add new nodes for files, othewise create a new node results and add nodes for files
        @param paramName: the parameter name to update or create
        @type paramName: string
        @param promt: the prompt L{Parameter} of this parameter
        @type prompt: ( string prompt , string lang )
        @param paramType: the parameter Type 
        @type paramType: a MobyleType instance
        @param files: a tuple of fileName , size , the datat format
        @type files: list of tuple ( string fileName , int , string format or None )
        """

        try:
            inputNode = self.root.xpath( './data/input/parameter[ name = '+ paramName + ' ]')[0]
            raise MobyleError , "this input data already exist " + paramName  
        except IndexError :
            try:
                dataNode = self.root.xpath( './data' )[0]
            except IndexError :
                dataNode = self.doc.createElementNS( EMPTY_NAMESPACE , 'data' )
                self.root.appendChild( dataNode )

            if type( paramPrompt ) == types.StringType :
                paramPrompt = ( paramPrompt , _cfg.lang() )

            inputNode = self._createInOutNode( 'input', paramName , paramPrompt , paramType )
            dataNode.appendChild( inputNode )
            
            fileName , size , fmt = File
            attr = {}
            attr[ 'size' ] = str( size ) 
            if fmt :
                attr[ 'fmt' ] = fmt
            self._addTextNode( inputNode , 'file' , os.path.basename( fileName ) , attr )    
            
 
            if fmtProgram :
                self._addTextNode( inputNode , 'fmtProgram' , fmtProgram )
            
            if formattedFile :
                formattedFileName , formattedSize , formattedFmt = formattedFile
                attr = {}
                attr[ 'size' ] =  str( formattedSize )
                if formattedFmt :
                    attr[ 'fmt' ] = formattedFmt
                      
                self._addTextNode( inputNode , 'formattedFile' , os.path.basename( formattedFileName ) , attr  )
                
                
                
    def setInputDataValue( self , paramName , paramPrompt , paramType , value  ):
        """
        if the node result exist add new nodes for files, othewise create a new node results and add nodes for files
        @param paramName: the parameter name to update or create
        @type paramName: string
        @param promt: the prompt L{Parameter} of this parameter
        @type prompt: ( string prompt , string lang )
        @param paramType: the parameter Type 
        @type paramType: a MobyleType instance
        @param files: a fileName or a sequence of fileName
        @type files: a String or a sequence of Strings
        """

        try:
            inputNode = self.root.xpath( './data/input/parameter[ name = "'+ paramName + '" ]')[0]
            raise MobyleError , "this input data already exist " + paramName
        except IndexError :
            try:
                dataNode = self.root.xpath( './data' )[0]
            except IndexError :
                dataNode = self.doc.createElementNS( EMPTY_NAMESPACE , 'data' )
                self.root.appendChild( dataNode )

            if type( paramPrompt ) == types.StringType :
                paramPrompt = ( paramPrompt , _cfg.lang() )

            inputNode = self._createInOutNode( 'input', paramName , paramPrompt , paramType )
            try:
              firstoutputNode = self.root.xpath( './data/output')[0]
              dataNode.insertBefore( inputNode , firstoutputNode )
            except IndexError :
              dataNode.appendChild(inputNode)
            
            self._addTextNode( inputNode , 'value' , str( value ) )
    
    
    
    def setOutputDataFile( self , paramName , paramPrompt , paramType , files , isstdout = False ):
        """
        if the node result exist add new nodes for files, othewise create a new node results and add nodes for files
        @param paramName: the parameter name to update or create
        @type paramName: string
        @param promt: the prompt L{Parameter} of this parameter
        @type prompt: ( string prompt , string lang )
        @param paramType: the parameter Type 
        @type paramType: a MobyleType instance
        @param files: a list where each element are composed of 3 item ( fileName , size , format )
        @type files: [ ( string , int , string or None ) , ... ] 
        """

        try:
            outputNode = self.root.xpath( './data/output/parameter[ name = '+ paramName + ' ]')[0]
            raise MobyleError , "this output data already exist " + paramName
        except IndexError :
            try:
                dataNode = self.root.xpath( './data' )[0]
            except IndexError :
                dataNode = self.doc.createElementNS( EMPTY_NAMESPACE , 'data' )
                self.root.appendChild( dataNode )
            
            if type( paramPrompt ) == types.StringType :
                paramPrompt = ( paramPrompt , _cfg.lang() )
            
            if  isstdout:
                outputNode = self._createInOutNode( 'output', paramName , paramPrompt , paramType , paramAttrs = {'isstdout' : '1' } )
            else:
                outputNode = self._createInOutNode( 'output', paramName , paramPrompt , paramType )
            
            dataNode.appendChild( outputNode )
        
        for File in files:
            filename , size , fmt = File
            attr = {}
            attr[ 'size' ] = str( size )
            if fmt:
                attr [ 'fmt' ] = fmt
            self._addTextNode( outputNode , 'file' , os.path.basename( filename ) , attr = attr )


              
                    
    def _createInOutNode( self , io , paramName , paramPrompt , paramType , paramAttrs = {} ):
        
        if io != 'input' and io != 'output' :
            raise MobyleError , "io could take only 'input' or 'output' as value"
        
        inOutputNode = self.doc.createElementNS( EMPTY_NAMESPACE , io )

        parameterNode = self._createParameter(  paramName , paramPrompt , paramType  , attrs = paramAttrs)
        inOutputNode.appendChild( parameterNode )
        
        return inOutputNode
    
 
 
    def _createParameter( self , paramName , paramPrompt , paramType , attrs = {}):       

        newParameterNode = self.doc.createElementNS( EMPTY_NAMESPACE , "parameter" )
        
        if attrs :
            for attr in attrs:
                newParameterNode.setAttributeNS( EMPTY_NAMESPACE , attr , str( attrs[ attr ] ) )
                 
        self._addTextNode( newParameterNode , 'name' , paramName )
                        
        newTypeNode = paramType.toDom()
        newParameterNode.appendChild( newTypeNode )

        if paramPrompt and paramPrompt[0]:
            
            if paramPrompt[1]:
                self._addTextNode( newParameterNode , 'prompt' , paramPrompt[0] , attr = { "lang" : paramPrompt[1] } )
            else:
                self._addTextNode( newParameterNode , 'prompt' , paramPrompt[0] , attr = { "lang" : _cfg.lang() } )

        return newParameterNode




    def delInputData( self , paramName ):
        try:
            inputDataNode = self.root.xpath( "./data/input[ parameter/name = '" + paramName + "' ]")[0]
        except IndexError:
            raise MobyleError, "there is no data with parameter named:" + str( paramName )            
        else:
            dataNode = self.root.xpath( "./data")[0]
            dataNode.removeChild( inputDataNode )



    def getArgs( self ):
        """
        @return: 
        @rtype:
        """
        inputDataNodes = self.root.xpath( './data/input' )
        args = {}
        
        for inputDataNode in inputDataNodes:
            """
            toutes les valeurs meme les noms de fichiers
            nom : value
            """
            try:
                value = inputDataNode.xpath( './value/text()' )[0].data
            except IndexError:
                try:
                    value = str( inputDataNode.xpath( './formattedFile/text()' )[0].data )
                except IndexError:
                    try:
                        value = inputDataNode.xpath( './file/text()' )[0].data
                    except IndexError:
                        raise MobyleError , "1 input sans value ni file"
                    
            name = str( inputDataNode.xpath( './parameter/name/text()' )[0].data )
            args[ name ] = value
            
        return args     
               
    
    def getPrompt( self , paramName ):
        """
        @param paramName: a parameter name
        @type paramName: string
        @return: the prompt of this parameter
        @rtype: string
        """
        try:
            prompt = self.root.xpath( './data/*/parameter[ name = "' + paramName + '"]/prompt/text()' )[0].data
            return prompt
        except IndexError:
            return None
    
    
    def getFormattedData( self ):
        
            """
            for input files return a dict like cas des input files uniquement
                  file: valeur
                  fileFmt: valeur
                  program: valeur
                  formattedFile: valeur
                  formattedFileFmt: valeur
            """
            inputFileNodes = self.root.xpath( './data/input[ file ]' )
            fdata = {}
            
            for inputFileNode in inputFileNodes:
                name = inputFileNode.xpath( './parameter/name/text()' )[0].data
                FileName = inputFileNode.xpath( './file/text()' )[0].data
                fileFmt = inputFileNode.xpath( './file/@fmt' )[0].value
                program = inputFileNode.xpath( './fmtProgram/text()' )[0].data
                try:
                    formattedFile = inputFileNode.xpath( './formattedFile/text()' )[0].data
                    formattedFilefmt = inputFileNode.xpath( './formattedFile/@fmt')[0].value
                except IndexError:
                    formattedFile = None
                    formattedFileFmt = None
                
                fdata[ name ] = { 'file'            : str( FileName ),
                                 'fileFmt'          : str( fileFmt ) ,
                                 'fmtprogram'       : str( program ),
                                 'formattedFile'    : str( formattedFile ),
                                 'formattedFileFmt' : str( formattedFileFmt )
                                 }
                
            return fdata



    def getParamfiles(self):
        """
        @return: a list containing the results filename. if there isn't any result return None
        @rtype: list of tuple ( string filename , long size )
        """
        self._parse( )
        results = []
        for paramf in self.root.xpath( "./paramFiles/file" ):
            filename = paramf.xpath( "./text()" )[0].data
            size = paramf.xpath( "./@size" )[0].value
            results.append( ( str( filename ) , long( size ) ) )
        
        return results






    def setParamfiles( self , files ):
        """
        if the node result exist add new nodes for files, othewise create a new node results and add nodes for files
        param files: a list of fileName , size of file
        type files: [ ( String fileName , Long size ) , ... ]
        """
        paramfiles_node = self.root.xpath( './paramFiles' )
        lastChild = self.root.xpath( './*' )[-1]
        
        if paramfiles_node:
           paramfiles_node  = paramfiles_node[0]
        else:
            paramfiles_node = self.doc.createElementNS( EMPTY_NAMESPACE , 'paramFiles' )
            if lastChild.nodeName == 'commandLine':
                self.root.insertBefore( paramfiles_node , lastChild )
            else:
                self.root.appendChild( paramfiles_node )
                
        for File in files:
            fileName , size = File
            attr = {}
            attr[ 'size' ] = size
            self._addTextNode( paramfiles_node , 'file', fileName , attr )


            

        
##     def __str__(self):
##         return "\n"+self.doc.toxml()
    



##############################################
#                                            #
#               PipelineState                #
#                                            #
##############################################


class PipelineState( _abstractState ):


    def isService( self ):
        return False

    def isPipeline( self ):
        return True

    def _createDocument( self ):
        impl = getDOMImplementation()
        doctype = impl.createDocumentType( '', '', '' )
        self.doc = impl.createDocument( None, "pipeline", None )
        self.root = self.doc.documentElement

    
    def getName( self , stageID= None ):
        """
        @param stageID: the id of a stage 
        @type stageID: int or string
        @return: if stageID is None, returns the name of this workflow. otherwise return the name of the stage 
        @rtype: string, if there isn't element name in pipeline return None
        @raise MobyleError: if there isn't any stage with id stageID
        """
        if stageID is None:
            try:
                return self._getElementValue( self.root , "name" )
            except MobyleError:
                return None
        else:
            return self.getStageName( stageID )
    
    def setName( self, name ):
        """
        Set the name of this workflow to name or if this node doesn't exist, make it
        @param name: the name of this workflow
        @type name: string
        """
        self._updateNode( self.root.getElementsByTagName( 'pipeline' )[0] , 'name' , name )
        

    def getTitle( self ):
        """
        @return: the title of this workflow 
        @rtype: string, if there isn't element title in pipeline return None
        """
        try:
            return self._getElementValue( self.root, "title" )
        except MobyleError:
            return None

    
    def setTitle( self, title ):
        """
        Set the title of this workflow to title
        @param title: the title of this workflow
        @type title: string
        """
        self._updateNode( self.root.getElementsByTagName( 'pipeline' )[0] , 'title' , title )
        

    def getID( self ):
        """
        @return: the id of this workflow
        @rtype: string, if there isn't element id in pipeline return None
        """
        try:
            return self._getElementValue( self.root , "id" )
        except IndexError:
            return None

    
    def setId( self, ID ):
        """
        Set the id (url) of this workflow to id
        @param Id: the id of this workflow
        @type Id: string
        """
        self._updateNode( self.root.getElementsByTagName( 'pipeline' )[0] , 'id' , ID )
        

    def getUserkey( self ):
        """
        @return: the userkey of this workflow
        @rtype: string
        """
        try:
            return self._getElementValue( self.root , "userkey" )
        except MobyleError:
            return None

    
    def setUserkey( self, userkey ):
        """
        Set the userkey of this workflow to userkey
        @param userkey: the userkey of this workflow
        @type userkey: string
        """
        self._updateNode( self.root.getElementsByTagName( 'pipeline' )[0] , 'userkey' , userkey )


    def getEmail( self ):
        """
        @return: the userkey of this workflow
        @rtype: string. 
        """
        try:
            return self._getElementValue( self.root , "email" )
        except MobyleError:
            return None

    def setEmail( self, email  ):
        """
        set the node email or if this node doesn't exist, make it
        @param email: the status of the job. 
        @type email: String:
        """
        self._updateNode( self.root.getElementsByTagName( 'pipeline' )[0] , 'email' , email )



    def _getStageElem( self, stageID ):
        """
        @param stageID: the stage identifier
        @type StageID: String
        @return: the stage with the identifier stageID
        @rtype: xml element. if there isn't stage with stageID return None
        """
        for stage in self.root.getElementsByTagName( "stage" ):
            
            if stage.getAttribute( "id" ) == str( stageID ):
               return stage
        return None
        

    def getStage( self,stageID ):
        """
        @return: the stage corresponding to this workflow
        @rtype: L{Stage} instance
        """
        self._parse( getContentFile( self._MyUri+"index.xml" ))

        stageElem =self._getStageElem( stageID )
        name= self.getStageName( stageElem = stageElem )
        server = self.getServer( stageElem = stageElem )
        args= self.getArgs( stageElem = stageElem )
        date= self.getDate( stageElem = stageElem )
        pipe = self.getPipe( stageElem = stageElem ) 
        
        stage = Pipeline.Stage( stageID , name ,server, args ,date , pipe[0] , pipe[1] )
        return stage
        
    def addStage( self, stageID, name, server, pipesin = None, pipesout = None ):
        """
        add a stage node
        @param stageID: the stage identifier
        @type StageID: String
        @param name: the stage name
        @type name: String
        @param server: the server where the job wil be executed
        @type server: String
        @param pipesin : a list of pipe from a previous stage
        @type pipesin : a list of tuple ( id, String pipetype, String parameterName)
        @param pipesout : a list of pipe toward a next stage
        @type pipesout : a list of tuple ( id, String pipetype, String parameterName)
        """
        if self._getStageElem( stageID ):
            raise MobyleError , "can't add this stage. there is already one with the same id"
        newStageElem = self.doc.createElement( 'stage' )
        newStageElem.setAttribute( "id" , stageID )
        newStageElem.setAttribute( "name" , name )
        newStageElem.setAttribute( "server" , server )
        if pipesin or pipesout:
            self._addpipe( stageElem, pipesin , pipesout )

        self.root.getElementsByTagName( 'pipeline' )[0].appendChild( newStageElem )

        

    def addpipe( self, stageID, pipesin =None, pipesout = None ):
        """
        add a pipe node pipe node to a stage
        @param stageID: the stage identifier
        @type StageID: int
        @param pipesin : a list of pipe from a previous stage
        @type pipesin : a list of tuple ( id, String pipetype, String parameterName)
        @param pipesout : a list of pipe toward a next stage
        @type pipesout : a list of tuple ( id, String pipetype, String parameterName)
        @raise MobyleError: if there isn't any stage with id stageID
        """
        stageElem = self._getStageElem(  stageID )
        if stageElem:
            self._addpipe( stageElem, pipesin , pipesout )
        else:
            raise MobyleError,"no such stage: "+str( stageID )


    def _addpipe( self,stageElem ,pipesin =None, pipesout = None ):
        """
        add a pipe node pipe node to the stageElem
        @param stageElem: an element stage
        @type StageElem: dom element
        @param pipesin : a list of pipe from a previous stage
        @type pipesin : a list of tuple (id, String pipetype, String parameterName)
        @param pipesout : a list of pipe toward a next stage
        @type pipesout : a list of tuple (id, String pipetype, String parameterName)
        """
        if not pipesin and not pipesout:
            raise MobyleError,"there is no pipe !"
        pipeNode = self.doc.createElement( "pipe" )

        if pipesin is not None:
            for pipein in pipesin:
                inNode = self.doc.createTextNode()
                inNode.setAttribute( "id" , pipein[0] )
                inNode.setAttribute( "pipetype" , pipein[1] )
                inNode.setAttribute( "parameter" , pipein[2] )
                pipeNode.appendChild( inNode )
        if pipesout is not None:
            for pipeout in pipesout:
                outNode = self.doc.createTextNode()
                outNode.setAttribute( "id" , pipeout[0] )
                outNode.setAttribute( "pipetype" , pipeout[1] )
                outNode.setAttribute( "parameter" , pipeout[2] )
                pipeNode.appendChild( outNode )

        stageElem.appendChild( pipeNode )

    
    def getPipe( self, stageID = None, stageElem = None ):
        """
        @param stageID: the stage identifier
        @type StageID: int
        @param stageElem: a stage element element 
        @type stageElem: an dom stage element 
        @return: a tuple of 2 list of pipe
          - the 1rs one is the list of pipe in
          - the 2nd one is the list of pipe out
        @rtype: ( [ (int id, String pipetype, String name) ,...],[ (int id, String pipetype, String name) ,...)
        """
        self._parse( getContentFile( self._MyUri+ "index.xml" ))
        if stageID:
            stageElem = self._getStageElem( stageID )
        if stageElem:    
            pipeNode = stageElem.getElementsByTagName( "pipe" )[0]

            pipesin = pipeNode.getElementsByTagName( "in" )
            in_res = []
            for pipein in pipesin:  
                ID = int( pipein.getAttribute( "id" ) )
                pipetype = pipein.getAttribute( "pipetype" )
                parameter = pipein.getAttribute( "parameter" )
                in_res.append( ( ID, pipetype,parameter ) )

            pipesout = pipeNode.getElementsByTagName( "out" )
            out_res = []
            for pipeout in pipesout:
                ID = int( pipeout.getAttribute( "id" ))
                pipetype = pipeout.getAttribute( "pipetype" )
                parameter = pipeout.getAttribute( "parameter" )
                out_res.append( ( ID, pipetype,parameter ) )
        
            return ( in_res , out_res )
        else:
            raise MobyleError, "no such stage: "+str( stageID )
        
    def getStagesID( self ):
        """
        @return: the list of identifiers of all stages
        @rtype: list of int
        @raise MobyleError: if there isn't any stage with id stageID
        """
        self._parse( getContentFile( self._MyUri + "index.xml" ))
        result = []
        for stage in self.root.getElementsByTagName( "stage" ):
           result.append( int( stage.getAttribute( "id" )) )
        return result

    
    def getServer( self,stageID = None , stageElem = None ):
        """
        @param stageID: the stage identifier
        @type StageID: int
        @param stageElem: a stage element element 
        @type stageElem: an dom stage element 
        @return: the url where the stage wil be executed
        @rtype: String
        @raise MobyleError: if there isn't any stage with id stageID
        """
        if stageID:
            self._parse( getContentFile( self._MyUri + "index.xml" ))
            stageElem = self._getStageElem( stageID )

        if stageElem:
            return stageElem.getAttribute( "server" )
        else:
            raise MobyleError, "no such stage: "+str( stageID )

    
    def getStageName( self, stageID = None , stageElem = None ):
        """
        @param stageID: the stage identifier
        @type StageID: int
        @param stageElem: a stage element element 
        @type stageElem: an dom stage element 
        @return: the name of the server where the job is executed
        @rtype: String
        @raise MobyleError: if there isn't any stage with id stageID
        """
        if stageID:
            self._parse( getContentFile( self._MyUri + "index.xml" ))
            stageElem = self._getStageElem( stageID )
        if stageElem:
            return stageElem.getAttribute( "name" )
        else:
            raise MobyleError, "no such stage: "+str( stageID )


    def getStdout( self, stageID ):
        #todo
        #valable uniquement si le stage est un service et non un pipeline
        #trouver un mecanisme general pour  
        pass
        

    def getDate( self,stageID = None , stageElem = None ):
        """
        @param ID: the stage ID
        @type ID: int
        @param stageElem: a stage element element 
        @type stageElem: an dom stage element 
        @return: the date of this workflow
        @rtype: string or None
        @raise MobyleError: if there isn't any stage with id stageID
        """
        if stageID:
            self._parse( getContentFile( self._MyUri + "index.xml" ))
            stageElem = self._getStageElem( stageID )
        if stageElem:
            try:
                return self._getElementValue( stageElem , "date" )
            except MobyleError:
                return None
        else:
            raise MobyleError, "no such stage: "+str( stageID )

        
    
    def setDate( self, stageID , date ):
        """
        Set the date of this stage to date
        @param ID: the stage ID
        @type ID: int
        @param date: the date of this workflow
        @type date: string
        """
        self._parse( getContentFile( self._MyUri + "index.xml" ))
        stageElem = self._getStageElem( stageID )
        if stageElem:
            if date is None:
                date =strftime( "%x  %X", localtime() )
                self._updateNode( stageElem, "date", date )
        else:
            raise MobyleError, "no such stage: "+str( stageID )

        

    def getArgs( self, stageID = None , stageElem = None ):
        """
        @param ID: the stage ID
        @type ID: int
        @param stageElem: a stage element element 
        @type stageElem: an dom stage element 
        @return: the Args of this stage
        @rtype: dictionnary {argName : value}
        """
        
        if stageID:
            self._parse( getContentFile( self._MyUri + "index.xml" ))
            stageElem = self._getStageElem( stageID )
        if stageElem:
            args = stageElem.getElementsByTagName( "arg" )
            result = {}
            for arg in args:
                result[arg.getAttribute( "name" )] = arg.firstChild.nodeValue
            return result
        else:
            raise MobyleError, "no such stage: "+str( stageID )

         
    def addArg( self, stageID ,argName , value ):
        """
        add an argument to this stage
        @param ID: the stage ID
        @type ID: int
        @param argName: the name of the argument
        @type argName: string
        @param value: the value of the argument
        @type value: any
        """
        stageElem = self._getStageElem( stageID )
        args= stageElem.getElementsByTagName( "arg" )
        for arg in args:
            if arg.getAttibute( "name" ) == argName:
                raise MobyleError, "this stage have alreday an arg with name:"+argName
            
        newNode = self.doc.createElement( "arg" )
        newNode.setAttibute( "name", argName )
        text_node = self.doc.createTextNode( str( value ) )
        newNode.appendChild( text_node )
        stageElem.appendChild( newNode )

    def rmArg( self, stageID ,argName ):
        """
        Removes an argument to this stage
        @param ID: the stage ID
        @type ID: int
        @param argName: the name of the argument
        @type argName: string
        """
        stageElem = self._getStageElem( stageID )
        args= stageElem.getElementsByTagName( "arg" )
        for arg in args:
            if arg.getAttibute( "name" ) == argName:
                arg.unlink()

        raise MobyleError, "no such arg : " + argName + " in this stage."


                                                      
