from exceptions import Exception
#import sys,os

#from Mobyle import ConfigManager  

class MobyleError(Exception):
    pass

class ServiceError(MobyleError):
    pass

class ParameterError(ServiceError):
    pass

class ConfigError(MobyleError):
    pass

class ScannerError( MobyleError ):
    pass


class ParserError( MobyleError ):
    pass

class UnDefAttrError(ParameterError):
    """
    Raised  when attempt to apply a method on a parameter attribute which is not exist  
    """
    pass

 
class UserValueError(MobyleError):
    """
    Raised when the user do a mistake. ex a wrong value for a parameter or forget to specify a mandatory parameter...
    """

        
    def __init__(self, parameter = None , msg = None):
        self.param = parameter
        self.msg = msg
        
##     def __str__(self):
        
##         lang = Mobyle.ConfigManager.Config().lang()

##         if self.param:
##             if self.param.promptHas_lang( lang ):
##                 err_msg = "\n" + self.param.getPrompt( lang ) + " = " + self.msg
##             else:
##                 if self.param.promptLangs():
##                     err_msg = "\n"+ self.param.getPrompt( self.param.promptLangs()[0] ) + " = " + self.msg
##                 else:
##                     err_msg = "\n"+ self.param.getName() + self.msg
##         else:
##             err_msg = "\n" + self.msg
##         return err_msg
        
    def __str__(self):
        
        #lang = Mobyle.ConfigManager.Config().lang()
        #problem d'import cyclique
        # TOFIX
        lang = 'en'
        
        if self.param:
            if self.param.promptHas_lang( lang ):
                err_msg = self.param.getPrompt( lang ) + " = " + self.msg
            else:
                if self.param.promptLangs():
                    err_msg =self.param.getPrompt( self.param.promptLangs()[0] ) + " = " + self.msg
                else:
                    err_msg = self.param.getName() + self.msg
        else:
            err_msg = self.msg
        return err_msg


class UnSupportedFormatError( MobyleError ):
    pass

class EvaluationError( MobyleError ):
    pass


class ConfigError( Exception ):
    pass

class SessionError( MobyleError ):
    pass

class EmailError( MobyleError ):
    pass

class TooBig( EmailError ):
    pass

class AuthenticationError( SessionError ):
    pass
    
class NoSpaceLeftError( SessionError ):
    pass