from Mobyle.MobyleError import *
import Mobyle.ConfigManager



class Pipeline:

    
    def __init__(self):
        self._name = None
        self._title = None
        self._id= None
        self._userKey = None
        self._date = None
        self._stages = {} 

        
    def getName(self):
        """
        return the name of the Pipepline
        @return a string representing the name of the pipeline
        """       
        return self._name

    
    def setName(self, name):
        """
        @param name: the name of the pipeline
        @type name: String
        """
        self._name = name

        
    def getTitle(self):
        """
        return the title of the Pipepline
        @return a string representing the title of the pipeline
        """
        return self._title

        
    def setTitle(self,title):
        """
        @param title: the name of the pipeline
        @type title: String
        """
        self._title = title


    def setUserKey(self, key):
        """
        @param key: the user key
        @type key: string
        """
        self._userKey = key


    def getUserKey(self,key):
        """
        @param key: the user key 
        @type key: string
        @return : the user key or None
        """
        return self._userKey

    
    def setID(self, ID ):
        """
        @param Id: the identifier of this pipeline (a pipeline with an Id is an executed pipeline)
        @type Id: string
        """
        self._id = Id


    def getID(self, ID ):
        """
        @param Id: the identifier of this pipeline ( its url )
        @type Id: string
        @return : the id of this pipeline or None (if it's a pipline definition)
        """
        return self._userKey


    def setDate(self, date = None , timefmt = None):
        """
        set the date of execution of this pipeline
        @param date: a date in format "%x %X"
        @type date: a string in format "%x %X" as described in L{time}
        """
        if date is None:
            date = time.localtime()
        if format is None:
            format = "%x %X"
            
        self._date = time.strptime( self._date , format)
        

    def getDate(self, format = None):
        """
        
        @return : the date of the begining of this pipeline execution
        """
        if self._date is not None:
            if format is not None:
                format = "%x %X"
            date = time.strftime( format , self._date)
            return date
        else:
            return None

    
    def addStage(self, stage):
        """
        @param stage: the Stage to add
        @type stage: a - L{ Stage <Stage>} instance
        """
        self._stages[stage.getId()] = stage


    def _getStage(self, id):
        """
        @param id: the id of a stage
        @type id:
        @return : a -L<Stage>
        """
        try:
            return self._stages[id]
        except KeyError:
            raise MobyleError

    
    def rmStage(self,id):
        try:
            del self._stages[id]
        except KeyError, e:
            raise MobyleError


    def getStagesId(self):
        """
        @return : the list of stages id
        """
        if self._stages:
            return self._stages.keys()


    def getStages(self):
        """
        @todo: return all stages by increasing id
        """
        stages = []
        if self._stages:
            ids = self._stages.keys()
            ids.sort()
            for id in ids:
                stages.append(self._getStage( id ))
        return stages


    ################################
    #                              #
    #       Delegated Methods      #
    #                              #
    ################################

    
    def getStageName(self,stageId):
        """
        @return the name of the stage.
        """
        return self._getStage(stageId ).getStageName()
        
    def getServer(self,stageId):
        """
        @return : a String representing the URL of a mobyle server
        """
        return self._getStage(stageId ).getServer()


    def getStageDate(self,stageId):
        """
        @return : a String representing the URL of a mobyle server
        """
        return self._getStage(stageId ).getDate()
    
    
    def getPipein(self,stageId):
        """
        @return : the list of pipe in. A pipe is : (id, String pipetype, String parameterName)
        """        
        return self._getStage(stageId).getPipein()

    def getPipeout(self,stageId):
        """
        @return : the list of pipe out. A pipe is : (id, String pipetype, String parameterName)
        """
        return self._getStage(stageId ).getPipeout()    
    
    def addPipe(self,stageId, pipesin = None , pipesout = None):
        """
        @param pipein : a pipe from a previous stage
        @type pipein : a tuple (id, String pipetype, String parameterName)
        @param pipeout : a pipe toward a next stage
        @type pipeout : a tuple (id, String pipetype, String parameterName)
        """
        self._getStage(stageId ).addPipe( pipesin = pipesin  , pipesout = pipesout )
        
        
    def addArg(self, stageId, name , value ):
        """
        add a argument at one stage
        @param stageId : the id of the stage
        @type stageId : int
        @param name : the arg name
        @type name : String
        @param value : the arg value
        @type value : String
        """
      
        self._getStage(stageId).addArg( name , value )
        
        
    def hasArgName(self,stageId, name):
        """
        @param name : the name of an arg
        @type name : String
        @return : True if there is an arg with the name name, False otherwise.
        """
        return self._getStage(stageId).hasArgName( name )
        
        
    def argsName(self,stageId):
        """
        @return : the list of args name 
        """
        return self._getStage(stageId).argsName()
    
    
    def argsValue(self,stageId):    
        """
        @return : the list of the args values
        """
        return self._getStage(self, stageId).argsValue()
    
    
    def getArgValue(self, stageId,name):
        """
        @return : the value associated to this name
        """
        return self._getStage(stageId).getArgValue( name )

    
    def run(self):
        """
        instancie un objet pipeline Job voir diagramme de sequences
        """
        pass



#################################################################################
#                                                                               #
#                                                                               #
#                               Stage                                           #
#                                                                               #
#                                                                               #
#################################################################################
 


class Stage:
    
    def __init__(self, Id , name , server , args = None ,date = None , pipein = None , pipeout = None):
        """
        @param args : the parameters with their values to run the stage
        @type args : a dictionary with the parameter name as key and the value as value
        @param pipein : the list of pipe from previous stages used by this stage
        @type pipein : list of tuple (id, String pipetype, String parameter)
        @param pipeout : the list of the pipe of this stage used by the next stages
        @type pipeout : list of tuple (id, String piptype, String parameter)
        """
        self._id = Id     
        self._name = name
        self._server = server    # a string representing the URL of a Mobyle server
        self._args = args         # a dictionary with the names of arg as key and the values as value
        self._date = date
        self._in = pipein
        self._out = pipeout

    def getId(self):
        """
        @return : the id of this stage
        """
        return self._id
        
    def getName(self):
        """
        @return the name of this stage
        """
        return self._name

    def getDate(self):
        """
        @return the Date of the execution of this stage
        """
        return self._name
        
    def getServer(self):
        """
        @return : a String representing the URL of a mobyle server
        """
        return self._server
    
    def getPipein(self,):
        """
        @return :the list of pipe in. A pipe is : (id, String pipetype, String parameterName)
        """        
        return self._in


    def getPipeout(self):
        """
        @return : the list of pipe out. A pipe is : (id, String pipetype, String parameterName)
        """
        return self._out     
    
  
    def addPipe(self, pipesin = None , pipesout = None):
        """
        @param pipesin : a list of pipe from a previous stage
        @type pipesin : a list of tuple (id, String pipetype, String parameterName)
        @param pipesout : a list of pipe toward a next stage
        @type pipesout : a list of tuple (id, String pipetype, String parameterName)
        """
        klassMap = Mobyle.ConfigManager.Config().klassMap()
        if pipesin is not None:
            for pipein in pipesin :
                if len( pipein ) == 3:
            
                    if not klassMap.has_key( pipein[1] ):
                        raise MobyleError , "uknown pipetype:" + str( pipein[1] )+ ", the pipetype should be a Mobyle class"
                    else:
                        if self._in is not None:
                            self._in.append( pipein )
                        else:
                            self._in = [ pipein ]
                else:
                    raise MobyleError, "invalid pipein (id, pipetype, parameter)" +str(pipein)
        if pipesout is not None :
            for pipeout in pipesout :
                if len( pipeout ) == 3:
                    if not klassMap.has_key( pipeout[1] ):
                        raise MobyleError, "uknown pipetype:" + str( pipeout[ 1 ] )+ ", the pipetype should be a Mobyle class"
                    else:
                        if self._out is not None:
                            self._out.append( pipeout )
                        else:
                            self._out = [ pipeout ]
                else:
                    raise MobyleError, "invalid pipeout (id, pipetype, parameter) :" +str(pipeout[1])
    
    
  

    def addArg(self , name , value ):
        """
        @param name : the arg name
        @type arg : String
        @param value : the arg value
        @type value : ?
        """
        if self._args is None:
            self._args = {name : value}
        else:
            self._args[name] = value
        
    def hasArgName(self, name):
        """
        @param name : the name of an arg
        @type name : String
        @return : True if there is an arg with the name name, False otherwise.
        """
        return self._args.has_key(name)
        
        
    def argsName(self):
        """
        @return : the list of args name 
        """
        return self._args.keys()
    
    
    def argsValue(self):    
        """
        @return : the list of the args values
        """
        return self._args.values()
    
    
    def getArgValue(self, name):
        """
        @return : the value associated to this name
        """
        try:
            return self._args[name]
        except KeyError:
            raise MobyleError
    
