from Mobyle.MobyleError import *
import sys
import logging
from Ft.Xml import Parse
import re
from string import *
import os.path
import operator

c_log = logging.getLogger('mobyle.servicestree')




##########################################################
#                                                        #
#       Category quick search                            #
#                                                        #
##########################################################


UNSPECIFIED_CATEGORY="[unspecified]"

#
# Builds an instance of Categories ( a category classified data structure of services - can be filtered or not)
#

def find_in_service(fname, pattern, elements, matchLimit=999):
    try:
      doc = Parse(fname)
    except Exception, e:
      import traceback, StringIO
      sys.stderr = StringIO.StringIO()
      traceback.print_exc()
      c_log.error(sys.stderr.getvalue())
      return None, None, None, None, None

    service_name = doc.xpath('/program/head/name/text()')[0].nodeValue
    try:
      service_description = doc.xpath('/program/head/doc/description/text/text()')[0].nodeValue
    except Exception, e:
      c_log.warning("service %s has no description" % service_name)
      service_description = service_name
    categories = []
    cats = doc.xpath('/program/head/category/text()')
    if len(cats)>0:
      for cn in cats:
        categories.append(cn.nodeValue)
    else:
      categories.append(UNSPECIFIED_CATEGORY)

    root = doc.rootNode

    if pattern is None:
      matchdata = None
      found = True
    else:
      matchdata = []
      if len(elements) > 0:
          for element in elements:
              expr = '//' + element + '[contains(node(),"' + pattern + '")]'
              found = root.xpath(expr)
              if found:
                  for e in found:
                      matchValue = e.firstChild.nodeValue
                      start = matchValue.find(pattern)
                      end = start + len(pattern) 
                      matchdata.append({'element': e, 'value': matchValue, 'span': (start, end)})
      else:
          expr = '//*[contains(node(),"' + pattern + '")]'
          found = root.xpath(expr)
          if found:
              for e in found:
                  matchValue = e.firstChild.nodeValue
                  if matchValue:
                    start = matchValue.find(pattern)
                    end = start + len(pattern) 
                    matchdata.append({'element': e, 'value': matchValue, 'span': (start, end)})

    if not(pattern) or len(matchdata) > 0:
        return service_name, service_description, True, categories, matchdata

    return service_name, service_description, False, [], None


def find_in_services(paths, pattern, elements, matchLimit=None):

    data = {}
    data['categories'] = {}
    data['programs'] = {}
    data['description'] = {}
    data['matchdata'] = {}

    for fname in paths:
        service_name, service_description, found, categories, matchdata = find_in_service(fname, pattern, elements)
        if found:
            data['programs'][service_name] = categories
            data['description'][service_name] = service_description
            data['matchdata'][service_name] = matchdata
    return data


def search(paths, query=None, elements=[], matchLimit=None):
    #pattern = re.compile(lower(query))
    #print >>sys.stderr, "Mobyle/livecategory: searching ", pattern.pattern   
    result = find_in_services(paths, query, elements,matchLimit)
    return result

class CategoryNode:
  """
  A node in the categories hierarchy (including the root)
  """
    
  def __init__(self,path):
    # for a given node, the complete path to it e.g.: a:b:c
    self.path = path
    pathtmp = self.path.split(':')
    self.name = pathtmp[len(pathtmp)-1]
    self.subcategories={}
    self.programs={}
    
  def add_program(self,subpath, programNode):
    if subpath != None and subpath != '':
      subcatnames = subpath.split(':')
      if(not self.subcategories.has_key(subcatnames[0])):
        cat = CategoryNode(':'.join([self.path,subcatnames[0]]))
        self.subcategories[subcatnames[0]] = (cat)
      else:
        cat = self.subcategories[subcatnames[0]]
      subcatnames.remove(subcatnames[0])
      if len(subcatnames)==0:
        subpath = None
      else:
        subpath = ':'.join(subcatnames)
      cat.add_program(subpath,programNode)
    else:
      self.programs[programNode.name] = programNode
      
  def sort(self):
    # sorting the subcategories...
    self.subcategories_ordered = []
    kl = self.subcategories.keys()
    kl.sort()
    for key in kl:
      self.subcategories[key].sort()
      self.subcategories_ordered.append(self.subcategories[key])
    # sorting the programs...
    self.programs_ordered = []
    kl = self.programs.keys()
    kl.sort()
    for key in kl:
      self.programs_ordered.append(self.programs[key])
    return
      
class ProgramNode:
  def __init__(self,name,description,matchdata):
    self.name=name
    self.description=description
    self.matchdata = matchdata
      
class Tree:
  """
  The programs list tree
  """
  def __init__(self, data):
    
    self.descriptions = data['description']
    self.matchdata = data['matchdata']
    self.categories = []
    # create the root node
    self.root = CategoryNode('')
    # create program nodes - categories are created dynamically as we explore a program's path
    for name in data['programs']:
      p = ProgramNode(name, data['description'][name], data['matchdata'][name])
      if(len(data['programs'][name])>0):
        for c in data['programs'][name]:
          self.root.add_program(c,p)
      else:
          self.root.add_program(None,p)
          
    self.root.sort()