

import sys , os
import cPickle
try:
    _MOBYLEHOME = os.environ['MOBYLEHOME']
except KeyError :
    os.environ['MOBYLEHOME']= "/home/hmenager/cvs/Mobyle"
    _MOBYLEHOME = os.environ['MOBYLEHOME']


if (os.path.join(_MOBYLEHOME,'Src')) not in sys.path:
   sys.path.append(os.path.join(_MOBYLEHOME,'Src'))

import Mobyle.ConfigManager
from Mobyle import MobyleError

from Ft.Xml.Domlette import NonvalidatingReader
from Ft.Xml import ReaderException
from Mobyle.Utils import ServiceLocator
from Mobyle.MobyleError import *



class pipeRegistry:
    # pipeRegister structure = { service : { ouputParam : { service : [ inputParam ] } }
    #
    #
    # example   pipeRegister = { golden  : { golden_out : { toppred : [ query ] ,
    #                                                        blast2  : [ query ] ,
    #                                                        bl2seq  : [ first_sequence , second_sequence ] 
    #                                                      }
    #                             dnadist : {  outfile   : { neighbor: [ infile ] }
    #                            }
    #
    
    def __init__(self):
        
        self.register = {}
        
        sl = ServiceLocator()
        iterator = sl.iterServices()
        allInputs = []
        
        errors = []
        #pour chaque service
        for serviceName in iterator :
            print >>sys.stderr, "Parsing %s..." % serviceName
            try:
              service = Mobyle.Utils.makeService( serviceName )
            except Exception, e:
              print >>sys.stderr, "error while parsing %s" % serviceName
              continue
            #je mets dans piperegistry le service : les parametres outputs file
            outputs = service.getAllOutFileParameter()
            for output in outputs:
                if self.register.has_key( service ):
                    self.register[ service ][ output ] = { } 
                else:
                    self.register[ service ] = { output : { } }
            #je mets dans une liste ( le service , [ les parametres en inputs file ] )
            inputs = service.getAllInFileParameter()
            allInputs.append( ( service , inputs ) )
            
        #pour chaque services de pipeRegistry
        for serviceOut in self.register.keys():
            #pour chaque parametres output
            for outParam in self.register[ serviceOut ]:
                
                #je test tous les inputs pour voir s'il sont pipeable?
                for serviceIn , inputs in allInputs:
                    for inParam in inputs:
                        #si oui j'ajoute le parametre dans piperegistry
                        try:
                            print >>sys.stderr, "testing pipe between [%s]%s and [%s]%s" % (serviceIn.getName(), inParam._name, serviceOut.getName(), outParam._name)
                            if outParam.getType().isPipeableTo( inParam.getType() ):
                                self._addInputParam( serviceOut , outParam , serviceIn , inParam )
                        except MobyleError , err:
                            msg = "when test if %s : %s is pipeable to %s :%s" %( serviceIn , inParam , serviceOut , outParam , err )
                            errors.append( msg )
                  #si non , input suivant
        if errors:
            msg = '/n'.join( errors)
            raise MobyleError , msg 
             
                  
    def _addInputParam(self , serviceOut , parameterOut , serviceIn , parameterIn ):
        #if self.register.has_key( serviceOut ):
        #    if self.register[ serviceOut ].has_key( parameterOut ):
                if self.register[ serviceOut ][ parameterOut ].has_key( serviceIn ):
                    if parameterIn not in self.register[ serviceOut ][ parameterOut ][ serviceIn ]:
                        self.register[ serviceOut ][ parameterOut ][ serviceIn ].append( parameterIn )
                else:
                    self.register[ serviceOut ][ parameterOut ][ serviceIn ] = [ parameterIn ]  
        #    else:
        #        self.register[ serviceOut ][ parameterOut ] = { serviceIn : [ parameterIn ] } }
        #else:
        #    self.register[ serviceOut ] = { parameterOut : { serviceIn : [ parameterIn ] } }
        
    
    def getJSONDict(self):
        res = {}
        for outService in self.register.keys():
            res[outService.getName()]={}
            for outParam in self.register[ outService ]:
                res[outService.getName()][outParam.getName()]={}                
                for inService in self.register[ outService ][ outParam ]:
                    res[outService.getName()][outParam.getName()][inService.getName()]={}
                    inputs = [  p.getName() for p in self.register[ outService ][ outParam ][ inService ]  ]
                    if len(inputs)>0:
                      res[ outService.getName() ][ outParam.getName() ][ inService.getName() ] = inputs        
                if len(res[outService.getName()][outParam.getName()])==0:
                  del res[outService.getName()][outParam.getName()]
            if len(res[outService.getName()])==0:
              del res[outService.getName()]
        return res
        

if __name__ == '__main__':
    try:
        pipeRegister = pipeRegistry()
    except MobyleError , err :
        print >> sys.stderr ,"################# errors #################"
        print err
        print >> sys.stderr , "\npipeRegister will not be dumped. correct errors above first."    
        print >> sys.stderr , "##########################################"    
    else:            
        cfg = Mobyle.ConfigManager.Config()
        print >> sys.stderr , "dump pipeRegister into : " , os.path.join( cfg.templates_cache_path(), "pipeRegister.dump")
        fh = open( os.path.join( cfg.templates_cache_path() , "pipeRegister.dump") ,'w')
    
        cPickle.dump( pipeRegister.getJSONDict() , fh )
        fh.close()
        print >> sys.stderr , "done"             