#! /usr/bin/env python
import mb_cgi, re
from subprocess import *

class BankGet(mb_cgi.JSONCGI):
    """
    This class defines the I{Golden} component for a databox
    This CGI is called from the databox's DB tab, and replies 
    the content of the databank record requested OR an error message
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
        if( not(self.request.has_key('id') ) or not( self.request.has_key('db') )):
            raise Exception( "Please specify a database and an identifier." )
        else:
            db = self.request.getfirst('db').strip()
            id = self.request.getfirst('id').strip()
            # the parameters in the call to golden are escaped to avoid any injection
            cmd = [ self.cfg.golden_path() , "%s:%s" % ( db.encode('string_escape'), id.encode('string_escape')) ]
            # for safety reasons, we also parse the parameters to check if they include 'special characters'
            # if so, the value is logged
            self.checkParameterValue( 'db' , db )
            self.checkParameterValue( 'id' , id )
            # calling golden
            process = Popen( cmd , shell = False , stdout = PIPE, stderr = PIPE )

            outText = ""
            for line in process.stdout :
                outText = outText + line

            errText = ""
            for line in process.stderr :
                errText = errText + line

            process.wait()
            returnCode = process.poll()
#===============================================================================
#            TODO
#            ameliorer la gestion d'erreur entre golden.py et le javascript (la databox )
#===============================================================================
            
            if returnCode != 0 :
                outText = ""
            
            self.jsonMap['returnCode'] = str(returnCode)
            self.jsonMap['data'] = str(outText)
            self.jsonMap['msg'] = str(errText)

    def checkParameterValue(self, name, value):
        """
        I{checkParameterValue} checks that a given parameter contains only alphanumeric characters
        This method is currently used only to log unusual entries, because the parameter values are escaped anyways to avoid injections.
        """
        ss = '^\w+$'
        m = re.match(ss,value)
        if(m==None):
            # TODO this should be properly logged in the Mobyle log system
            self.c_log.warning("Unusual parameter value in parameter " + name + "=" + value)

if __name__ == "__main__":
    bg = BankGet()
    bg.process()
    bg.render()
