#! /usr/bin/env python
import mb_cgi
import Mobyle.MobyleJob 
from Mobyle.MobyleError import NoSpaceLeftError, UserValueError

class DataBookmark(mb_cgi.JSONCGI):
    """
    This class defines the I{ResultAdd} cgi
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
      try:
        jobId = self.request.getfirst('jobId')
        fileName = self.request.getfirst('fileName')
        producerJob = Mobyle.MobyleJob.MobyleJob(ID=jobId)
        parameterName = self.request.getfirst('parameterName')
        outputs = producerJob.getOutputs()
        for o in outputs:
          if o[0].getName()==parameterName:
            parameterType=o[0].getType()
            break
        safeFileName = self.session.addDatas( fileName , parameterType, producer = producerJob , inputModes = ['result'], producedBy = jobId)
        if self.request.has_key('newFileName'):
          self.session.renameData(safeFileName,self.request.getfirst('newFileName'))
      except NoSpaceLeftError, e:
        self.c_log.info("NoSpaceLeftError while bookmarking " + fileName + " - error: " +  str(e))
        self.jsonMap['errormsg'] = str(e)
      except UserValueError, e:
        self.c_log.info("UserValueError while bookmarking " + fileName + " as a " + str(parameterType) + " - error: " +  str(e))        
        self.jsonMap['errormsg'] = str(e)        
      else:
        self.jsonMap['safeFileName'] = safeFileName


if __name__ == "__main__":
    db = mb_cgi.SessionCGI(DataBookmark())
    db.process()
    db.render()