#! /usr/bin/env python
import mb_cgi, re
from Mobyle.MobyleError import *

class DataCheck(mb_cgi.JSONCGI):
  """
  This class defines the I{ParameterFormatCheck} cgi , used in a databox
  
  @author: Herve Menager
  @organization: Institut Pasteur
  @contact:mobyle@pasteur.fr
  """
  
  def process( self ):
    # load the parameters
    data = self.request.getfirst('data')
    datatype = self.request.getfirst('datatype')
    if(data==None or data=='' or datatype==None or datatype==''):
      return
    # write the data in a file to detect its format
    filename = self._toFile(data,datatype)
    try:
      import imp, sys
      import Mobyle
      fp , pathname , description = imp.find_module("%sConverter" % datatype, Mobyle.__path__)
      conv = imp.load_module("%sConverter" % datatype , fp , pathname , description )
      response = conv.detect(filename)
      self.jsonMap['program']=response[0]
      self.jsonMap['format']=response[2]
      self.jsonMap['count']=None
      if len(response)==4 and response[3]!=None:
        self.jsonMap['count']=response[3]
    # "uncheckable" format
    except ImportError, ie:
      self.jsonMap['errormsg'] = "This format cannot be checked"
    # system error during check
    except Exception, e:
      self.c_log.error(str(me))
      import traceback, StringIO
      stderrbck = State.sys.stderr
      State.sys.stderr = StringIO.StringIO()
      traceback.print_exc()
      self.c_log.error(sys.stderr.getvalue())
      State.sys.stderr = stderrbck
      self.jsonMap['errormsg'] = 'format checking temporarily unavailable'
      return            

  def _toFile( self , content, datatype):
    clean_content = re.sub( "\r\n|\r|\n" , '\n' , content )
    key = State.md5.new()
    key.update(content)
    key.update(datatype)
    self.filename = key.hexdigest()
    absfilename = State.os.path.join(self.cfg.format_detector_cache_path(),self.filename)
    try:
        fh = open( absfilename , "w" )
        fh.write( clean_content )
        fh.close()
    except IOError , err:
        msg = "error while creating file : " + absfilename + str( err )
    return absfilename

if __name__ == "__main__":
  dc = mb_cgi.SessionCGI(DataCheck())
  dc.process()
  dc.render()