#! /usr/bin/env python
import mb_cgi
from  Mobyle.Classes.Core import DataTypeFactory

class DataGet(mb_cgi.JSONCGI):
    """
    This class defines the I{History} cgi
    This CGI is called from the databox, and replies 
    the contents or head of a file stored in the session's history
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
        if(not(self.request.has_key('dataId'))):
          raise Exception("Please specify the id of the data that has to be downloaded.")
        else:
          dataId = self.request.getfirst('dataId')
          # mobyle type determines wether we send back the data or not (if binary)
          d = self.session.getDatas(dataName=dataId)[0]
          mt = d['type']
          df = DataTypeFactory()
          contentData= self.session.getContentData(dataId)
          self.jsonMap['userName'] = d['userName']
          self.jsonMap['safeName'] = d['dataName']
          if df.issubclass(mt.getDataType(),"Binary"):
            self.jsonMap['content'] = d['dataBegin']          
          else:
            self.jsonMap['headFlag'] = contentData[0]
            if(self.jsonMap['headFlag']=="HEAD"):
              self.jsonMap['content'] = contentData[1][0:2000]
            else:
              self.jsonMap['content'] = contentData[1]
              
if __name__ == "__main__":
    dg = mb_cgi.SessionCGI(DataGet())
    dg.process()
    dg.render()