#! /usr/bin/env python
import mb_cgi, re

class DataList(mb_cgi.JSONCGI):
    """
    This class generates the sent SessionData to the client to construct 
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
      dataMap = []
      if self.session:
        data = self.session.getDatas()
        for dataFile in data:
          dataType = dataFile['type'].getDataType().name
          bioTypes = []
          for bt in dataFile['type'].getBioTypes():
            bioTypes.append(str(bt))
          userModes = []
          for im in dataFile['inputModes']:
            userModes.append(im)
          dataMap.append({'id': dataFile['dataName'], 'userName':dataFile['userName'], 'dataType': dataType, 'bioTypes': bioTypes, 'userModes': userModes, 'title':dataFile['dataBegin'], 'size': '%.2f'%(float(dataFile['size'])/1000), 'format': dataFile['format']})
      self.jsonMap = dataMap

if __name__ == "__main__":
    dl = mb_cgi.SessionCGI(DataList())
    dl.process()
    dl.render()