#! /usr/bin/env python
import mb_cgi
import os
from Ft.Lib import Uri 

class Form(mb_cgi.XSLCGI):
    """
    Generates an HTML program submission form by transforming its XML definition using an XSL stylesheet.

    @author: Catherine Letondal
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    def process(self):
      """
      Process the parameters, then render.
      """
      self.program = self.request.getfirst('_program')
      if self.request.has_key('isInPortal'):
          self.isInPortal = self.request.getfirst('isInPortal')
      else:
          self.isInPortal='false'
      from Mobyle.Utils import ServiceLocator
      sl = ServiceLocator()
      self.xslParams = {u'isInPortal': unicode(self.isInPortal),u'optEmail':unicode(self.cfg.opt_email(self.program)),u'errorMsg':u""}
      try:
          # program exists on the server
          assert sl.has_service(self.program), "%s: this program does not exist on this server" % self.program 
          # program disabled
          assert self.cfg.isDisabled(serviceName=self.program)==False, "%s: this program has been disabled on this server" % self.program
          # program with restricted access
          assert self.cfg.isAuthorized(serviceName=self.program)==True, "%s: the access to this program is restricted on this server" % self.program
      except AssertionError, ae:
        self.error_msg = str(ae)
        self.c_log.info("Program access error: %s (request from %s)" % (self.error_msg,os.environ['REMOTE_ADDR']))
        return
      self.xmlUrl = Uri.OsPathToUri(sl[self.program])
      self.xsltUri = Uri.OsPathToUri(os.path.join(os.environ[ 'DOCUMENT_ROOT' ] , self.cfg.htdocs_url() , "xsl", "form.xsl" ))

if __name__ == "__main__":
  f = Form()
  f.process()
  f.render()