#! /usr/bin/env python
import mb_cgi
import Mobyle.Net

class HelpRequest(mb_cgi.JSONCGI):
    """
    This class defines the I{JobSendHelpRequest} cgi
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
        message = self.request.getfirst('message',None)
        email = Mobyle.Net.Email(self.cfg.mailHelp(),self.cfg)
        if self.session and self.session.getEmail():
          email.From = self.session.getEmail()
          
        from string import Template
        s = """
User Message:
$msg

Session information:
- id: $session_id
- email: $session_email
- activated?: $session_activated
- authenticated?: $session_authenticated

Job information:
- id: $job_id
- date: $job_date
- status: $job_status
- error parameter: $job_errorparam
- error message: $job_errormsg
"""
        t = Template(s)
        body = t.substitute(session_id=self.sessionKey, 
                     session_email=self.session.getEmail(),
                     session_activated = self.session.isActivated(),
                     session_authenticated = self.session.isAuthenticated(),
                     job_id = self.request.getfirst('id',None),
                     job_date = self.request.getfirst('date',None),
                     job_status = self.request.getfirst('status',None),
                     job_errorparam = self.request.getfirst('errorparam',None),                     
                     job_errormsg = self.request.getfirst('errormsg',None),
                     msg = self.request.getfirst('message',None)
                     )
        email.sendMsg("[mobyle help request] help on job %s" % self.request.getfirst('id',None),body)
        if self.session and self.session.getEmail():
          try:
            Mobyle.Net.Email(self.session.getEmail(),self.cfg).sendMsg("[mobyle help request receipt] help on job %s" % self.request.getfirst('id',None),body)
          except:
            self.c_log.warning("failed sending help request receipt to %s" % str(self.session.getEmail()))
        
        self.jsonMap['msg_body'] = body
        

if __name__ == "__main__":
    hr = mb_cgi.SessionCGI(HelpRequest())
    hr.process()
    hr.render()