#! /usr/bin/env python
import mb_cgi
from Ft.Xml import Parse
from Mobyle.Utils import ServiceLocator

class InputsList(mb_cgi.JSONCGI):
    """
    This class generates the pipe possibilities that needs to be known by the client to construct pipes
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
        sl = ServiceLocator()
        si = sl.items()
        nifdt = [None, 'Boolean', 'Integer', 'Float', 'String', 'Choice', 'MultipleChoice', 'FileNameDataType', 'StructureDataType', 'PropertiesDataType']
        inputs = []
        from Ft.Xml import Parse
        from Ft.Xml.XPath import Compile, Evaluate
        sn_query = Compile(u"/program/head/name/text()")
        sp_query = Compile(u"/program/head/doc/description/text[@lang='en']/text()")
        p_query = Compile(u"/program//parameter[not(@isout) and not(@isstdout) and not(@ishidden)]")
        pn_query = Compile(u"name/text()")
        pp_query = Compile(u"prompt[@lang='en']/text()")
        pt_query = Compile(u"type")
        bt_query = Compile(u"biotype/text()")
        dt_query = Compile(u"datatype")
        dc_query = Compile(u"class/text()")
        ds_query = Compile(u"superclass/text()")
        dcr_query = Compile(u"card/text()")
        for name,path in si:
            try:
                doc = Parse(path)
                service_name = Evaluate(sn_query,doc)[0].nodeValue
                service_prompts = Evaluate(sp_query,doc)
                if len(service_prompts)>0:
                  service_prompt = service_prompts[0].nodeValue
                else:
                  service_prompt = service_name                  
                parameters = Evaluate(p_query,doc)
                for p in parameters:
                    name = Evaluate(pn_query,p)[0].nodeValue
                    prompts = Evaluate(pp_query,doc)
                    if len(prompts)>0:
                      prompt = prompts[0].nodeValue
                    else:
                      prompt = name                  
                    mtype = Evaluate(pt_query,p)
                    if len(mtype)>0:
                        mtype = mtype[0]
                        biotypes = Evaluate(bt_query,mtype)
                        bt=[]
                        for b in biotypes:
                            bt.append(b.nodeValue)
                        biotypes=bt
                        datatype = Evaluate(dt_query,mtype)
                        datatype_class = None
                        datatype_superclass = None
                        if len(datatype)>0:
                            datatype = datatype[0]
                            datatype_class = Evaluate(dc_query,datatype)
                            if len(datatype_class)>0:
                                datatype_class = datatype_class[0].nodeValue
                            if datatype_class not in nifdt:
                                datatype_superclass = Evaluate(ds_query,datatype)
                            if datatype_superclass and len(datatype_superclass)>0:
                                datatype_superclass = datatype_superclass[0].nodeValue
                        card = Evaluate(dcr_query,mtype)
                        mincard = 1
                        maxcard = 1
                        if len(card)>0:
                            card = card[0].nodeValue.split(',')
                            mincard = card[0]
                            if len(card)>1:
                              maxcard = card[1]
                            else:
                              maxcard = card[0]
                        if datatype_class and datatype_class not in nifdt:
                            inputs.append({'id':service_name+'|'+name, 'program': service_name, 'parameterName': name, 'bioTypes':biotypes, 'dataType':datatype_class,'minCard': mincard, 'maxCard': maxcard, 'servicePrompt':service_prompt, 'parameterPrompt': prompt })
            except Exception, e:
                import traceback, StringIO, sys
                sys.stderr = StringIO.StringIO()
                traceback.print_exc()
                self.c_log.error(sys.stderr.getvalue())
                continue
        self.jsonMap = inputs

      

if __name__ == "__main__":
    il = InputsList()
    il.process()
    il.render()