#! /usr/bin/env python
import mb_cgi
import os
import Mobyle.MobyleJob 
from Mobyle.Utils import ServiceLocator
from Mobyle.MobyleError import *

class JobStatus(mb_cgi.XSLCGI):
  """
  This class is a CGI interface to the MobyleJob class.
  @author: Herve Menager
  @author: Bertrand Neron
  @organization: Institut Pasteur
  @contact:mobyle@pasteur.fr
  """
      
  def process(self):
    # program exists on the Server
    try:
      self.job = Mobyle.MobyleJob.MobyleJob(ID=self.request.getfirst('jobid'))
      sl = ServiceLocator()
      self.progFileName = sl[self.job.jobState.getName()]
    except MobyleError, me:
      self.error_msg = "This job does not exist."
      self.progFileName = ""
      return
    self.xmlUrl = self.job.getJobid() +'/index.xml'

  def render(self):
    self.xslParams = {u'isInPortal': u'true',u'local': u'no',u'serviceXmlUri': self.progFileName,u'previewDataLimit':self.cfg.previewDataLimit()}
    self.xsltUri = os.path.join(os.environ[ 'DOCUMENT_ROOT' ] , self.cfg.htdocs_url() , "xsl", "job.xsl" ) 
    super(JobStatus,self).render()
      
if __name__ == "__main__":
  js = mb_cgi.SessionCGI(JobStatus())
  js.process()
  js.read_session()
  js.render()

