#! /usr/bin/env python
import mb_cgi
import sys,os,time
import Mobyle.MobyleJob 
import Mobyle.Parser 
from Mobyle.MobyleError import *
from Mobyle.Utils import ServiceLocator

class JobSubmit(mb_cgi.JSONCGI):
  """
  This class is a CGI interface to the MobyleJob class.
  Usage: - calling it with a job id loads the given job during the object creation,
  otherwise a new job is created and launched.
  @author: Herve Menager
  @author: Bertrand Neron
  @organization: Institut Pasteur
  @contact:mobyle@pasteur.fr
  """
      
  def process(self):
    try:
      #1. Loading the CGI form values
      # backup dir before to run job
      self.osDir = os.getcwd()           
      #2. Creating the service description from the corresponding file
      try:
        self.progName = str(self.request.getfirst('programName'))
      except KeyError:
        raise MobyleError,"The job execution request must specify a program to execute."
      sl = ServiceLocator()
      self.progFileName = sl[self.progName]
      parser = Mobyle.Parser.ServiceParser(self.cfg)
      self.service  = parser.parse(self.progFileName)
      #4. check the e-mail
      try:
        email = self.request.getfirst('email')
        if email == '':
          opt_email = self.cfg.opt_email()
          if not opt_email:
            try:
              ua = os.environ[ 'HTTP_USER_AGENT' ]
            except KeyError:
              ua = None
            if ua == "MobyleClt": #pourquoi
              email = None
          else:
            email = None
      except KeyError:
        try:
          ua = os.environ['HTTP_USER_AGENT']
        except KeyError:
          #qui essaye de me scripter?
          ua = None
        if ua == "MobyleClt":
          email = None
      #5. instanciate the job
      self.job = Mobyle.MobyleJob.MobyleJob( service = self.service ,
                                                 email = email, session=self.session )
      # set the email's value from the job's in the session
      if(not(self.session.isAuthenticated()) and self.job.email):
        self.session.setEmail(self.job.email)
      # add job to the session
      date = self.job.getDate()
      self.session.addJob( self.job.getJobid() , date = date , status = 0)
      #6. set parameter values - here only user input parameters (e.g., not hidden, not command, inputs) are set
      for paramName in self.service.getUserInputParameterByArgpos():
        inputName = self.progName + '_' + paramName # now param names are prefixed with program name to avoid name collision between inputs that have the same parameter name
        if self.service.isInfile( paramName ):
          inputMode= self.request.getfirst('dataInputType_' + inputName,"upload")
          safeFileName = None
          if self.request.has_key(inputName) and hasattr(self.request[inputName],'file'):
            p = self.request[inputName]
            if p.file!=None:
              fileContent = p.file.read()
              fileName = p.filename
            else: # such a case should not exist, as any infile should be sent as a parameter with a "_data" suffix, but we manage it just in case...
              fileContent = p.value
              fileName = p.filename
            if p.filename==None:
              fileName = paramName + ".data"
          elif self.request.has_key(inputName+"_sname"):
            safeFileName = self.request.getfirst(inputName+"_sname")
            fileContent = self.session.getContentData(safeFileName)
            fileName = self.request.getfirst(inputName+"_uname")
          else:
            fileContent = self.request.getfirst(inputName+"_data")
            fileName = paramName + ".data"
          if fileContent==None:
            if not(not(self.service.ismandatory( paramName )) or self.service.precondHas_proglang(paramName,'python')):
              # do not try to set a parameter that is not mandatory and has no value
              # otherwise, raise an error
              raise UserValueError(parameter=self.service.getParameter(paramName), msg=("No value for mandatory parameter %s" % paramName))
          else:
            # If the parameter is a "databox parameter" then we first add it to the session and then add it to the job
            if not(safeFileName):
              try:
                safeFileName = self.session.addDatas( fileName , self.service.getParameter( paramName ).getType(), content = fileContent , inputModes = [inputMode], usedBy=self.job.getJobid())
              except UserValueError, e:
                # if we have invalid data, we still try to set them as job parameter values so that the job status is error (and not building) and to make the problem easier to understand for admins
                self.job.setValue( paramName , ( fileName , fileContent , None , None ) )
                #e.param = self.service.getParameter(paramName)
                raise e
              except NoSpaceLeftError, e:
                e.param = self.service.getParameter(paramName)
                raise e
            userDataName = self.session.getUserFileName( safeFileName )
            self.job.setValue( paramName , ( userDataName , None , self.session , safeFileName ) )
        else:
          # otherwise we just set the value in the job
          if (self.service.getDataType(paramName).getName()=='Boolean'): # for a boolean, no value = False...
            p = self.request.getfirst(inputName, False)
            self.job.setValue( paramName , p)
          else:
            p = self.request.getfirst(inputName, None) # for other parameter types, no value = set no value...
            if (not(p is None)):
              self.job.setValue( paramName , p)                
      #6. run Job
      self.job.run() #here, we wait for a certain time to check if the job completes quickly
    except (UserValueError), e:
      self.errormsg=e.msg
      if e.param:
        self.errorparam = e.param.getName()
      if hasattr(self,"job") and self.job:
        self.session.removeJob(self.job.getJobid())
    except NoSpaceLeftError, e:
      self.errormsg=str(e)
      if e.param:
        self.errorparam = e.param.getName()
      if hasattr(self,"job") and self.job:
        self.session.removeJob(self.job.getJobid())
    except Exception, e:
      if self.progName and self.cfg.debug(self.progName)>0:
        self.errormsg=str("Mobyle system error (for debugging purposes only): " + str(e))
      else:
        self.errormsg="A server error occured during the submission of your job. Please contact the server's administrator to report this problem"
      #raise e


  def render(self):
    render = self.request.getfirst("render","json")
    if render=="text":
      if hasattr(self, "job"):
        self.text = str(self.job.getJobid())
        super(mb_cgi.JSONCGI,self).render()
    else:
      if hasattr(self, "job"):
        self.jsonMap['id'] = str(self.job.getJobid())
        self.jsonMap['date'] = str(time.strftime( "%x  %X", self.job.getDate()))
        self.jsonMap['status'] = self.job.getStatus()[0]
      if hasattr(self, "errormsg"):
        self.jsonMap['errormsg'] = self.errormsg
      if hasattr(self, "errorparam"):
        self.jsonMap['errorparam'] = self.errorparam
      super(JobSubmit,self).render()
    
      
if __name__ == "__main__":
  try:
    js = mb_cgi.SessionCGI(JobSubmit())
    js.process()
    js.read_session()
    js.render()
  except Exception, e:
    js.c_log.error(e)
