#! /usr/bin/env python

import State
import sys,os,time
import Mobyle.MobyleJob 
import Mobyle.Parser 
from Mobyle.MobyleError import *
from Mobyle.Utils import ServiceLocator

class JobCGI(State.State):
  """
  This class is a CGI interface to the MobyleJob class.
  Usage: - calling it with a job id loads the given job during the object creation,
  otherwise a new job is created and launched.
         - the 'action' parameter determines the response: either job id, html, or xml
  @author: Herve Menager
  @author: Bertrand Neron
  @organization: Institut Pasteur
  @contact:mobyle@pasteur.fr
  """
  
  cache = False
  """ jobcgi should never be cached... """
    
  def init2(self):
    self.jobid = "http://raclette-adm4.calcul.pasteur.fr/Mobyle/Results/cons/O10925791214943"
    self.jobid2 = "file:///pasteur/mobyle/htdocs/Mobyle/Results/cons/O10925791214943"
    try:
      self.job = Mobyle.MobyleJob.MobyleJob(ID=self.jobid)
      sl = ServiceLocator()
      self.progFileName = sl[self.job.jobState.getName()]
      self.c_log.debug(self.progFileName)
      self.readSession()
      html = self.__renderHTML3__()
    except Exception, exc:
      import traceback, StringIO
      State.sys.stderr = StringIO.StringIO()
      traceback.print_exc()
      self.c_log.error(sys.stderr.getvalue())
      
  def __renderHTML__(self):
    self.xmlUrl = self.jobid +'/index.xml'
    self.xslParams = {u'isInPortal': u'true',u'local': u'no',u'serviceXmlUri': self.progFileName}
    self.xsltUri = os.path.join(os.environ[ 'DOCUMENT_ROOT' ] , self.cfg.htdocs_url() , "xsl", "job.xsl" )
    self.c_log.debug(self.xmlUrl)
    self.c_log.debug(self.xsltUri)
    self.c_log.debug(self.progFileName)
    self.computeTemplate = self.computeXSL

  def __renderHTML2__(self):
    self.xmlUrl = self.jobid2 +'/index.xml'
    self.xsltUri = "file:///pasteur/mobyle/Mobyle/Src/Portal/htdocs/MobylePortal/xsl/job.xsl"
    self.progFileName = "file:///pasteur/mobyle/Mobyle/Programs/cons.xml"
    self.xslParams = {u'isInPortal': u'true',u'local': u'no',u'serviceXmlUri': self.progFileName}
    self.c_log.debug(self.xmlUrl)
    self.c_log.debug(self.xsltUri)
    self.c_log.debug(self.progFileName)
    self.computeTemplate = self.computeXSL

  def __renderHTML3__(self):
    self.xmlUrl = self.jobid +'/index.xml'
    self.xsltUri = "http://raclette-adm4.calcul.pasteur.fr/MobylePortal/xsl/jobutf8.xsl"
    self.progFileName = "file:///pasteur/mobyle/Mobyle/Programs/cons.xml"
    self.xslParams = {u'isInPortal': u'true',u'local': u'no',u'serviceXmlUri': self.progFileName}
    self.c_log.debug(self.xmlUrl)
    self.c_log.debug(self.xsltUri)
    self.c_log.debug(self.progFileName)
    self.computeTemplate = self.computeXSL
                                
      
if __name__ == "__main__":
  jobCGI = JobCGI()
