#! /usr/bin/env python
import mb_cgi
import time

class JobsList(mb_cgi.JSONCGI):
    """
    This class generates the sent SessionData to the client to construct 
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """
    
    def process( self ):
      jobsMap = []
      if self.session:
        tmpjobs = self.session.getJobs()
        # sort jobs on their job date
        def jobSort(j1,j2):
          if j1['date']>j2['date']:
            return 1
          if j2['date']>j1['date']:
            return -1
          return 0
        tmpjobs.sort(jobSort)
        for job in tmpjobs:
          if job['date']:
            jobdatestring = time.strftime( "%x  %X", job['date'])
          else:
            jobdatestring = '?'
          jobsMap.append({'id':job['jobID'],'programName': job['serviceName'] , 'jobDate': jobdatestring , 'status':job['status'] , 'dataUsed': job['dataUsed']})
      self.jsonMap = jobsMap

if __name__ == "__main__":
    jl = mb_cgi.SessionCGI(JobsList())
    jl.process()
    jl.render()