#! /usr/bin/env python
import mb_cgi
import os
import Mobyle.ConfigManager

class Portal(mb_cgi.TALCGI):
    """
    This class defines the I{Portal} component, the uppermost component.
    @todo This is where the session should be managed
    
    @author: Catherine Letondal
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    template_file = 'portal.html'

    def process(self):
      if self.session:
        self.response['authenticated'] = self.session.isAuthenticated()
        self.response['activated'] = self.session.isActivated()
        actkey = self.request.getfirst('actkey')
        if actkey:
          self.response['actkey'] = actkey
      else:
        self.response['sessionId'] = None
        self.response['authenticated'] = False
        self.response['activated'] = False
      self.response['anonymousSession'] = (self.cfg.anonymousSession()!='no')
      self.response['authenticatedSession'] = (self.cfg.authenticatedSession()!='no')
      self.response['sessionLimit']='%.2f'%(float(self.cfg.sessionlimit())/1000)
      
      openedForms=self.request.getfirst('form')
      if openedForms:
        self.response['openedForms'] = openedForms.split(',')
      openedJobs=self.request.getfirst('jobs')
      if openedJobs:
        self.response['openedJobs'] = openedJobs
      annFileName = os.path.normpath(os.path.join( os.environ['DOCUMENT_ROOT'],"MobylePortal/html/announcement.txt"))
      if os.path.isfile(annFileName):
        templateCacheFile = open (annFileName,'r')
        self.response['announcement'] = templateCacheFile.read()
        templateCacheFile.close()

if __name__ == "__main__":
    p = mb_cgi.SessionCGI(Portal())
    p.process()
    p.render()

