#! /usr/bin/env python
import mb_cgi
import os
import Mobyle.ConfigManager
import Mobyle.Utils
import Mobyle.ServicesTree as ServicesTree
import urllib # module used to encode the anchors in the menu html page

class ProgramsList(mb_cgi.TALCGI):
    """
    Generates the I{Programs Tree} component

    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    template_file = "programs_list.html"

    def process(self):
      """
      Uses the categories parser to retrieve the tree data
      """
      if self.request.has_key('isInPortal'):
        isInPortal = self.request.getfirst('isInPortal')
      else:
        isInPortal='false'

      self.getMaskAndFilterPrograms()

      self.response['filterOn'] = 'false'
      self.response['emptySearchResults'] = 'false'
      
      searchElements = [u'head/name', 
                        u'head/doc/title', 
                        u'head/doc/description/text',
                        u'parameter/name',
                        u'paragraph/name',
                        u'prompt',
                        u'comment/text',
                        u'authors',
                        u'reference'
                        ]
      
      sl = Mobyle.Utils.ServiceLocator()

      self.getMaskAndFilterPrograms()

      si = sl.items()
      paths = []
      for name,path in si:
        if (name in self.auth_services):
          paths.append(path)

      search_result = ServicesTree.search(paths,self.request.getfirst('searchString',None),searchElements)
      tree = ServicesTree.Tree(data=search_result)

      if self.request.getfirst('searchString'):
        self.response['filterOn'] = 'true'
        if len(tree.root.subcategories)==0:
          self.response['emptySearchResults'] = 'true'

      if isInPortal:
        self.response['isInPortal'] = isInPortal        
      self.response['tree'] = tree
      
    def getMaskAndFilterPrograms(self):
      ip = os.environ["REMOTE_ADDR"]
      pc = Mobyle.ConfigManager.PassChecker()
      self.mask = pc.getMask(ip)
      self.auth_services = pc[self.mask]
      return self.mask

      
if __name__ == "__main__":
  pl = ProgramsList()
  pl.process()
  pl.render()

