#! /usr/bin/env python
import mb_cgi
import Mobyle.Net

class SessionActivate(mb_cgi.JSONCGI):
    """
    This class signs in an authenticated session, with the specified email
    and password.
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    def process(self):
      try:
          assert self.request.getfirst('email'), "Please provide an e-mail"
          assert self.request.getfirst('password'), "Please provide a password"
          assert self.request.getfirst('actkey'), "Please provide a password"
      except AssertionError, ae:
        self.error_msg = str(ae)
        return
      try:
        email = Mobyle.Net.Email(self.request.getfirst('email'),self.cfg)
        password = self.request.getfirst('password')
        self.session = self.sessionFactory.getAuthenticatedSession(email,password)
        self.sessionKey = self.session.getKey()
        self.session.confirmEmail(self.request.getfirst('actkey'))
        self.jsonMap['accountOk'] = str(True)
      except Exception, e:
        self.jsonMap['accountOk'] = str(False)
        self.jsonMap['msg'] = str(e)

if __name__ == "__main__":
    sa = mb_cgi.SessionCGI(SessionActivate())
    sa.process()
    sa.read_session()
    sa.render()