#! /usr/bin/env python
import mb_cgi
import Mobyle.Net
from Mobyle.MobyleError import AuthenticationError, SessionError

class SessionSignIn(mb_cgi.JSONCGI):
    """
    This class signs in an authenticated session, with the specified email
    and password.
    
    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    def process(self):
      try:
          assert self.request.getfirst('email'), "Please provide an e-mail"
          assert self.request.getfirst('password'), "Please provide a password"
      except AssertionError, ae:
        self.error_msg = str(ae)
        return
      try:
        self.anonymousSession = self.session
        email = Mobyle.Net.Email(self.request.getfirst('email'),self.cfg)
        password = self.request.getfirst('password')
        self.session = self.sessionFactory.getAuthenticatedSession(email,password)
        if self.anonymousSession:
          self.session.mergeWith(self.anonymousSession)
        self.sessionKey = self.session.getKey()
        self.jsonMap['accountOk'] = str(True)
      except SessionError, e:
        self.jsonMap['accountOk'] = str(False)        
        self.error_msg = str(e)

if __name__ == "__main__":
    ssi = mb_cgi.SessionCGI(SessionSignIn())
    try:
      ssi.process()
    except mb_cgi.CGIUserValueError, e:
      pass
    ssi.read_session()
    ssi.render()

