#! /usr/bin/env python
import mb_cgi
import os
import time
import datetime
import Mobyle.ConfigManager
import Mobyle.Utils
import urllib # module used to encode the anchors in the menu html page

class SiteMap(mb_cgi.TALCGI):
    """
    Generates the SiteMap used for robots indexing

    @author: Herve Menager
    @organization: Institut Pasteur
    @contact:mobyle@pasteur.fr
    """

    template_file = "sitemap.xml"

    def process(self):
      """
      Uses the categories parser to retrieve the tree data
      """
      if self.request.has_key('isInPortal'):
        isInPortal = self.request.getfirst('isInPortal')
      else:
        isInPortal='false'

      self.getMaskAndFilterPrograms()

      sl = Mobyle.Utils.ServiceLocator()
      csl = []
      for si in sl.items():
        cs = {}
        cs['name'] = si[0]
        cs['mtime'] = datetime.datetime.fromtimestamp(os.path.getmtime(si[1])).isoformat()
        csl.append(cs)
      self.response['baseurl'] = os.path.join(self.cfg.root_url(), self.cfg.cgi_url(),'portal.py')
      self.response['programs'] = csl
      
    def getMaskAndFilterPrograms(self):
      ip = os.environ["REMOTE_ADDR"]
      pc = Mobyle.ConfigManager.PassChecker()
      self.mask = pc.getMask(ip)
      self.auth_services = pc[self.mask]
      return self.mask

      
if __name__ == "__main__":
  pl = SiteMap()
  pl.process()
  pl.render()